/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSAdmin;
import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.DSEntryBoolean;
import com.netscape.admin.dirserv.panel.DSEntryInteger;
import com.netscape.admin.dirserv.panel.DSEntrySet;
import com.netscape.admin.dirserv.panel.DSEntryText;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPUrl;

public class ServerSettingsPanel
extends BlankPanel {
    private JTextField _tfPort;
    private JLabel _lEncryptedPort;
    private JTextField _tfEncryptedPort;
    private JLabel _lReferral;
    private JTextField _tfReferral;
    private JCheckBox _cbTrackModifies;
    private JCheckBox _cbSchemaChecking;
    private JCheckBox _cbIsReadOnly;
    private boolean _isConfigurationDir;
    private boolean _isSSLEnabled;
    private DSEntryPort _portDSEntry;
    private DSEntryPort _encryptedPortDSEntry;
    private static final String SERVERSETTINGS_DN = "cn=config";
    private static final String SERVERSETTINGS_ENCRYPTED_PORT_ATTR_NAM = "nsslapd-secureport";
    private static final String SERVERSETTINGS_PORT_ATTR_NAM = "nsslapd-port";
    private static final String SERVERSETTINGS_ENABLED_ATTR_NAM = "nsslapd-ntsynch";
    private static final String SERVERSETTINGS_SYNCH_SSL_ATTR_NAM = "nsslapd-NTSynch-SSL";
    private static final String SERVERSETTINGS_SYNCHPORT_ATTR_NAM = "nsslapd-ntsynch-port";
    private static final String REFERRAL_ATTR_NAM = "nsslapd-referral";
    private static final String TRACKMODIFIES_ATTR_NAM = "nsslapd-lastmod";
    private static final String SCHEMACHECKING_ATTR_NAM = "nsslapd-schemacheck";
    private static final String READ_ONLY_ATTR_NAM = "nsslapd-readonly";
    private static final int LIMIT_MIN_VAL = 0;
    private static final int LIMIT_MAX_VAL = 65535;
    private static final int PORT_NUM_MIN_VAL = 0;
    private static final int PORT_NUM_MAX_VAL = 65535;
    private ResourceSet _resource = DSUtil._resource;
    private static final String _section = "serversettings";

    public ServerSettingsPanel(IDSModel iDSModel) {
        super(iDSModel, _section);
        this._helpToken = "configuration-system-settings-help";
        this._refreshWhenSelect = false;
    }

    public void init() {
        if (this._isInitialized) {
            return;
        }
        this._isConfigurationDir = this.isConfigurationDir();
        this._isSSLEnabled = this.isSSLEnabled();
        this._tfPort = this.makeNumericalJTextField(_section, "port");
        JLabel jLabel = this.makeJLabel(_section, "port");
        jLabel.setLabelFor(this._tfPort);
        this._tfEncryptedPort = this.makeNumericalJTextField(_section, "encryptedport");
        JLabel jLabel2 = this.makeJLabel(_section, "encryptedport");
        jLabel2.setLabelFor(this._tfEncryptedPort);
        this._tfReferral = this.makeJTextField(_section, "referral");
        this._lReferral = this.makeJLabel(_section, "referral");
        this._lReferral.setLabelFor(this._tfReferral);
        this._cbTrackModifies = this.makeJCheckBox(_section, "trackModifies");
        this._cbSchemaChecking = this.makeJCheckBox(_section, "schemaChecking");
        this._cbIsReadOnly = this.makeJCheckBox(_section, "isReadOnly");
        DSEntrySet dSEntrySet = this.getDSEntrySet();
        this._portDSEntry = new DSEntryPort(null, this._tfPort, jLabel, 0, 65535, 1, "nsserverport");
        dSEntrySet.add(SERVERSETTINGS_DN, SERVERSETTINGS_PORT_ATTR_NAM, this._portDSEntry);
        this.setComponentTable(this._tfPort, this._portDSEntry);
        this._encryptedPortDSEntry = new DSEntryPort(null, this._tfEncryptedPort, jLabel2, 0, 65535, 1, "nssecureserverport");
        dSEntrySet.add(SERVERSETTINGS_DN, SERVERSETTINGS_ENCRYPTED_PORT_ATTR_NAM, this._encryptedPortDSEntry);
        this.setComponentTable(this._tfEncryptedPort, this._encryptedPortDSEntry);
        ReferralText referralText = new ReferralText(this._tfReferral, this._lReferral);
        dSEntrySet.add(SERVERSETTINGS_DN, REFERRAL_ATTR_NAM, referralText);
        this.setComponentTable(this._tfReferral, referralText);
        DSEntryBoolean dSEntryBoolean = new DSEntryBoolean(null, this._cbTrackModifies);
        dSEntrySet.add(SERVERSETTINGS_DN, TRACKMODIFIES_ATTR_NAM, dSEntryBoolean);
        this.setComponentTable(this._cbTrackModifies, dSEntryBoolean);
        DSEntryBoolean dSEntryBoolean2 = new DSEntryBoolean(null, this._cbSchemaChecking);
        dSEntrySet.add(SERVERSETTINGS_DN, SCHEMACHECKING_ATTR_NAM, dSEntryBoolean2);
        this.setComponentTable(this._cbSchemaChecking, dSEntryBoolean2);
        DSEntryBoolean dSEntryBoolean3 = new DSEntryBoolean(null, this._cbIsReadOnly);
        dSEntrySet.add(SERVERSETTINGS_DN, READ_ONLY_ATTR_NAM, dSEntryBoolean3);
        this.setComponentTable(this._cbIsReadOnly, dSEntryBoolean3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = this._myPanel;
        jPanel.setLayout(new GridBagLayout());
        GroupPanel groupPanel = new GroupPanel(this._resource.getString(_section, "network-group-title"));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = (Insets)this.getComponentInsets().clone();
        int n = UIFactory.getComponentSpace();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)groupPanel, gridBagConstraints);
        groupPanel.setLayout(new GridBagLayout());
        this.addEntryField(groupPanel, jLabel, this._tfPort);
        this.addEntryField(groupPanel, jLabel2, this._tfEncryptedPort);
        this.addEntryField(groupPanel, this._lReferral, this._tfReferral);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        groupPanel.add(Box.createVerticalStrut(n), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 14, 6, 0);
        jPanel.add((Component)this._cbIsReadOnly, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.top = 0;
        jPanel.add((Component)this._cbTrackModifies, gridBagConstraints);
        jPanel.add((Component)this._cbSchemaChecking, gridBagConstraints);
        this.addBottomGlue();
        this._isInitialized = true;
    }

    boolean isConfigurationDir() {
        ConsoleInfo consoleInfo = this.getModel().getServerInfo();
        ConsoleInfo consoleInfo2 = this.getModel().getConsoleInfo();
        int n = consoleInfo.getPort();
        int n2 = consoleInfo2.getPort();
        String string = consoleInfo.getHost();
        String string2 = consoleInfo2.getHost();
        return n == n2 && string.equals(string2);
    }

    boolean isSSLEnabled() {
        JFrame jFrame = UtilConsoleGlobals.getActivatedFrame();
        if (jFrame == null || !(jFrame instanceof DSFramework)) {
            return false;
        }
        DSFramework dSFramework = (DSFramework)((Object)jFrame);
        DSAdmin dSAdmin = dSFramework.getServerObject();
        try {
            return dSAdmin != null && dSAdmin.getSecurityState() == DSAdmin.SECURITY_ENABLE;
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean isConfigDirPortChanged() {
        if (!this._isConfigurationDir) {
            return false;
        }
        if (this._isSSLEnabled && this._encryptedPortDSEntry.isChanged()) {
            return true;
        }
        return this._portDSEntry.isChanged();
    }

    boolean confirmPortChange() {
        IDSModel iDSModel = this.getModel();
        int n = DSUtil.showConfirmationDialog((Component)iDSModel.getFrame(), "confirmPortChange", (String)null, "general");
        return n == 0;
    }

    public void okCallback() {
        if (this.isConfigDirPortChanged() && !this.confirmPortChange()) {
            return;
        }
        super.okCallback();
    }

    private static boolean hasBalancedQuotes(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            if (stringBuffer.charAt(n2) == '\"') {
                ++n;
            }
            ++n2;
        }
        return n % 2 == 0;
    }

    private static Vector parseString(String string) {
        Vector<String> vector = new Vector<String>();
        if (!ServerSettingsPanel.hasBalancedQuotes(string)) {
            vector.addElement("");
            return vector;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.replace('\"', ' '));
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return vector;
    }

    class ReferralText
    extends DSEntryText {
        ReferralText(JTextField jTextField, JLabel jLabel) {
            super(null, jTextField, jLabel);
        }

        public void show() {
            String string = "";
            if (this.getModelSize() < 2) {
                string = this.getModel(0).trim();
            } else {
                string = "\"";
                int n = 0;
                while (n < this.getModelSize()) {
                    string = string + this.getModel(n).trim() + "\"";
                    if (n < this.getModelSize() - 1) {
                        string = string + " \"";
                    }
                    ++n;
                }
            }
            Debug.println((String)("ServerSettingsPanel.ReferralText.show: <" + string + ">"));
            ServerSettingsPanel.this._tfReferral.setText(string);
            this.viewInitialized();
        }

        protected void updateModel() {
            this.clearModel();
            String string = ServerSettingsPanel.this._tfReferral.getText().trim();
            if (string.length() > 0) {
                Vector vector = ServerSettingsPanel.parseString(string);
                int n = 0;
                while (n < vector.size()) {
                    this.setModelAt((String)vector.elementAt(n), n);
                    ++n;
                }
            }
        }

        public int validate() {
            JTextField jTextField = (JTextField)this.getView(0);
            String string = jTextField.getText().trim();
            if (!ServerSettingsPanel.hasBalancedQuotes(string)) {
                return 1;
            }
            Vector vector = ServerSettingsPanel.parseString(string.toLowerCase());
            int n = 0;
            while (n < vector.size()) {
                string = (String)vector.elementAt(n);
                try {
                    LDAPUrl lDAPUrl = new LDAPUrl(string);
                    if (lDAPUrl.getPort() > 65535) {
                        return 1;
                    }
                }
                catch (Exception exception) {
                    return 1;
                }
                ++n;
            }
            return 0;
        }
    }

    class DSEntryPort
    extends DSEntryInteger {
        private String _attrName;
        private JTextField _tf;
        private int _origPort;

        DSEntryPort(String string, JComponent jComponent, JComponent jComponent2, int n, int n2, int n3, String string2) {
            super(string, jComponent, jComponent2, n, n2, n3);
            this._attrName = string2;
            this._tf = (JTextField)jComponent;
        }

        public void show() {
            this._origPort = this.getModelValue();
            super.show();
        }

        public boolean isChanged() {
            int n = this.getModelValue();
            return n != this._origPort;
        }

        public void store() {
            IDSModel iDSModel = ServerSettingsPanel.this.getModel();
            ConsoleInfo consoleInfo = iDSModel.getServerInfo();
            int n = consoleInfo.getPort();
            int n2 = this.getModelValue();
            String string = this.getModel(0);
            super.store();
            if (n2 == this._origPort) {
                return;
            }
            String string2 = iDSModel.getConsoleInfo().getCurrentDN();
            try {
                LDAPConnection lDAPConnection = iDSModel.getConsoleInfo().getLDAPConnection();
                LDAPModification lDAPModification = new LDAPModification(2, new LDAPAttribute(this._attrName, string));
                lDAPConnection.modify(string2, lDAPModification);
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("ServerSettingsPanel.encryptedPortDSEntry.store(): to " + string2 + " " + (Object)((Object)lDAPException)));
                this.setDirty(true);
            }
            this._origPort = n2;
        }
    }
}

