/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GlobalConstants;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.replication.AgreementPanel;
import com.netscape.admin.dirserv.panel.replication.AgreementWizard;
import com.netscape.admin.dirserv.panel.replication.AgreementWizardInfo;
import com.netscape.admin.dirserv.panel.replication.IReplicationResourceObject;
import com.netscape.admin.dirserv.panel.replication.ReplicaResourceObject;
import com.netscape.admin.dirserv.panel.replication.ReplicationAgreement;
import com.netscape.admin.dirserv.panel.replication.ReplicationResourceObject;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class AgreementResourceObject
extends ResourceObject
implements IMenuInfo,
ActionListener {
    protected String[] _categoryID;
    protected IMenuItem[] _contextMenuItems;
    protected IMenuItem[] _objectMenuItems;
    ReplicationAgreement _agreement;
    IReplicationResourceObject _owner;
    private ResourceObject _gparent;
    private AgreementPanel _panel = null;
    public static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.panel.replication.replication");
    static final String NEW = "newAgreement";
    static final String DELETE = "deleteAgreement";
    static final String COPY = "copyAgreement";
    static final String UPDATE = "updateAgreement";
    static final String INIT = "initAgreement";
    static final String CREATE = "createLDIF";

    AgreementResourceObject() {
    }

    AgreementResourceObject(String string) {
        super(string);
    }

    AgreementResourceObject(String string, Icon icon, Icon icon2, IReplicationResourceObject iReplicationResourceObject) {
        super(string, icon, icon2);
        this._owner = iReplicationResourceObject;
        this._gparent = null;
    }

    AgreementResourceObject(String string, Icon icon, Icon icon2, IReplicationResourceObject iReplicationResourceObject, ResourceObject resourceObject) {
        super(string, icon, icon2);
        this._owner = iReplicationResourceObject;
        this._gparent = resourceObject;
    }

    void setAgreement(ReplicationAgreement replicationAgreement) {
        this._agreement = replicationAgreement;
    }

    IDSModel getResourceModel() {
        return this._owner.getModel();
    }

    JFrame getFrame() {
        return this._owner.getModel().getFrame();
    }

    public Component getCustomPanel() {
        if (this._panel == null) {
            this._panel = new AgreementPanel(this.getFrame(), this.getResourceModel(), this._agreement);
        }
        return this._panel;
    }

    public boolean isLeaf() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        LDAPEntry lDAPEntry;
        this.getResourceModel().setWaitCursor(true);
        if (actionEvent.getActionCommand().equals("refresh") && (lDAPEntry = this.reloadEntry()) == null && this._owner instanceof ReplicaResourceObject) {
            ((ReplicaResourceObject)this._owner).reload();
            ((ReplicaResourceObject)this._owner).refreshTree();
        }
        this.getResourceModel().setWaitCursor(false);
    }

    private LDAPEntry reloadEntry() {
        LDAPEntry lDAPEntry;
        block3: {
            LDAPConnection lDAPConnection = this.getResourceModel().getServerInfo().getLDAPConnection();
            lDAPEntry = null;
            try {
                if (this._agreement != null) {
                    lDAPEntry = lDAPConnection.read(this._agreement.getOrigEntryDN());
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("AgreementResourceObject.reloadEntry(): " + (Object)((Object)lDAPException)));
                if (lDAPException.getLDAPResultCode() == 32) break block3;
                DSUtil.showLDAPErrorDialog(this.getResourceModel().getFrame(), lDAPException, "fetching-directory");
            }
        }
        return lDAPEntry;
    }

    public String[] getMenuCategoryIDs() {
        if (this._categoryID == null) {
            this._categoryID = new String[]{"OBJECT", "CONTEXT"};
        }
        return this._categoryID;
    }

    public IMenuItem[] getMenuItems(String string) {
        if (string.equals("CONTEXT")) {
            if (this._contextMenuItems == null) {
                this._contextMenuItems = this.createMenuItems();
            }
            return this._contextMenuItems;
        }
        if (string.equals("OBJECT")) {
            if (this._objectMenuItems == null) {
                this._objectMenuItems = this.createMenuItems();
            }
            return this._objectMenuItems;
        }
        return null;
    }

    private IMenuItem[] createMenuItems() {
        String string = "replication-node-agreementPopupMenu";
        return new IMenuItem[]{new MenuItemText(NEW, _resource.getString(string, "New"), _resource.getString(string, "New-description")), new MenuItemText(DELETE, _resource.getString(string, "Delete"), _resource.getString(string, "Delete-description")), new MenuItemText(COPY, _resource.getString(string, "Copy"), _resource.getString(string, "Copy-description")), new MenuItemText(UPDATE, _resource.getString(string, "SendUpdatesNow"), _resource.getString(string, "SendUpdatesNow-description")), new MenuItemText(INIT, _resource.getString(string, "InitConsumer"), _resource.getString(string, "InitConsumer-description")), new MenuItemText(CREATE, _resource.getString(string, "CreateLDIF"), _resource.getString(string, "CreateLDIF-description")), new MenuItemSeparator(), new MenuItemText("refresh", DSUtil._resource.getString("menu", "refresh"), DSUtil._resource.getString("menu", "refresh-description"))};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        int n;
        AgreementWizard agreementWizard;
        Object object;
        block34: {
            Object object2;
            this.getResourceModel().setWaitCursor(true);
            if (iMenuItem.getID().equals("refresh")) {
                object = this.reloadEntry();
                if (object == null && this._owner instanceof ReplicaResourceObject) {
                    ((ReplicaResourceObject)this._owner).reload();
                    ((ReplicaResourceObject)this._owner).refreshTree();
                }
                this._panel.actionPerformed(new ActionEvent(this, 1001, "refresh"));
            } else if (iMenuItem.getID().equals(NEW)) {
                if (!ReplicationTool.authenticate(this.getResourceModel())) {
                    this.getResourceModel().setWaitCursor(false);
                    return;
                }
                int n2 = ((DefaultMutableTreeNode)((Object)((ReplicaResourceObject)this._owner))).getChildCount();
                object2 = new AgreementWizardInfo();
                ((AgreementWizardInfo)object2).setServerInfo(this.getResourceModel().getServerInfo());
                ((AgreementWizardInfo)object2).setConsoleInfo(this.getResourceModel().getConsoleInfo());
                ((AgreementWizardInfo)object2).setParentNode(this._owner);
                ((AgreementWizardInfo)object2).setWizardType("NEW");
                ((AgreementWizardInfo)object2).setLDAPSchema(this.getResourceModel().getSchema());
                agreementWizard = new AgreementWizard(this.getFrame(), (AgreementWizardInfo)object2);
                n = ((DefaultMutableTreeNode)((Object)((ReplicaResourceObject)this._owner))).getChildCount();
                Debug.println((String)("AgreementResourceObject.actionMenuSelected() newChildCount " + n + " oldChildCount " + n2));
                if (n <= n2) {
                    if (this._gparent instanceof ReplicationResourceObject) {
                        ((ReplicationResourceObject)this._gparent).reload();
                        ((ReplicationResourceObject)this._gparent).refreshTree();
                    }
                } else if (this._owner instanceof ReplicaResourceObject) {
                    ((ReplicaResourceObject)this._owner).expandPath((ResourcePage)iPage);
                }
            }
            if (iMenuItem.getID().equals(DELETE)) {
                if (!ReplicationTool.authenticate(this.getResourceModel())) {
                    this.getResourceModel().setWaitCursor(false);
                    return;
                }
                int n3 = 0;
                if (DSUtil.requiresConfirmation(GlobalConstants.PREFERENCES_CONFIRM_DELETE_AGREEMENT)) {
                    object2 = _resource.getString("replication-node-dialog", DELETE);
                    n3 = DSUtil.showConfirmationDialog((Component)this.getFrame(), "warning", (String)object2, "replication-dialog");
                }
                if (n3 == 0) {
                    boolean bl = false;
                    try {
                        try {
                            this._agreement.deleteAgreementFromServer();
                            bl = true;
                        }
                        catch (LDAPException lDAPException) {
                            Debug.println((String)("AgreementResourceObject: actionMenuSelected() -delete" + lDAPException.toString()));
                            String string = _resource.getString("replication-node-dialog", "cannotDeleteAgreement");
                            DSUtil.showErrorDialog((Component)this.getFrame(), "error", string, "replication-dialog");
                            Object var8_16 = null;
                            if (!bl || !(this._owner instanceof ReplicaResourceObject)) break block34;
                            ((ReplicaResourceObject)this._owner).reload();
                            ((ReplicaResourceObject)this._owner).refreshTree();
                            if (!((ReplicaResourceObject)this._owner).isLeaf()) {
                                ((ReplicaResourceObject)this._owner).expandPath((ResourcePage)iPage);
                            }
                            break block34;
                        }
                        Object var8_15 = null;
                        if (!bl) break block34;
                    }
                    catch (Throwable throwable) {
                        Object var8_17 = null;
                        if (bl && this._owner instanceof ReplicaResourceObject) {
                            ((ReplicaResourceObject)this._owner).reload();
                            ((ReplicaResourceObject)this._owner).refreshTree();
                            if (!((ReplicaResourceObject)this._owner).isLeaf()) {
                                ((ReplicaResourceObject)this._owner).expandPath((ResourcePage)iPage);
                            }
                        }
                        throw throwable;
                    }
                    if (this._owner instanceof ReplicaResourceObject) {
                        ((ReplicaResourceObject)this._owner).reload();
                        ((ReplicaResourceObject)this._owner).refreshTree();
                        if (!((ReplicaResourceObject)this._owner).isLeaf()) {
                            ((ReplicaResourceObject)this._owner).expandPath((ResourcePage)iPage);
                        }
                    }
                }
            }
        }
        if (iMenuItem.getID().equals(COPY)) {
            if (!ReplicationTool.authenticate(this.getResourceModel())) {
                this.getResourceModel().setWaitCursor(false);
                return;
            }
            int n4 = ((DefaultMutableTreeNode)((Object)((ReplicaResourceObject)this._owner))).getChildCount();
            ((ReplicaResourceObject)this._owner).refreshTree();
            AgreementWizardInfo agreementWizardInfo = new AgreementWizardInfo();
            agreementWizardInfo.setServerInfo(this.getResourceModel().getServerInfo());
            agreementWizardInfo.setConsoleInfo(this.getResourceModel().getConsoleInfo());
            agreementWizardInfo.setCopyAgreement(this._agreement);
            agreementWizardInfo.setParentNode(this._owner);
            agreementWizardInfo.setWizardType("COPY");
            agreementWizardInfo.setLDAPSchema(this.getResourceModel().getSchema());
            agreementWizard = new AgreementWizard(this.getFrame(), agreementWizardInfo);
            n = ((DefaultMutableTreeNode)((Object)((ReplicaResourceObject)this._owner))).getChildCount();
            Debug.println((String)("AgreementResourceObject.actionMenuSelected() newChildCount " + n + " oldChildCount " + n4));
            if (n <= n4) {
                if (!agreementWizard.isCancelled() && this._gparent instanceof ReplicationResourceObject) {
                    ((ReplicationResourceObject)this._gparent).reload();
                    ((ReplicationResourceObject)this._gparent).refreshTree();
                }
            } else if (this._owner instanceof ReplicaResourceObject) {
                ((ReplicaResourceObject)this._owner).expandPath((ResourcePage)iPage);
            }
        }
        if (iMenuItem.getID().equals(UPDATE)) {
            if (!ReplicationTool.authenticate(this.getResourceModel())) {
                this.getResourceModel().setWaitCursor(false);
                return;
            }
            this._agreement.updateNow();
        }
        if (iMenuItem.getID().equals(INIT)) {
            if (!ReplicationTool.authenticate(this.getResourceModel())) {
                this.getResourceModel().setWaitCursor(false);
                return;
            }
            object = _resource.getString("replication-node-dialog", "InitConsumer");
            int n5 = DSUtil.showConfirmationDialog((Component)this.getFrame(), "warning", (String)object, "replication-dialog");
            if (n5 == 0) {
                this._agreement.initializeConsumer();
            }
        }
        if (iMenuItem.getID().equals(CREATE)) {
            this._agreement.populateLDIFFile(this.getResourceModel());
        }
        this.getResourceModel().setWaitCursor(false);
    }

    private String filterStatusMessage(String string) {
        int n;
        String string2 = null;
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(32);
        if (n2 == -1) {
            return null;
        }
        if ((n = string.indexOf(32, ++n2)) == -1) {
            return null;
        }
        String string3 = string.substring(n2, n);
        if (string3.equalsIgnoreCase(this._agreement.getEntryCN())) {
            string2 = string;
        }
        return string2;
    }
}

