/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.panel.replication.ReplicationAgreement;
import com.netscape.admin.dirserv.panel.replication.ServerInstance;
import com.netscape.admin.dirserv.wizard.WizardInfo;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.ResourceSet;
import java.util.Vector;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPSchema;

public class AgreementWizardInfo
extends WizardInfo {
    private static final String AGREEMENT_EXTENSION = "replication-";
    public static final String LEGACYR_AGREEMENT = "LEGACYR";
    public static final String MMR_AGREEMENT = "MMR";
    public static final String NEW_WIZARD = "NEW";
    public static final String COPY_WIZARD = "COPY";
    static final int SELATTR_ALL = 0;
    static final int SELATTR_INCLUDE = 1;
    static final int SELATTR_EXCLUDE = 2;
    public static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.panel.replication.replication");
    public static final boolean doFilteredReplication = false;
    public static final boolean doSelectiveReplication = false;

    public void setServerInfo(ConsoleInfo consoleInfo) {
        if (consoleInfo != null) {
            this._content.put("replication-serverinfo", consoleInfo);
        }
    }

    public ConsoleInfo getServerInfo() {
        return (ConsoleInfo)this._content.get("replication-serverinfo");
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        if (consoleInfo != null) {
            this._content.put("replication-consoleinfo", consoleInfo);
        }
    }

    public ConsoleInfo getConsoleInfo() {
        return (ConsoleInfo)this._content.get("replication-consoleinfo");
    }

    public void setSubtree(String string) {
        if (string != null) {
            this._content.put("replication-subtree", string);
        }
    }

    public String getSubtree() {
        return (String)this._content.get("replication-subtree");
    }

    public void setReplicaEntry(LDAPEntry lDAPEntry) {
        if (lDAPEntry != null) {
            this._content.put("replication-replicaentry", lDAPEntry);
        }
    }

    public LDAPEntry getReplicaEntry() {
        return (LDAPEntry)this._content.get("replication-replicaentry");
    }

    public void setAgreementType(String string) {
        if (string != null) {
            this._content.put("replication-type", string);
        }
    }

    public String getAgreementType() {
        return (String)this._content.get("replication-type");
    }

    public void setWizardType(String string) {
        if (string != null) {
            this._content.put("replication-wizard", string);
        }
    }

    public String getWizardType() {
        return (String)this._content.get("replication-wizard");
    }

    public void setLDAPSchema(LDAPSchema lDAPSchema) {
        if (lDAPSchema != null) {
            this._content.put("replication-schema", lDAPSchema);
        }
    }

    public LDAPSchema getLDAPSchema() {
        return (LDAPSchema)this._content.get("replication-schema");
    }

    void setName(String string) {
        if (string != null) {
            this._content.put("replication-name", string);
        }
    }

    String getName() {
        return (String)this._content.get("replication-name");
    }

    String getNickName() {
        return this.getName();
    }

    void setDescription(String string) {
        if (string != null) {
            this._content.put("replication-descr", string);
        }
    }

    String getDescription() {
        return (String)this._content.get("replication-descr");
    }

    void setFromServer(ServerInstance serverInstance) {
        if (serverInstance != null) {
            this._content.put("replication-from", serverInstance);
        }
    }

    ServerInstance getFromServer() {
        return (ServerInstance)this._content.get("replication-from");
    }

    void setToServer(ServerInstance serverInstance) {
        if (serverInstance != null) {
            this._content.put("replication-to", serverInstance);
        }
    }

    ServerInstance getToServer() {
        return (ServerInstance)this._content.get("replication-to");
    }

    void setSSL(boolean bl) {
        this._content.put("replication-ssl", new Boolean(bl));
    }

    boolean getSSL() {
        if (this._content.get("replication-ssl") != null) {
            return (Boolean)this._content.get("replication-ssl");
        }
        return false;
    }

    void setSSLAuth(boolean bl) {
        this._content.put("replication-sslauth", new Boolean(bl));
    }

    boolean getSSLAuth() {
        if (this._content.get("replication-sslauth") != null) {
            return (Boolean)this._content.get("replication-sslauth");
        }
        return false;
    }

    void setBindDN(String string) {
        if (string != null) {
            this._content.put("replication-binddn", string);
        } else {
            this._content.remove("replication-binddn");
        }
    }

    String getBindDN() {
        return (String)this._content.get("replication-binddn");
    }

    void setBindPWD(String string) {
        if (string != null) {
            this._content.put("replication-bindpwd", string);
        } else {
            this._content.remove("replication-bindpwd");
        }
    }

    String getBindPWD() {
        return (String)this._content.get("replication-bindpwd");
    }

    void setFilter(String string) {
        if (string != null) {
            this._content.put("replication-filter", string);
        }
    }

    String getFilter() {
        return (String)this._content.get("replication-filter");
    }

    void setSelectedAttr(Vector vector) {
        if (vector != null) {
            this._content.put("replication-attrs", vector);
        }
    }

    Vector getSelectedAttr() {
        return (Vector)this._content.get("replication-attrs");
    }

    void setAttrType(int n) {
        this._content.put("replication-attrtype", Integer.toString(n));
    }

    int getAttrType() {
        return Integer.parseInt((String)this._content.get("replication-attrtype"));
    }

    void setDate(Vector vector) {
        if (vector != null) {
            this._content.put("replication-date", vector);
        }
    }

    Vector getDate() {
        return (Vector)this._content.get("replication-date");
    }

    void setSyncInterval(int n) {
        this._content.put("replication-sync", Integer.toString(n));
    }

    int getSyncInterval() {
        try {
            return Integer.parseInt((String)this._content.get("replication-sync"));
        }
        catch (NumberFormatException numberFormatException) {
            return 5;
        }
    }

    void setInitialize(boolean bl) {
        this._content.put("replication-init", new Boolean(bl));
    }

    boolean getInitialize() {
        return (Boolean)this._content.get("replication-init");
    }

    void setLDIFFilename(String string) {
        this._content.put("replication-ldif", string);
    }

    String getLDIFFilename() {
        return (String)this._content.get("replication-ldif");
    }

    void removeLDIFFilename() {
        this._content.remove("replication-ldif");
    }

    void setCopyAgreement(ReplicationAgreement replicationAgreement) {
        if (replicationAgreement != null) {
            this._content.put("replication-copy", replicationAgreement);
        }
    }

    ReplicationAgreement getCopyAgreement() {
        return (ReplicationAgreement)this._content.get("replication-copy");
    }

    void setParentNode(Object object) {
        if (object != null) {
            this._content.put("replication-owner", object);
        }
    }

    Object getParentNode() {
        return this._content.get("replication-owner");
    }

    String prettyPrint() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getAgreementType() != null) {
            if (this.getAgreementType().equals(LEGACYR_AGREEMENT)) {
                stringBuffer.append(_resource.getString("replication-info", "legacyrDesc") + "\n");
            } else {
                stringBuffer.append(_resource.getString("replication-info", "mmrDesc") + "\n");
            }
        }
        if (this.getName() != null && !this.getName().equals("")) {
            stringBuffer.append("   ");
            stringBuffer.append(_resource.getString("replication-destination-name", "label") + ": ");
            stringBuffer.append(this.getName() + "\n");
        }
        if (this.getReplicaEntry() != null) {
            stringBuffer.append("   ");
            stringBuffer.append(_resource.getString("replication-destination-entry", "label") + ": ");
            stringBuffer.append(this.getReplicaEntry().getDN() + "\n");
        }
        if (this.getFromServer() != null) {
            stringBuffer.append("   ");
            stringBuffer.append(_resource.getString("replication-info-summary-from", "title") + ": ");
            stringBuffer.append(this.getFromServer().getKey() + "\n");
        }
        if (this.getToServer() != null) {
            stringBuffer.append("   ");
            stringBuffer.append(_resource.getString("replication-info-summary-to", "title") + ": ");
            stringBuffer.append(this.getToServer().getKey() + "\n");
        }
        if (this.getSSL()) {
            stringBuffer.append("   ");
            stringBuffer.append(_resource.getString("replication-destination-sslEncrypt", "label") + "\n");
        }
        stringBuffer.append("   ");
        stringBuffer.append(_resource.getString("replication-destination-authUsing", "label") + " ");
        if (this.getSSL() && this.getSSLAuth()) {
            stringBuffer.append(_resource.getString("replication-destination-sslClientAuth", "label") + "\n");
        } else {
            stringBuffer.append(_resource.getString("replication-destination-simpleAuth", "label") + "\n");
        }
        if (this.getSubtree() != null && !this.getSubtree().equals("")) {
            stringBuffer.append("   ");
            stringBuffer.append(_resource.getString("replication-info-summary-subtree", "label") + ": ");
            stringBuffer.append(this.getSubtree() + "\n");
        }
        if (!this.getAgreementType().equals(MMR_AGREEMENT)) {
            stringBuffer.append("   ");
            stringBuffer.append(_resource.getString("replication-schedule-checkSync", "label") + ": ");
            stringBuffer.append(this.getSyncInterval() + "\n");
        }
        if (this.getDate() != null) {
            string = (String)this.getDate().firstElement();
            stringBuffer.append("   ");
            stringBuffer.append(_resource.getString("replication-schedule-tab", "label") + ": ");
            if (!string.equals("")) {
                String string2 = this.date2Printable(string);
                stringBuffer.append(string2 + "\n");
            } else {
                stringBuffer.append(_resource.getString("replication-schedule-inSyncButton", "label") + "\n");
            }
        }
        if (this.getLDIFFilename() != null) {
            string = this.getLDIFFilename();
            stringBuffer.append("   ");
            stringBuffer.append(_resource.getString("replication-agreementWizard-initFile", "title") + ": ");
            stringBuffer.append(string + "\n");
        }
        return stringBuffer.toString();
    }

    private String date2Printable(String string) {
        int n = 10;
        int n2 = string.length();
        String[] stringArray = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, 10));
        while (n < n2 && Character.isDigit(string.charAt(n))) {
            int n3 = Character.digit(string.charAt(n), 10);
            String string2 = _resource.getString("replication-schedule-date" + stringArray[n3], "label");
            stringBuffer.append(string2 + " ");
            ++n;
        }
        return stringBuffer.toString();
    }
}

