/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.task;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.task.LDAPBasicProgressDialog;
import com.netscape.admin.dirserv.task.LDAPTask;
import com.netscape.management.client.util.Debug;
import java.util.Hashtable;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;

public class LDAPExport
extends LDAPTask {
    private final String EXPORT = "export";
    protected int _currentInstanceNumber;
    protected int _numberOfInstances;
    protected String _currentInstance;
    protected String[] _instanceValues;
    public String[] MANDATORY_ARGUMENTS = new String[]{"nsFilename", "nsInstance"};
    public String[] OPTIONAL_ARGUMENTS = new String[]{"nsIncludeSuffix", "nsExcludeSuffix", "nsUseOneFile", "nsExportReplica"};
    public static final String FILENAME = "nsFilename";
    public static final String INSTANCE = "nsInstance";
    public static final String INCLUDE_SUFFIX = "nsIncludeSuffix";
    public static final String EXCLUDE_SUFFIX = "nsExcludeSuffix";
    public static final String USE_ONE_FILE = "nsUseOneFile";
    public static final String EXPORT_REPLICA = "nsExportReplica";
    public static final String PRINT_KEY = "nsPrintKey";
    public static final String USE_ID2ENTRY = "nsUseId2Entry";
    public static final String NO_WRAP = "nsNoWrap";
    public static final String DUMP_UNIQUE_ID = "nsDumpUniqId";

    public LDAPExport(IDSModel iDSModel, Hashtable hashtable) {
        super(iDSModel, hashtable);
        this._taskType = "export";
        this._taskSection = "export";
        LDAPAttribute lDAPAttribute = (LDAPAttribute)hashtable.get(INSTANCE);
        this._instanceValues = lDAPAttribute.getStringValueArray();
        this._currentInstanceNumber = 1;
        this._currentInstance = this._instanceValues[this._currentInstanceNumber - 1];
        this._numberOfInstances = this._instanceValues.length;
        this.start();
    }

    public LDAPExport(IDSModel iDSModel) {
        this(iDSModel, null);
    }

    protected LDAPAttributeSet createTaskEntryAttributes() {
        LDAPAttribute lDAPAttribute;
        LDAPAttributeSet lDAPAttributeSet = super.createTaskEntryAttributes();
        int n = 0;
        while (n < this.MANDATORY_ARGUMENTS.length) {
            lDAPAttribute = (LDAPAttribute)this._attributes.get(this.MANDATORY_ARGUMENTS[n]);
            if (lDAPAttribute == null) {
                return null;
            }
            lDAPAttributeSet.add(lDAPAttribute);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.OPTIONAL_ARGUMENTS.length) {
            lDAPAttribute = (LDAPAttribute)this._attributes.get(this.OPTIONAL_ARGUMENTS[n2]);
            if (lDAPAttribute != null) {
                lDAPAttributeSet.add(lDAPAttribute);
            }
            ++n2;
        }
        return lDAPAttributeSet;
    }

    protected void createProgressDialog() {
        String string;
        String string2 = this.getTitle();
        this._progressDialog = new GenericProgressDialog(this.getModel().getFrame(), true, 6, string2, null, this);
        ((GenericProgressDialog)this._progressDialog).enableButtons(false);
        ((GenericProgressDialog)this._progressDialog).addStep(DSUtil._resource.getString(this._taskSection, "LDAPMode-firstStep-title"));
        ((GenericProgressDialog)this._progressDialog).addStep(DSUtil._resource.getString(this._taskSection, "LDAPMode-secondStep-title"));
        LDAPAttribute lDAPAttribute = (LDAPAttribute)this._attributes.get(FILENAME);
        String string3 = lDAPAttribute.getStringValueArray()[0];
        if (this._numberOfInstances > 1) {
            String[] stringArray = new String[]{DSUtil.abreviateString(this._currentInstance, 30), String.valueOf(this._currentInstanceNumber), String.valueOf(this._numberOfInstances), DSUtil.inverseAbreviateString(string3, 40)};
            string = DSUtil._resource.getString(this._taskSection, "LDAPMode-progresslabel-title", stringArray);
        } else {
            String[] stringArray = new String[]{DSUtil.abreviateString(this._currentInstance, 30), DSUtil.inverseAbreviateString(string3, 40)};
            string = DSUtil._resource.getString(this._taskSection, "LDAPMode-progresslabel-one-partition-title", stringArray);
        }
        ((GenericProgressDialog)this._progressDialog).setTextInLabel(string);
        this._statusProgressDialog = new LDAPBasicProgressDialog(this.getModel().getFrame(), DSUtil._resource.getString(this._taskSection, "LDAPMode-Status-title"), true, null, this);
        this._statusProgressDialog.waitForClose();
    }

    public String getTitle() {
        String string;
        String[] stringArray;
        LDAPAttribute lDAPAttribute = (LDAPAttribute)this._attributes.get(EXPORT_REPLICA);
        if (lDAPAttribute != null && (stringArray = (String[])lDAPAttribute.getStringValues().nextElement()).equalsIgnoreCase("TRUE")) {
            String string2;
            if (this._numberOfInstances == 1) {
                String[] stringArray2 = new String[]{this._currentInstance};
                string2 = DSUtil._resource.getString("export-replica", "title", stringArray2);
            } else {
                string2 = DSUtil._resource.getString("export", "title");
            }
            return string2;
        }
        if (this._numberOfInstances == 1) {
            stringArray = new String[]{this._currentInstance};
            string = DSUtil._resource.getString("export-partition", "title", stringArray);
        } else {
            string = DSUtil._resource.getString("export", "title");
        }
        return string;
    }

    protected void updateProgressDialog(Hashtable hashtable) {
        String string = (String)hashtable.get("nsTaskLog");
        if (string.lastIndexOf("Beginning export of '" + this._currentInstance) >= 0) {
            ((GenericProgressDialog)this._progressDialog).stepCompleted(0);
        }
        if (string.lastIndexOf(this._currentInstance + ": Processed") >= 0) {
            ((GenericProgressDialog)this._progressDialog).stepCompleted(1);
            if (this._currentInstanceNumber < this._numberOfInstances) {
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++this._currentInstanceNumber;
                this._currentInstance = this._instanceValues[this._currentInstanceNumber - 1];
                ((GenericProgressDialog)this._progressDialog).reset();
            }
        }
        if (this._numberOfInstances > 1) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)this._attributes.get(FILENAME);
            String string2 = lDAPAttribute.getStringValueArray()[0];
            String[] stringArray = new String[]{DSUtil.abreviateString(this._currentInstance, 30), String.valueOf(this._currentInstanceNumber), String.valueOf(this._numberOfInstances), DSUtil.inverseAbreviateString(string2, 40)};
            String string3 = DSUtil._resource.getString(this._taskSection, "LDAPMode-progresslabel-title", stringArray);
            ((GenericProgressDialog)this._progressDialog).setTextInLabel(string3);
        }
        this._statusProgressDialog.update(hashtable);
    }

    protected void finalizeTask(int n) {
        Debug.println((String)"LDAPExport.finalizeTask");
        switch (n) {
            case 0: {
                this._taskCancelled = true;
                break;
            }
            case 1: {
                this._taskCancelled = true;
                break;
            }
            case 2: {
                this._taskCancelled = true;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                ((GenericProgressDialog)this._progressDialog).stepCompleted(0);
                ((GenericProgressDialog)this._progressDialog).stepCompleted(1);
                break;
            }
            case 5: {
                String string = DSUtil._resource.getString("general", "LDAPTaskCompleted-unsuccessful-label");
                ((GenericProgressDialog)this._progressDialog).setTextInLabel(string);
            }
        }
        this._result = n;
        this.waitForClose();
    }

    public void run() {
        ((GenericProgressDialog)this._progressDialog).enableButtons(true);
        ((GenericProgressDialog)this._progressDialog).disableCancelButton();
        this.updateProgressDialog();
    }
}

