/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.task;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.task.LDAPErrorMessageDisplayer;
import com.netscape.admin.dirserv.task.LDAPTaskProgressDialog;
import com.netscape.management.client.TaskObject;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JDialog;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;

public class LDAPTask
extends TaskObject
implements ActionListener,
Runnable {
    public static final int INSUFFICIENT_ACCESS_RIGHTS_ERROR = 0;
    public static final int SERVER_UNAVAILABLE_ERROR = 1;
    public static final int SERVER_UPDATING_ERROR = 2;
    public static final int TASK_COMPLETED = 3;
    public static final int TASK_SUCCESSFULLY_COMPLETED = 4;
    public static final int TASK_UNSUCCESSFULLY_COMPLETED = 5;
    public static final int TASK_IN_PROGRESS = 6;
    public static final String CANCEL = "Cancel";
    public static final String CLOSE = "Close";
    protected int _result = 6;
    protected final int TTL_RATIO = 4;
    protected String _taskCn = "";
    protected String _taskType = "";
    protected String _taskDn = "";
    protected IDSModel _model;
    protected int _ttl = 4;
    protected LDAPEntry _entry;
    protected Hashtable _attributes;
    protected LDAPTaskProgressDialog _statusProgressDialog;
    protected JDialog _progressDialog;
    public static final String TASK_ROOT = "cn=tasks, cn=config";
    public static final String OBJECTCLASS = "objectclass";
    public static final String[] OBJECTCLASS_VALUE = new String[]{"top", "extensibleObject"};
    public static final String CN = "cn";
    public static final String TASK_STATUS = "nsTaskStatus";
    public static final String TASK_LOG = "nsTaskLog";
    public static final String TASK_EXIT_CODE = "nsTaskExitCode";
    public static final String TASK_CURRENT_ITEM = "nsTaskCurrentItem";
    public static final String TASK_TOTAL_ITEMS = "nsTaskTotalItems";
    public static final String TASK_CANCEL = "nsTaskCancel";
    public static final String CANCEL_VALUE = "FALSE";
    public static final String TASK_TTL = "ttl";
    protected static final String SUCCESSFUL_TASK = "0";
    protected boolean _taskCancelled = false;
    protected final String _section = "LDAPTask";
    protected String _taskSection;

    public LDAPTask(IDSModel iDSModel) {
        this._model = iDSModel;
    }

    public LDAPTask(IDSModel iDSModel, Hashtable hashtable) {
        this(iDSModel);
        this._attributes = hashtable;
    }

    protected void start() {
        try {
            this.createProgressDialog();
            if (!this.initTask()) {
                return;
            }
            Thread thread = new Thread(this);
            thread.start();
            ((GenericProgressDialog)this._progressDialog).packAndShow();
        }
        catch (Exception exception) {
            Debug.println((String)("LDAPTask.start(): " + exception));
            exception.printStackTrace();
        }
    }

    protected String getTaskCn() {
        return this._taskCn;
    }

    protected boolean initTask() {
        Object object;
        Object object2;
        this._taskCancelled = false;
        this.createTaskDn();
        LDAPAttributeSet lDAPAttributeSet = this.createTaskEntryAttributes();
        if (lDAPAttributeSet == null) {
            Debug.println((String)("LDAPTask.initTask():  Error, insufficient arguments to perform the task " + this._taskType));
            return false;
        }
        this._entry = new LDAPEntry(this._taskDn, lDAPAttributeSet);
        LDAPConnection lDAPConnection = this.getLDAPConnection();
        Debug.println((String)("DN = " + this._entry.getDN()));
        Enumeration enumeration = lDAPAttributeSet.getAttributes();
        while (enumeration.hasMoreElements()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            object2 = lDAPAttribute.getName();
            Debug.println((String)object2);
            object = lDAPAttribute.getStringValues();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
            }
        }
        try {
            Debug.println((String)("LDAPTask.initTask(): adding entry " + this._entry));
            lDAPConnection.add(this._entry);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("LDAPTask.initTask(): LDAP error code = " + lDAPException.getLDAPResultCode() + " error=" + (Object)((Object)lDAPException)));
            object2 = this._progressDialog != null ? this._progressDialog : this.getModel().getFrame();
            object = new LDAPErrorMessageDisplayer(lDAPException, lDAPConnection, this._progressDialog);
            ((LDAPErrorMessageDisplayer)object).run();
            return false;
        }
        return true;
    }

    protected void createProgressDialog() {
        String string = DSUtil._resource.getString("LDAPTask", this._taskType + "-label");
        this._progressDialog = new LDAPTaskProgressDialog(this.getModel().getFrame(), string, true, null, this);
    }

    public void run() {
        ((GenericProgressDialog)this._progressDialog).enableButtons(true);
        this.updateProgressDialog();
    }

    protected LDAPAttributeSet createTaskEntryAttributes() {
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        LDAPAttribute lDAPAttribute = new LDAPAttribute(OBJECTCLASS, OBJECTCLASS_VALUE);
        lDAPAttributeSet.add(lDAPAttribute);
        lDAPAttribute = new LDAPAttribute(CN, this.getTaskCn());
        lDAPAttributeSet.add(lDAPAttribute);
        lDAPAttribute = new LDAPAttribute(TASK_TTL, this._ttl + "");
        lDAPAttributeSet.add(lDAPAttribute);
        return lDAPAttributeSet;
    }

    public void updateProgressDialog() {
        int n;
        long l = System.currentTimeMillis();
        while ((n = this.testTaskEntry()) == 6) {
            if (this._taskCancelled) {
                return;
            }
            long l2 = System.currentTimeMillis();
            if (l2 - l > (long)(1000 * this._ttl / 4)) {
                Debug.println((String)"LDAPTask.updateProgressDialog(): ttl time is too low to ensure proper update of progress dialog");
            } else {
                try {
                    Thread.sleep(l - l2 + (long)(1000 * this._ttl / 4));
                }
                catch (Exception exception) {
                    Debug.println((String)("LDAPTask.updateProgressDialog: " + exception));
                }
            }
            l = System.currentTimeMillis();
        }
        if (!this._taskCancelled) {
            this.finalizeTask(n);
        }
    }

    protected void finalizeTask(int n) {
        Debug.println((String)"LDAPTask.finalizeTask");
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                String string = DSUtil._resource.getString("general", "LDAPTaskCompleted-unsuccessful-label");
                ((GenericProgressDialog)this._progressDialog).setTextInLabel(string);
            }
        }
        this._result = n;
        this.waitForClose();
    }

    protected void waitForClose() {
        ((GenericProgressDialog)this._progressDialog).waitForClose();
        if (this._statusProgressDialog.isVisible()) {
            this._statusProgressDialog.toFront();
        }
        if (this.getResult() != 4 && this.getResult() != 3) {
            ((GenericProgressDialog)this._progressDialog).setTextInLabel(DSUtil._resource.getString(this._taskSection, "LDAPMode-endError-title"));
        } else {
            ((GenericProgressDialog)this._progressDialog).setTextInLabel(DSUtil._resource.getString(this._taskSection, "LDAPMode-finished-title"));
        }
    }

    protected int testTaskEntry() {
        LDAPEntry lDAPEntry;
        Debug.println((String)"LDAPTask.testTaskEntry");
        LDAPConnection lDAPConnection = this.getLDAPConnection();
        try {
            lDAPEntry = lDAPConnection.read(this._taskDn);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("LDAPTask.testTaskEntry(): LDAP error code = " + lDAPException.getLDAPResultCode() + " error=" + (Object)((Object)lDAPException)));
            if (lDAPException.getLDAPResultCode() == 50) {
                ((GenericProgressDialog)this._progressDialog).setTextInLabel(DSUtil._resource.getString("authenticate", "101-msg", lDAPConnection.getAuthenticationDN()));
                return 0;
            }
            if (lDAPException.getLDAPResultCode() == 52) {
                ((GenericProgressDialog)this._progressDialog).setTextInLabel(DSUtil._resource.getString("general", "updating-server-unavailable-msg"));
                return 1;
            }
            if (lDAPException.getLDAPResultCode() == 32) {
                return 3;
            }
            String string = lDAPException.errorCodeToString();
            String string2 = lDAPException.getLDAPErrorMessage();
            if (string2 != null && string2.length() > 0) {
                string = string + ". " + string2;
            }
            String[] stringArray = new String[]{string};
            String string3 = DSUtil._resource.getString("general", "LDAPTaskError-serverReadingError-label", stringArray);
            ((GenericProgressDialog)this._progressDialog).setTextInLabel(string3);
            return 2;
        }
        if (lDAPEntry != null) {
            this._entry = lDAPEntry;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(TASK_STATUS, this.getAttrVal(TASK_STATUS));
        hashtable.put(TASK_LOG, this.getAttrVal(TASK_LOG));
        hashtable.put(TASK_CURRENT_ITEM, this.getAttrVal(TASK_CURRENT_ITEM));
        hashtable.put(TASK_TOTAL_ITEMS, this.getAttrVal(TASK_TOTAL_ITEMS));
        this.updateProgressDialog(hashtable);
        if (this.getAttrVal(TASK_CURRENT_ITEM).trim().equals(this.getAttrVal(TASK_TOTAL_ITEMS).trim()) && !this.getAttrVal(TASK_CURRENT_ITEM).equals("") || !this.getAttrVal(TASK_EXIT_CODE).trim().equals("")) {
            if (this.getAttrVal(TASK_EXIT_CODE).trim().equals(SUCCESSFUL_TASK)) {
                return 4;
            }
            return 5;
        }
        return 6;
    }

    protected void updateProgressDialog(Hashtable hashtable) {
        if (this._progressDialog instanceof LDAPTaskProgressDialog) {
            ((LDAPTaskProgressDialog)this._progressDialog).update(hashtable);
        }
    }

    public boolean cancelTask() {
        Debug.println((String)"LDAPTask.cancelTask()");
        LDAPConnection lDAPConnection = this.getLDAPConnection();
        LDAPAttribute lDAPAttribute = new LDAPAttribute(TASK_CANCEL, "TRUE");
        LDAPModification lDAPModification = new LDAPModification(2, lDAPAttribute);
        try {
            lDAPConnection.modify(this._entry.getDN(), lDAPModification);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("LDAPTask.cancelTask(): LDAP error code = " + lDAPException.getLDAPResultCode() + " error=" + (Object)((Object)lDAPException)));
            LDAPErrorMessageDisplayer lDAPErrorMessageDisplayer = new LDAPErrorMessageDisplayer(lDAPException, lDAPConnection, this._progressDialog);
            lDAPErrorMessageDisplayer.run();
            return true;
        }
        return true;
    }

    protected void createTaskDn() {
        this._taskCn = this._taskType + System.currentTimeMillis();
        this._taskDn = "cn=" + this._taskCn + ", cn=" + this._taskType + ", " + TASK_ROOT;
    }

    protected IDSModel getModel() {
        return this._model;
    }

    protected LDAPConnection getLDAPConnection() {
        return this.getModel().getServerInfo().getLDAPConnection();
    }

    private String getAttrVal(String string) {
        Enumeration enumeration;
        LDAPAttribute lDAPAttribute;
        if (this._entry != null && (lDAPAttribute = this._entry.getAttribute(string)) != null && (enumeration = lDAPAttribute.getStringValues()) != null && enumeration.hasMoreElements()) {
            return (String)enumeration.nextElement();
        }
        return "";
    }

    public int getResult() {
        return this._result;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Cancel-GenericProgressDialog")) {
            Debug.println((String)"LDAPTask.actionPerformed: CANCEL");
            ((GenericProgressDialog)this._progressDialog).disableCancelButton();
            ((GenericProgressDialog)this._progressDialog).setTextInLabel(DSUtil._resource.getString(this._taskSection, "LDAPMode-cancelled-title"));
            this._taskCancelled = true;
            this.cancelTask();
            this._statusProgressDialog.hide();
            ((GenericProgressDialog)this._progressDialog).closeCallBack();
        } else if (actionEvent.getActionCommand().equals("Close-GenericProgressDialog")) {
            Debug.println((String)"LDAPTask.actionPerformed: CLOSE");
            this._statusProgressDialog.hide();
            ((GenericProgressDialog)this._progressDialog).closeCallBack();
        } else if (actionEvent.getActionCommand().equals("Show_Logs-GenericProgressDialog")) {
            Debug.println((String)"LDAPTask.actionPerformed: SHOW_LOGS");
            this._statusProgressDialog.pack();
            this._statusProgressDialog.setLocationRelativeTo(this._progressDialog);
            ((Component)this._statusProgressDialog).setLocation(this._progressDialog.getWidth(), this._progressDialog.getHeight());
            this._statusProgressDialog.show();
        } else if (actionEvent.getActionCommand().equals(CLOSE)) {
            this._statusProgressDialog.hide();
            this._statusProgressDialog.dispose();
        }
    }
}

