/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.keycert;

import com.netscape.management.client.util.ResourceSet;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JComboBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class CipherEntry
implements ActionListener {
    private JCheckBox _cipherEnable;
    private JComboBox _tokenList;
    private JComboBox _certList;
    ResourceSet resource = new ResourceSet("com.netscape.management.client.keycert.EncryptionPaneResource");
    private Hashtable _tokenCertList;

    public CipherEntry(String cipherName, Hashtable tokenCertList) {
        this._cipherEnable = new JCheckBox(cipherName);
        Vector<Object> tokenList = new Vector<Object>();
        Enumeration tokens = tokenCertList.keys();
        while (tokens.hasMoreElements()) {
            tokenList.addElement(tokens.nextElement());
        }
        if (tokenList.size() == 0) {
            tokenList.addElement(this.resource.getString("CipherEntry", "noToken"));
        }
        this._tokenList = new JComboBox(tokenList);
        this._tokenCertList = tokenCertList;
        this._tokenList.addActionListener((ActionListener)this);
        this._certList = new JComboBox();
        try {
            this._tokenList.setSelectedIndex(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getTokenCount() {
        return this._tokenCertList.size();
    }

    public void actionPerformed(ActionEvent e) {
        this._certList.removeAllItems();
        this._certList.setEditable(false);
        if (this._tokenCertList.get(this._tokenList.getSelectedItem()) != null) {
            Vector certList = (Vector)this._tokenCertList.get(this._tokenList.getSelectedItem());
            if (certList.size() != 0) {
                if (((String)certList.elementAt(0)).toLowerCase().indexOf("unknown") != -1) {
                    this._certList.addItem((Object)this.resource.getString("CipherEntry", "enterCert"));
                    this._certList.setEditable(true);
                } else {
                    int i = 0;
                    while (i < certList.size()) {
                        this._certList.addItem(certList.elementAt(i));
                        ++i;
                    }
                }
            } else {
                this._certList.addItem((Object)this.resource.getString("CipherEntry", "noCert"));
            }
        } else {
            this._certList.addItem((Object)this.resource.getString("CipherEntry", "noCert"));
        }
        try {
            this._certList.setSelectedIndex(0);
            this._certList.validate();
            this._certList.repaint();
        }
        catch (Exception exception) {}
    }

    public JCheckBox getCipherCheckBox() {
        return this._cipherEnable;
    }

    public JComboBox getTokenComboBox() {
        return this._tokenList;
    }

    public JComboBox getCertComboBox() {
        return this._certList;
    }

    public String getCipherName() {
        return this._cipherEnable.getText();
    }

    public String getSelectedToken() {
        String selected = (String)this._tokenList.getSelectedItem();
        if (selected.equalsIgnoreCase(this.resource.getString("CipherEntry", "noToken"))) {
            selected = "";
        }
        return selected;
    }

    public String getSelectedCertName() {
        String selected = (String)this._certList.getSelectedItem();
        if (selected == null || selected.equalsIgnoreCase(this.resource.getString("CipherEntry", "noCert")) || selected.equalsIgnoreCase(this.resource.getString("CipherEntry", "enterCert"))) {
            selected = "";
        }
        return selected;
    }

    public boolean isEnabled() {
        return this._cipherEnable.isSelected();
    }

    public void setSelectedToken(String token) {
        this._tokenList.setSelectedItem((Object)token);
    }

    public void setSelectedCert(String cert) {
        this._certList.setSelectedItem((Object)cert);
    }

    public void setSelected(boolean enabled) {
        this._cipherEnable.setSelected(enabled);
    }

    public void setEnabledAll(boolean enabled) {
        this._cipherEnable.setEnabled(enabled);
        this._tokenList.setEnabled(enabled);
        this._certList.setEnabled(enabled);
    }
}

