/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs10;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.PublicKey;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.Attribute;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;

public class CertificationRequestInfo
implements ASN1Value {
    private INTEGER version = new INTEGER(0L);
    private Name subject;
    private SubjectPublicKeyInfo subjectPublicKeyInfo;
    private SET attributes;
    static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public CertificationRequestInfo(INTEGER iNTEGER, Name name, SubjectPublicKeyInfo subjectPublicKeyInfo, SET sET) {
        this.setVersion(iNTEGER);
        this.setSubject(name);
        this.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
        this.setAttributes(sET);
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(this.version);
        sEQUENCE.addElement(this.subject);
        sEQUENCE.addElement(this.subjectPublicKeyInfo);
        sEQUENCE.addElement(new Tag(0L), this.attributes);
        sEQUENCE.encode(tag, outputStream);
    }

    public SET getAttributes() {
        return this.attributes;
    }

    public Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public void print(PrintStream printStream) throws IOException, InvalidBERException {
        printStream.println("CertificationRequestInfo:");
        printStream.println("Version: " + this.version);
        printStream.println("Subject: " + this.subject.getRFC1485());
    }

    public void setAttributes(SET sET) {
        this.attributes = sET;
    }

    public void setSubject(Name name) {
        this.verifyNotNull(name);
        this.subject = name;
    }

    public void setSubjectPublicKeyInfo(PublicKey publicKey) throws InvalidBERException, IOException {
        this.verifyNotNull(publicKey);
        this.setSubjectPublicKeyInfo(new SubjectPublicKeyInfo(publicKey));
    }

    public void setSubjectPublicKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.verifyNotNull(subjectPublicKeyInfo);
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
    }

    public void setVersion(INTEGER iNTEGER) {
        this.verifyNotNull(iNTEGER);
        this.version = iNTEGER;
    }

    private void verifyNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(Name.getTemplate());
            this.seqt.addElement(SubjectPublicKeyInfo.getTemplate());
            this.seqt.addElement(Tag.get(0L), new SET.OF_Template(Attribute.getTemplate()));
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            try {
                SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
                CertificationRequestInfo certificationRequestInfo = new CertificationRequestInfo((INTEGER)sEQUENCE.elementAt(0), (Name)sEQUENCE.elementAt(1), (SubjectPublicKeyInfo)sEQUENCE.elementAt(2), (SET)sEQUENCE.elementAt(3));
                return certificationRequestInfo;
            }
            catch (Exception exception) {
                throw new InvalidBERException(exception.getMessage());
            }
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }
    }
}

