/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.security.DigestException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.JSSMessageDigest;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.PQGParamGenException;
import org.mozilla.jss.crypto.PQGParams;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.PK11Cipher;
import org.mozilla.jss.pkcs11.PK11KeyGenerator;
import org.mozilla.jss.pkcs11.PK11KeyPairGenerator;
import org.mozilla.jss.pkcs11.PK11KeyWrapper;
import org.mozilla.jss.pkcs11.PK11MessageDigest;
import org.mozilla.jss.pkcs11.PK11Signature;
import org.mozilla.jss.pkcs11.PK11Store;
import org.mozilla.jss.pkcs11.TokenCallbackInfo;
import org.mozilla.jss.pkcs11.TokenProxy;
import org.mozilla.jss.pkcs11.Tunnel;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.IncorrectPasswordException;
import org.mozilla.jss.util.NotImplementedException;
import org.mozilla.jss.util.NullPasswordCallback;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;
import org.mozilla.jss.util.PasswordCallbackInfo;

public final class PK11Token
implements CryptoToken {
    protected boolean mIsInternalCryptoToken;
    protected boolean mIsInternalKeyStorageToken;
    protected TokenProxy tokenProxy;
    protected PK11Store cryptoStore;

    protected PK11Token() {
        Assert.assert(false);
    }

    protected PK11Token(byte[] byArray, boolean bl, boolean bl2) {
        Assert.assert(byArray != null);
        this.tokenProxy = new TokenProxy(byArray);
        this.mIsInternalCryptoToken = bl;
        this.mIsInternalKeyStorageToken = bl2;
        this.cryptoStore = new PK11Store(this.tokenProxy);
    }

    protected native boolean PWInitable() throws TokenException;

    protected native boolean SSOPasswordIsCorrect(byte[] var1) throws TokenException, AlreadyInitializedException;

    public void changePassword(PasswordCallback passwordCallback, PasswordCallback passwordCallback2) throws IncorrectPasswordException, TokenException {
        Password password;
        Password password2;
        byte[] byArray;
        block15: {
            byte[] byArray2 = null;
            byArray = null;
            password2 = null;
            password = null;
            PasswordCallbackInfo passwordCallbackInfo = this.makePWCBInfo();
            if (passwordCallback == null) {
                passwordCallback = new NullPasswordCallback();
            }
            if (passwordCallback2 == null) {
                passwordCallback2 = new NullPasswordCallback();
            }
            try {
                try {
                    password2 = passwordCallback.getPasswordFirstAttempt(passwordCallbackInfo);
                    byArray2 = Tunnel.getPasswordByteCopy(password2);
                    if (!this.userPasswordIsCorrect(byArray2)) {
                        do {
                            Password.wipeBytes(byArray2);
                            password2.clear();
                        } while (!this.userPasswordIsCorrect(byArray2 = Tunnel.getPasswordByteCopy(password2 = passwordCallback.getPasswordAgain(passwordCallbackInfo))));
                    }
                    password = passwordCallback2.getPasswordFirstAttempt(passwordCallbackInfo);
                    byArray = Tunnel.getPasswordByteCopy(password);
                    this.changePassword(byArray2, byArray);
                }
                catch (PasswordCallback.GiveUpException giveUpException) {
                    throw new IncorrectPasswordException(giveUpException.toString());
                }
                Object var9_9 = null;
                if (byArray2 == null) break block15;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (byArray2 != null) {
                    Password.wipeBytes(byArray2);
                }
                if (password2 != null) {
                    password2.clear();
                }
                if (byArray != null) {
                    Password.wipeBytes(byArray);
                }
                if (password != null) {
                    password.clear();
                }
                throw throwable;
            }
            Password.wipeBytes(byArray2);
        }
        if (password2 != null) {
            password2.clear();
        }
        if (byArray != null) {
            Password.wipeBytes(byArray);
        }
        if (password != null) {
            password.clear();
        }
    }

    protected native void changePassword(byte[] var1, byte[] var2) throws IncorrectPasswordException, TokenException;

    public SymmetricKey cloneKey(SymmetricKey symmetricKey) throws SymmetricKey.NotExtractableException, InvalidKeyException, TokenException {
        return PK11KeyGenerator.clone(symmetricKey, this);
    }

    public native boolean doesAlgorithm(Algorithm var1);

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof PK11Token)) {
            return false;
        }
        return this.tokenProxy.equals(((PK11Token)object).tokenProxy);
    }

    public String generateCertRequest(String string, int n, String string2, byte[] byArray, byte[] byArray2, byte[] byArray3) throws TokenException, InvalidParameterException, PQGParamGenException {
        String string3;
        if (string2.equalsIgnoreCase("dsa")) {
            if (byArray == null && byArray2 == null && byArray3 == null) {
                String string4;
                PQGParams pQGParams;
                System.out.println("no pqg supplied, self-generating...");
                try {
                    pQGParams = PQGParams.generate(n);
                }
                catch (PQGParamGenException pQGParamGenException) {
                    System.out.println(pQGParamGenException.toString());
                    throw pQGParamGenException;
                }
                byte[] byArray4 = PQGParams.BigIntegerToUnsignedByteArray(pQGParams.getP());
                byte[] byArray5 = PQGParams.BigIntegerToUnsignedByteArray(pQGParams.getQ());
                byte[] byArray6 = PQGParams.BigIntegerToUnsignedByteArray(pQGParams.getG());
                byArray = byArray4;
                byArray2 = byArray5;
                byArray3 = byArray6;
                try {
                    string4 = this.generatePK10(string, n, string2, byArray4, byArray5, byArray6);
                }
                catch (TokenException tokenException) {
                    throw tokenException;
                }
                catch (InvalidParameterException invalidParameterException) {
                    throw invalidParameterException;
                }
                return "-----BEGIN NEW CERTIFICATE REQUEST-----\n" + string4 + "\n-----END NEW CERTIFICATE REQUEST-----";
            }
            if (byArray == null || byArray2 == null || byArray3 == null) {
                throw new InvalidParameterException("need all P, Q, and G");
            }
        }
        try {
            string3 = this.generatePK10(string, n, string2, byArray, byArray2, byArray3);
        }
        catch (TokenException tokenException) {
            throw tokenException;
        }
        catch (InvalidParameterException invalidParameterException) {
            throw invalidParameterException;
        }
        return "-----BEGIN NEW CERTIFICATE REQUEST-----\n" + string3 + "\n-----END NEW CERTIFICATE REQUEST-----";
    }

    protected native String generatePK10(String var1, int var2, String var3, byte[] var4, byte[] var5, byte[] var6) throws TokenException, InvalidParameterException;

    public Cipher getCipherContext(EncryptionAlgorithm encryptionAlgorithm) throws NoSuchAlgorithmException, TokenException {
        if (!this.doesAlgorithm(encryptionAlgorithm)) {
            throw new NoSuchAlgorithmException(String.valueOf(String.valueOf(encryptionAlgorithm)) + " is not supported by this token");
        }
        return new PK11Cipher(this, encryptionAlgorithm);
    }

    public CryptoStore getCryptoStore() {
        return this.cryptoStore;
    }

    public JSSMessageDigest getDigestContext(DigestAlgorithm digestAlgorithm) throws NoSuchAlgorithmException, DigestException {
        if (!this.doesAlgorithm(digestAlgorithm)) {
            throw new NoSuchAlgorithmException();
        }
        return new PK11MessageDigest(this, digestAlgorithm);
    }

    public KeyGenerator getKeyGenerator(KeyGenAlgorithm keyGenAlgorithm) throws NoSuchAlgorithmException, TokenException {
        if (!this.doesAlgorithm(keyGenAlgorithm)) {
            throw new NoSuchAlgorithmException(String.valueOf(String.valueOf(keyGenAlgorithm)) + " is not supported by this token");
        }
        return new PK11KeyGenerator(this, keyGenAlgorithm);
    }

    public KeyPairGenerator getKeyPairGenerator(KeyPairAlgorithm keyPairAlgorithm) throws NoSuchAlgorithmException, TokenException {
        Assert.assert(keyPairAlgorithm != null);
        return new KeyPairGenerator(keyPairAlgorithm, new PK11KeyPairGenerator(this, keyPairAlgorithm));
    }

    public KeyWrapper getKeyWrapper(KeyWrapAlgorithm keyWrapAlgorithm) throws NoSuchAlgorithmException, TokenException {
        if (!this.doesAlgorithm(keyWrapAlgorithm)) {
            throw new NoSuchAlgorithmException(String.valueOf(String.valueOf(keyWrapAlgorithm)) + " is not supported by this token");
        }
        return new PK11KeyWrapper(this, keyWrapAlgorithm);
    }

    public native int getLoginMode() throws TokenException;

    public native int getLoginTimeoutMinutes() throws TokenException;

    public native String getName();

    public Provider getProvider() {
        Assert.notYetImplemented("Providers not implemented by PK11Token yet");
        return null;
    }

    TokenProxy getProxy() {
        return this.tokenProxy;
    }

    public SecureRandom getRandomGenerator() throws NotImplementedException, TokenException {
        throw new NotImplementedException();
    }

    public Signature getSignatureContext(SignatureAlgorithm signatureAlgorithm) throws NoSuchAlgorithmException, TokenException {
        Assert.assert(signatureAlgorithm != null);
        return Tunnel.constructSignature(signatureAlgorithm, new PK11Signature(this, signatureAlgorithm));
    }

    public void initPassword(PasswordCallback passwordCallback, PasswordCallback passwordCallback2) throws IncorrectPasswordException, AlreadyInitializedException, TokenException {
        Password password;
        Password password2;
        byte[] byArray;
        block17: {
            byte[] byArray2 = null;
            byArray = null;
            password2 = null;
            password = null;
            PasswordCallbackInfo passwordCallbackInfo = this.makePWCBInfo();
            if (passwordCallback == null) {
                passwordCallback = new NullPasswordCallback();
            }
            if (passwordCallback2 == null) {
                passwordCallback2 = new NullPasswordCallback();
            }
            try {
                try {
                    if (!this.PWInitable()) {
                        throw new AlreadyInitializedException();
                    }
                    if (this.isInternalKeyStorageToken()) {
                        byArray2 = new byte[1];
                    } else {
                        password2 = passwordCallback.getPasswordFirstAttempt(passwordCallbackInfo);
                        byArray2 = Tunnel.getPasswordByteCopy(password2);
                        while (!this.SSOPasswordIsCorrect(byArray2)) {
                            Password.wipeBytes(byArray2);
                            password2.clear();
                            password2 = passwordCallback.getPasswordAgain(passwordCallbackInfo);
                            byArray2 = Tunnel.getPasswordByteCopy(password2);
                        }
                    }
                    password = passwordCallback2.getPasswordFirstAttempt(passwordCallbackInfo);
                    byArray = Tunnel.getPasswordByteCopy(password);
                    this.initPassword(byArray2, byArray);
                }
                catch (PasswordCallback.GiveUpException giveUpException) {
                    throw new IncorrectPasswordException(giveUpException.toString());
                }
                Object var9_9 = null;
                if (byArray2 == null) break block17;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (byArray2 != null) {
                    Password.wipeBytes(byArray2);
                }
                if (password2 != null) {
                    password2.clear();
                }
                if (byArray != null) {
                    Password.wipeBytes(byArray);
                }
                if (password != null) {
                    password.clear();
                }
                throw throwable;
            }
            Password.wipeBytes(byArray2);
        }
        if (password2 != null) {
            password2.clear();
        }
        if (byArray != null) {
            Password.wipeBytes(byArray);
        }
        if (password != null) {
            password.clear();
        }
    }

    protected native void initPassword(byte[] var1, byte[] var2) throws IncorrectPasswordException, AlreadyInitializedException, TokenException;

    public boolean isInternalCryptoToken() {
        return this.mIsInternalCryptoToken;
    }

    public boolean isInternalKeyStorageToken() {
        return this.mIsInternalKeyStorageToken;
    }

    public native boolean isLoggedIn() throws TokenException;

    public native boolean isPresent();

    public native boolean isWritable();

    public void login(PasswordCallback passwordCallback) throws NotInitializedException, IncorrectPasswordException, TokenException {
        if (passwordCallback == null) {
            passwordCallback = new NullPasswordCallback();
        }
        this.nativeLogin(passwordCallback);
    }

    public native void logout() throws TokenException;

    protected PasswordCallbackInfo makePWCBInfo() {
        return new TokenCallbackInfo(this.getName());
    }

    protected native void nativeLogin(PasswordCallback var1) throws NotInitializedException, IncorrectPasswordException, TokenException;

    public native boolean passwordIsInitialized() throws TokenException;

    public native void setLoginMode(int var1) throws TokenException;

    public native void setLoginTimeoutMinutes(int var1) throws TokenException;

    protected native boolean userPasswordIsCorrect(byte[] var1) throws TokenException;

    public static class NotInitializedException
    extends IncorrectPasswordException {
        public NotInitializedException() {
        }

        public NotInitializedException(String string) {
            super(string);
        }
    }
}

