/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider;

import java.security.DigestException;
import java.security.NoSuchAlgorithmException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.JSSMessageDigest;
import org.mozilla.jss.crypto.TokenSupplierManager;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.Debug;

abstract class MessageDigest
extends java.security.MessageDigest {
    private JSSMessageDigest md;

    protected MessageDigest(String string) {
        super(string);
        try {
            Debug.trace(10, "In JSS JCA message digest constructor");
            CryptoToken cryptoToken = TokenSupplierManager.getTokenSupplier().getInternalCryptoToken();
            this.md = cryptoToken.getDigestContext(this.getAlg());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Debug.trace(1, "Unknown message digesting algorithm: " + string);
            Assert.notReached("Unknown message digesting algorithm");
        }
        catch (DigestException digestException) {
            Debug.trace(1, "Digest Exception while creating " + string + " digest");
            Assert.notReached("Digest exception creating message digest");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected byte[] engineDigest() {
        try {
            Debug.trace(10, "In JSS JCA message digest engineDigest");
            return this.md.digest();
        }
        catch (DigestException digestException) {
            Debug.trace(1, "Digest Exception while finalizing digest");
            Assert.notReached("Digest exception while finalizing digest");
            return null;
        }
    }

    protected void engineReset() {
        try {
            Debug.trace(10, "In JSS JCA message digest engineReset");
            this.md.reset();
        }
        catch (DigestException digestException) {
            Debug.trace(1, "Digest Exception while resetting digest");
            Assert.notReached("Digest exception while resetting digest");
        }
    }

    protected void engineUpdate(byte by) {
        try {
            Debug.trace(10, "In JSS JCA message digest engineUpdate");
            this.md.update(by);
        }
        catch (DigestException digestException) {
            Debug.trace(1, "Digest Exception while updating digest");
            Assert.notReached("Digest exception while updating digest");
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        try {
            Debug.trace(10, "In JSS JCA message digest engineUpdate");
            this.md.update(byArray, n, n2);
        }
        catch (DigestException digestException) {
            Debug.trace(1, "Digest Exception while updating digest");
            Assert.notReached("Digest exception while updating digest");
        }
    }

    protected abstract DigestAlgorithm getAlg();
}

