/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLClientCertificateSelectionCallback;
import org.mozilla.jss.ssl.SocketProxy;

class SocketBase {
    private SocketProxy sockProxy;
    private int timeout;
    static final int SSL_ENABLE_SSL2 = 0;
    static final int SSL_ENABLE_SSL3 = 1;
    static final int TCP_NODELAY = 2;
    static final int SO_KEEPALIVE = 3;
    static final int PR_SHUTDOWN_RCV = 4;
    static final int PR_SHUTDOWN_SEND = 5;
    static final int SSL_REQUIRE_CERTIFICATE = 6;
    static final int SSL_REQUEST_CERTIFICATE = 7;
    static final int SSL_NO_CACHE = 8;
    static final int SSL_POLICY_DOMESTIC = 9;
    static final int SSL_POLICY_EXPORT = 10;
    static final int SSL_POLICY_FRANCE = 11;
    private boolean requestingClientAuth = false;

    SocketBase() {
    }

    void close() throws IOException {
        this.socketClose();
        this.sockProxy = null;
    }

    void enableSSL2(boolean bl) throws SocketException {
        this.setSSLOption(0, bl);
    }

    void enableSSL3(boolean bl) throws SocketException {
        this.setSSLOption(1, bl);
    }

    InetAddress getInetAddress() {
        try {
            InetAddress inetAddress;
            int n = this.getPeerAddressNative();
            byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
            try {
                inetAddress = InetAddress.getByName(String.valueOf(byArray[0]) + "." + byArray[1] + "." + byArray[2] + "." + byArray[3]);
            }
            catch (UnknownHostException unknownHostException) {
                inetAddress = null;
            }
            return inetAddress;
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
            return null;
        }
    }

    public int getLocalPort() {
        try {
            return this.getLocalPortNative();
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
            return 0;
        }
    }

    private native int getLocalPortNative() throws SocketException;

    private native int getPeerAddressNative() throws SocketException;

    int getTimeout() {
        return this.timeout;
    }

    void requestClientAuth(boolean bl) throws SocketException {
        this.requestingClientAuth = bl;
        this.setSSLOption(7, bl);
    }

    public void requestClientAuthNoExpiryCheck(boolean bl) throws SocketException {
        this.requestingClientAuth = bl;
        this.requestClientAuthNoExpiryCheckNative(bl);
    }

    private native void requestClientAuthNoExpiryCheckNative(boolean var1) throws SocketException;

    void requireClientAuth(boolean bl, boolean bl2) throws SocketException {
        if (bl && !this.requestingClientAuth) {
            this.requestClientAuth(true);
        }
        this.setSSLOption(6, bl ? (bl2 ? 1 : 2) : 0);
    }

    void setClientCertNickname(String string) throws SocketException {
        if (string != null && string.length() > 0) {
            this.setClientCertNicknameNative(string);
        }
    }

    private native void setClientCertNicknameNative(String var1) throws SocketException;

    void setProxy(SocketProxy socketProxy) {
        this.sockProxy = socketProxy;
    }

    native void setSSLOption(int var1, int var2) throws SocketException;

    void setSSLOption(int n, boolean bl) throws SocketException {
        this.setSSLOption(n, bl ? 1 : 0);
    }

    void setTimeout(int n) {
        this.timeout = n;
    }

    native void socketBind(byte[] var1, int var2) throws SocketException;

    native void socketClose() throws IOException;

    native byte[] socketCreate(Object var1, SSLCertificateApprovalCallback var2, SSLClientCertificateSelectionCallback var3) throws SocketException;

    void useCache(boolean bl) throws SocketException {
        this.setSSLOption(8, bl ^ true);
    }
}

