/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import org.mozilla.jss.util.Assert;

public abstract class NativeProxy {
    private byte[] mPointer;
    private long registryIndex;
    static Hashtable registry = new Hashtable();
    static Random indexGenerator = new Random();

    private NativeProxy() {
        Assert.assert(false);
    }

    public NativeProxy(byte[] byArray) {
        Assert.assert(byArray != null);
        this.mPointer = byArray;
    }

    public static synchronized void assertRegistryEmpty() {
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof NativeProxy)) {
            return false;
        }
        if (((NativeProxy)object).mPointer.length != this.mPointer.length) {
            return false;
        }
        int n = 0;
        while (n < this.mPointer.length) {
            if (this.mPointer[n] != ((NativeProxy)object).mPointer[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        this.releaseNativeResources();
    }

    public long getRegistryIndex() {
        return this.registryIndex;
    }

    public static synchronized Enumeration getRegistryIndices() {
        return registry.keys();
    }

    private static synchronized long register() {
        Long l;
        while (registry.containsKey(l = new Long(indexGenerator.nextLong()))) {
        }
        registry.put(l, l);
        return l;
    }

    protected abstract void releaseNativeResources();

    private static synchronized void unregister(long l) {
        Long l2 = new Long(l);
        Long l3 = (Long)registry.remove(l2);
        Assert.assert(l3 != null);
    }
}

