/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import org.apache.jasper.compiler.Mangler;

public class JspMangler
implements Mangler {
    String pkgName;
    String className;
    String javaFileName;
    String classFileName;
    String prefix;
    File jsp;
    String outputDir;

    public JspMangler(String string, String string2) {
        this.jsp = new File(string);
        this.outputDir = string2;
    }

    public final String getClassFileName() {
        if (this.classFileName != null) {
            return this.classFileName;
        }
        String string = this.getPrefix(this.jsp.getPath());
        this.classFileName = String.valueOf(string) + File.separatorChar + this.getClassName() + ".class";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.classFileName = String.valueOf(this.outputDir) + File.separatorChar + this.classFileName;
        }
        return this.classFileName;
    }

    public final String getClassName() {
        if (this.className != null) {
            return this.className;
        }
        this.className = this.jsp.getName().endsWith(".jsp") ? this.jsp.getName().substring(0, this.jsp.getName().length() - 4) : this.jsp.getName();
        StringBuffer stringBuffer = new StringBuffer();
        this.className = "_" + this.mangleString(this.className, this.className.length() - 1, stringBuffer) + "_jsp";
        return this.className;
    }

    public final String getJavaFileName() {
        if (this.javaFileName != null) {
            return this.javaFileName;
        }
        String string = this.getPrefix(this.jsp.getPath());
        this.javaFileName = String.valueOf(string) + File.separatorChar + this.getClassName() + ".java";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.javaFileName = String.valueOf(this.outputDir) + File.separatorChar + this.javaFileName;
        }
        return this.javaFileName;
    }

    public final String getPackageName() {
        if (this.pkgName != null) {
            return this.pkgName;
        }
        String string = this.jsp.getPath();
        String string2 = this.getPrefix(string);
        string2 = string2.replace(File.separatorChar, '.');
        return string2;
    }

    private final String getPrefix(String string) {
        if (this.prefix != null) {
            return this.prefix;
        }
        if (string == null) {
            return "_jsps";
        }
        int n = string.lastIndexOf(File.separatorChar);
        if (n == -1 || n == 0) {
            return "_jsps";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("_jsps");
        return this.mangleString(string, n - 1, stringBuffer);
    }

    private static final String mangleChar(char c) {
        if (c == File.separatorChar) {
            c = (char)47;
        }
        String string = Integer.toHexString(c);
        int n = 5 - string.length();
        char[] cArray = new char[6];
        cArray[0] = 95;
        int n2 = 1;
        while (n2 <= n) {
            cArray[n2] = 48;
            ++n2;
        }
        int n3 = n + 1;
        int n4 = 0;
        while (n3 < 6) {
            cArray[n3] = string.charAt(n4);
            ++n3;
            ++n4;
        }
        return new String(cArray);
    }

    private final String mangleString(String string, int n, StringBuffer stringBuffer) {
        int n2 = 0;
        while (n2 <= n) {
            if (Character.isLetterOrDigit(string.charAt(n2)) || string.charAt(n2) == '_') {
                stringBuffer.append(string.substring(n2, n2 + 1));
            } else if (string.charAt(n2) == File.separatorChar) {
                stringBuffer.append(File.separatorChar);
                if (n2 != n) {
                    stringBuffer.append("_");
                }
            } else if (string.charAt(n2) == '-' || string.charAt(n2) == '.') {
                stringBuffer.append("_");
            } else {
                stringBuffer.append(JspMangler.mangleChar(string.charAt(n2)));
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public final void setPrefix(String string) {
        if (string != null) {
            this.prefix = string;
        }
    }
}

