/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.certsrv.connection;

import com.netscape.admin.certsrv.connection.IConnection;
import com.netscape.admin.certsrv.misc.HttpInputStream;
import com.netscape.admin.certsrv.misc.HttpOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import netscape.ldap.factory.JSSSocketFactory;

public class SSLavaConnection
implements IConnection {
    private HttpInputStream httpIn;
    private HttpOutputStream httpOut;
    private byte[] body;
    private int bodyLen;
    private String header;
    private int available;
    private int totalRead;
    private boolean endOfHeader = false;
    private static int HTTP_OK_RESPONSE = 200;
    protected Socket s;

    public SSLavaConnection(String host, int port) throws IOException, UnknownHostException {
        try {
            this.s = new JSSSocketFactory().makeSocket(host, port);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
        this.httpIn = new HttpInputStream(8192);
        this.httpOut = new HttpOutputStream();
        this.httpIn.init(this.s.getInputStream());
        this.httpOut.init(this.s.getOutputStream());
    }

    public int sendRequest(String req) throws IOException {
        int stat = 1;
        if (req == null) {
            return 0;
        }
        this.endOfHeader = false;
        this.httpOut.next();
        PrintStream ps = new PrintStream((OutputStream)this.httpOut);
        ps.println(req);
        ps.println();
        ps.flush();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {}
        this.totalRead = 0;
        this.header = null;
        this.httpIn.next();
        this.initReadResponse();
        return stat;
    }

    public InputStream getInputStream() throws IOException {
        return this.s.getInputStream();
    }

    public int read(byte[] buf) throws IOException {
        return this.httpIn.read(buf, 0, buf.length);
    }

    public String getHeader() {
        if (this.header == null) {
            return "No Header Read";
        }
        return this.header;
    }

    public byte[] getResponse() {
        if (this.totalRead == 0) {
            return null;
        }
        byte[] buf = new byte[this.bodyLen];
        System.arraycopy(this.body, 0, buf, 0, this.bodyLen);
        return buf;
    }

    public int available() throws IOException {
        return this.httpIn.available();
    }

    public void disconnect() {
        try {
            this.s.close();
        }
        catch (Exception exception) {}
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.s.setSoTimeout(timeout);
    }

    private void initReadResponse() throws IOException {
        this.readHeader();
        this.readBody();
    }

    private void readHeader() throws IOException {
        byte[] headerLine = new byte[1096];
        int nRead = this.httpIn.readLine(headerLine, 0, 1096);
        if (this.requestFailed(new String(headerLine))) {
            throw new IOException(this.getReasonPhrase(new String(headerLine)));
        }
        do {
            nRead = this.httpIn.readLine(headerLine, 0, 1096);
            int available = this.httpIn.available();
            if (nRead == -1) {
                System.out.println("Unexpected end of stream");
                break;
            }
            this.processHeader(headerLine, nRead);
        } while (!this.endOfHeader);
    }

    private boolean endOfHeader(byte[] hdr, int available) {
        if (available == 2) {
            byte c1 = hdr[0];
            byte c2 = hdr[1];
            return true;
        }
        return false;
    }

    private void readBody() throws IOException {
        this.body = new byte[this.bodyLen];
        this.totalRead = 0;
        while (this.totalRead < this.bodyLen) {
            int nRead = this.httpIn.read(this.body, this.totalRead, this.bodyLen - this.totalRead);
            this.totalRead += nRead;
        }
    }

    private void processHeader(byte[] buf, int nRead) {
        if (this.endOfHeader(buf, nRead)) {
            this.endOfHeader = true;
            return;
        }
        String hdr = new String(buf, 0, nRead);
        boolean index = false;
        if (hdr.startsWith("Content-Length: ")) {
            try {
                String length = hdr.substring(hdr.indexOf(": ") + 1);
                this.bodyLen = Integer.parseInt(length.trim());
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean requestFailed(String header) {
        return header.indexOf(Integer.toString(HTTP_OK_RESPONSE)) <= 0;
    }

    private String getReasonPhrase(String header) {
        String str1 = header.substring(header.indexOf(32) + 1);
        return str1.substring(str1.indexOf(32) + 1);
    }
}

