/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.certsrv.ug;

import com.netscape.admin.certsrv.CMSAdminUtil;
import com.netscape.admin.certsrv.EAdminException;
import com.netscape.admin.certsrv.connection.AdminConnection;
import com.netscape.admin.certsrv.connection.BasicAuthenticator;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.management.client.util.Debug;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.DefaultListModel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JList;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JPasswordField;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.event.DocumentEvent;
import com.sun.java.swing.event.DocumentListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class UserEditor
extends JDialog
implements ActionListener,
MouseListener,
DocumentListener {
    private String PREFIX = "USEREDITOR";
    private JFrame mParentFrame;
    private AdminConnection mConnection;
    private String mUserName;
    private boolean mIsNewUser = false;
    private boolean mIsAdmin;
    private ResourceBundle mResource;
    private Color mActiveColor;
    protected DefaultListModel mDataModel;
    protected JScrollPane mScrollPane;
    protected JList mList;
    private JButton mOK;
    private JButton mCancel;
    private JButton mHelp;
    private JLabel mPasswordLbl;
    private JLabel mPasswordConfirmLbl;
    private JTextField mUserNameField;
    private JTextField mFullNameField;
    private JTextField mEMailField;
    private JTextField mPhoneField;
    private JPasswordField mPasswordField;
    private JPasswordField mPasswordConfirm;
    private JLabel mUserLabel;
    private JLabel mMembership;
    private JLabel mGroupLbl;
    private JLabel dummy1;
    private JComboBox mGroupBox;
    private static final String ADDHELPINDEX = "usersgroups-certsrv-add-user-dbox-help";
    private static final String EDITHELPINDEX = "usersgroups-certsrv-edit-user-dbox-help";
    static /* synthetic */ Class class$com$netscape$admin$certsrv$CMSAdminResources;

    public UserEditor(JFrame parent, AdminConnection conn, boolean isNew, boolean isAdmin) {
        super((Frame)parent, true);
        this.mParentFrame = parent;
        this.mConnection = conn;
        this.mDataModel = new DefaultListModel();
        this.mResource = ResourceBundle.getBundle((class$com$netscape$admin$certsrv$CMSAdminResources != null ? class$com$netscape$admin$certsrv$CMSAdminResources : (class$com$netscape$admin$certsrv$CMSAdminResources = UserEditor.class$("com.netscape.admin.certsrv.CMSAdminResources"))).getName());
        ((Dialog)((Object)this)).setTitle(this.mResource.getString(String.valueOf(this.PREFIX) + "_TITLE"));
        this.mIsNewUser = isNew;
        this.mIsAdmin = isAdmin;
        if (!this.mIsNewUser) {
            ((Component)((Object)this)).setSize(360, 370);
        } else {
            ((Component)((Object)this)).setSize(360, 350);
        }
        this.setLocationRelativeTo((Component)parent);
        this.getRootPane().setDoubleBuffered(true);
        this.setDisplay();
        if (!this.mIsNewUser) {
            this.mUserNameField.setVisible(false);
            this.mUserLabel.setVisible(true);
            this.mMembership.setVisible(true);
            this.mScrollPane.setVisible(true);
            this.mGroupLbl.setVisible(false);
            this.mGroupBox.setVisible(false);
            this.dummy1.setVisible(false);
        } else {
            this.mUserNameField.setVisible(true);
            this.mUserNameField.setText("");
            this.mUserLabel.setVisible(false);
            this.mUserLabel.setText("");
            this.mMembership.setVisible(false);
            this.mScrollPane.setVisible(false);
            this.mGroupLbl.setVisible(true);
            this.mGroupBox.setVisible(true);
            this.dummy1.setVisible(true);
        }
    }

    public void showDialog(String user) {
        this.mUserName = user;
        this.mFullNameField.setText("");
        this.mEMailField.setText("");
        this.mPhoneField.setText("");
        this.mPasswordField.setText("");
        this.mPasswordConfirm.setText("");
        if (this.mIsAdmin) {
            this.enablePasswordFields(true, this.mActiveColor);
        } else {
            this.enablePasswordFields(false, ((Component)((Object)this)).getBackground());
        }
        this.mDataModel.clear();
        if (!this.mIsNewUser) {
            this.mUserLabel.setText(user);
        } else {
            this.mUserNameField.setText("");
            this.mUserLabel.setText("");
        }
        try {
            if (!this.mIsNewUser) {
                this.refresh();
            } else {
                this.addGroup();
            }
        }
        catch (EAdminException ex) {
            CMSAdminUtil.showErrorDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)ex.toString(), (int)0);
            return;
        }
        this.updateView();
        ((Dialog)((Object)this)).show();
    }

    private void enablePasswordFields(boolean enable, Color color) {
        this.mPasswordField.setVisible(enable);
        this.mPasswordLbl.setVisible(enable);
        this.mPasswordConfirm.setVisible(enable);
        this.mPasswordConfirmLbl.setVisible(enable);
        CMSAdminUtil.repaintComp((JComponent)this.mPasswordField);
        CMSAdminUtil.repaintComp((JComponent)this.mPasswordConfirm);
        CMSAdminUtil.repaintComp((JComponent)this.mPasswordLbl);
        CMSAdminUtil.repaintComp((JComponent)this.mPasswordConfirmLbl);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(this.mOK)) {
            String pwd = this.mPasswordField.getText().trim();
            if (!pwd.equals("") && !this.mPasswordConfirm.getText().trim().equals(pwd)) {
                CMSAdminUtil.showMessageDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)this.PREFIX, (String)"PWDNOTMATCH", (int)0);
                return;
            }
            if (this.mIsNewUser) {
                if (this.mUserNameField.getText().trim().equals("")) {
                    CMSAdminUtil.showMessageDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)this.PREFIX, (String)"NOUSERNAME", (int)0);
                    return;
                }
                try {
                    this.addUser();
                }
                catch (EAdminException e) {
                    Debug.println((String)e.toString());
                    CMSAdminUtil.showErrorDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)e.toString(), (int)0);
                    return;
                }
            }
            try {
                this.modifyUser();
            }
            catch (EAdminException e) {
                Debug.println((String)e.toString());
                CMSAdminUtil.showErrorDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)e.toString(), (int)0);
                return;
            }
            ((Component)((Object)this)).hide();
        }
        if (evt.getSource().equals(this.mCancel)) {
            Debug.println((String)"Cancel Pressed");
            ((Component)((Object)this)).hide();
        }
        if (evt.getSource().equals(this.mHelp)) {
            if (this.mIsNewUser) {
                CMSAdminUtil.help((String)ADDHELPINDEX);
            } else {
                CMSAdminUtil.help((String)EDITHELPINDEX);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.updateView();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.updateView();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateView();
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateView();
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateView();
    }

    private void updateView() {
        if (this.mIsNewUser && this.mUserNameField.getText().trim().equals("")) {
            this.mOK.setEnabled(false);
            return;
        }
        if (this.mFullNameField.getText().trim().equals("")) {
            this.mOK.setEnabled(false);
            return;
        }
        this.mOK.setEnabled(true);
    }

    private void setDisplay() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel center = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        center.setLayout(gb);
        JPanel content = this.makeContentPane();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gb.setConstraints((Component)content, gbc);
        center.add((Component)content);
        JPanel action = this.makeActionPane();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gb.setConstraints((Component)action, gbc);
        center.add((Component)action);
        this.getContentPane().add("Center", (Component)center);
    }

    private JPanel makeActionPane() {
        this.mOK = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"OK", null, (ActionListener)this);
        this.mCancel = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"CANCEL", null, (ActionListener)this);
        this.mHelp = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"HELP", null, (ActionListener)this);
        JButton[] buttons = new JButton[]{this.mOK, this.mCancel, this.mHelp};
        return CMSAdminUtil.makeJButtonPanel((JButton[])buttons, (boolean)true);
    }

    private JPanel makeContentPane() {
        Insets insets = new Insets(6, 0, 6, 0);
        JPanel top = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        top.setLayout(gb);
        JLabel label1 = CMSAdminUtil.makeJLabel((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"USERNAME", null);
        this.mUserNameField = new JTextField();
        this.mUserNameField.addMouseListener(this);
        this.mUserNameField.getDocument().addDocumentListener((DocumentListener)this);
        this.mUserLabel = new JLabel();
        this.mUserLabel.setVisible(false);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 13;
        gbc.insets = new Insets(6, 6, 0, 0);
        top.add((Component)label1, gbc);
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(6, 6, 0, 6);
        top.add((Component)this.mUserLabel, gbc);
        top.add((Component)this.mUserNameField, gbc);
        JLabel dummy = new JLabel();
        dummy.setVisible(false);
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        top.add((Component)dummy, gbc);
        JLabel label2 = CMSAdminUtil.makeJLabel((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"FULLNAME", null);
        this.mFullNameField = new JTextField();
        this.mFullNameField.addMouseListener(this);
        this.mFullNameField.getDocument().addDocumentListener((DocumentListener)this);
        CMSAdminUtil.addEntryField((JPanel)top, (JComponent)label2, (JComponent)this.mFullNameField, (GridBagConstraints)gbc);
        this.mPasswordLbl = CMSAdminUtil.makeJLabel((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"PASSWORD", null);
        this.mPasswordField = new JPasswordField();
        this.mPasswordField.addMouseListener(this);
        this.mPasswordField.getDocument().addDocumentListener((DocumentListener)this);
        this.mActiveColor = this.mPasswordField.getBackground();
        CMSAdminUtil.addEntryField((JPanel)top, (JComponent)this.mPasswordLbl, (JComponent)this.mPasswordField, (GridBagConstraints)gbc);
        this.mPasswordConfirmLbl = CMSAdminUtil.makeJLabel((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"PASSWORDCONFIRM", null);
        this.mPasswordConfirm = new JPasswordField();
        this.mPasswordConfirm.addMouseListener(this);
        this.mPasswordConfirm.getDocument().addDocumentListener((DocumentListener)this);
        CMSAdminUtil.addEntryField((JPanel)top, (JComponent)this.mPasswordConfirmLbl, (JComponent)this.mPasswordConfirm, (GridBagConstraints)gbc);
        JLabel label4 = CMSAdminUtil.makeJLabel((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"EMAIL", null);
        this.mEMailField = new JTextField();
        CMSAdminUtil.addEntryField((JPanel)top, (JComponent)label4, (JComponent)this.mEMailField, (GridBagConstraints)gbc);
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        JLabel label5 = CMSAdminUtil.makeJLabel((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"PHONE", null);
        this.mPhoneField = new JTextField();
        CMSAdminUtil.addEntryField((JPanel)top, (JComponent)label5, (JComponent)this.mPhoneField, (GridBagConstraints)gbc);
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        this.mGroupLbl = CMSAdminUtil.makeJLabel((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"GROUP", null);
        this.mGroupBox = new JComboBox();
        this.dummy1 = new JLabel(" ");
        CMSAdminUtil.addEntryField((JPanel)top, (JComponent)this.mGroupLbl, (JComponent)this.mGroupBox, (JComponent)this.dummy1, (GridBagConstraints)gbc);
        this.mMembership = CMSAdminUtil.makeJLabel((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"MEMBER", null);
        this.mList = CMSAdminUtil.makeJList((DefaultListModel)this.mDataModel, (int)6);
        this.mScrollPane = new JScrollPane((Component)this.mList, 22, 31);
        this.mList.setSelectionMode(0);
        this.mList.addMouseListener(this);
        this.mScrollPane.setBackground(Color.white);
        this.mScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.anchor = 12;
        gbc.gridheight = 0;
        gbc.insets = new Insets(6, 6, 0, 0);
        top.add((Component)this.mMembership, gbc);
        ++gbc.gridx;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 0.5;
        gbc.weighty = 1.0;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.insets = new Insets(6, 6, 0, 6);
        top.add((Component)this.mScrollPane, gbc);
        return top;
    }

    private void refresh() throws EAdminException {
        NameValuePairs config = new NameValuePairs();
        config.add("fullname", "");
        config.add("email", "");
        config.add("phone", "");
        config.add("groups", "");
        NameValuePairs response = this.mConnection.read("ug", "users", this.mUserName, config);
        this.mUserNameField.setText(this.mUserName);
        this.mFullNameField.setText(response.getValue("fullname"));
        this.mEMailField.setText(response.getValue("email"));
        this.mPhoneField.setText(response.getValue("phone"));
        String userStr = response.getValue("groups");
        if (userStr != null && !userStr.trim().equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(userStr, ",");
            while (tokenizer.hasMoreTokens()) {
                String groupstr = tokenizer.nextToken().trim();
                this.mDataModel.addElement((Object)groupstr);
            }
        }
    }

    private void addGroup() throws EAdminException {
        NameValuePairs response = this.mConnection.search("ug", "groups", new NameValuePairs());
        if (this.mGroupBox.getItemCount() > 0) {
            this.mGroupBox.removeAllItems();
        }
        Enumeration e = response.getNames();
        while (e.hasMoreElements()) {
            String groupname = (String)e.nextElement();
            if (this.mIsAdmin) {
                if (groupname.equals("Certificate Manager Agents") || groupname.equals("Registration Manager Agents") || groupname.equals("Data Recovery Manager Agents") || groupname.equals("Trusted Managers")) continue;
                this.mGroupBox.addItem((Object)groupname.trim());
                continue;
            }
            if (groupname.equals("Trusted Managers") || groupname.equals("Administrators")) continue;
            this.mGroupBox.addItem((Object)groupname.trim());
        }
    }

    private void addUser() throws EAdminException {
        NameValuePairs config = new NameValuePairs();
        config.add("fullname", this.mFullNameField.getText().trim());
        config.add("password", this.mPasswordField.getText().trim());
        config.add("email", this.mEMailField.getText().trim());
        config.add("phone", this.mPhoneField.getText().trim());
        config.add("groups", (String)this.mGroupBox.getSelectedItem());
        if (this.mIsAdmin) {
            config.add("userType", "adminType");
        } else {
            config.add("userType", "agentType");
        }
        this.mConnection.add("ug", "users", this.mUserNameField.getText().trim(), config);
    }

    private void modifyUser() throws EAdminException {
        BasicAuthenticator auth;
        NameValuePairs config = new NameValuePairs();
        config.add("fullname", this.mFullNameField.getText().trim());
        config.add("password", this.mPasswordField.getText().trim());
        config.add("email", this.mEMailField.getText().trim());
        config.add("phone", this.mPhoneField.getText().trim());
        if (this.mIsAdmin) {
            config.add("userType", "adminType");
        } else {
            config.add("userType", "agentType");
        }
        this.mConnection.modify("ug", "users", this.mUserName, config);
        String pwd = this.mPasswordField.getText().trim();
        if (!pwd.equals("") && this.mUserName.equals((auth = (BasicAuthenticator)this.mConnection.getAuthenticator()).getUserid()) && !pwd.equals(auth.getPassword())) {
            auth.setPassword(pwd);
        }
    }

    private void refreshTable() {
        this.mScrollPane.repaint(1L);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

