/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.acleditor;

import com.netscape.management.client.acleditor.CallbackAction;
import com.netscape.management.client.acleditor.CustomJTable;
import com.netscape.management.client.acleditor.DataModelAdapter;
import com.netscape.management.client.acleditor.SelectionListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class Table
extends JScrollPane
implements MouseListener,
MouseMotionListener {
    protected DataModelAdapter data = null;
    protected JTable table = null;
    protected Vector selectionListeners = new Vector();
    protected boolean mouseOverFocusEnabled = false;
    protected int selection = -1;
    protected int focusRow = -1;
    protected int focusCol = -1;

    public Table(DataModelAdapter dataModelAdapter) {
        this.data = dataModelAdapter;
        this.table = new CustomJTable(this.data);
        if (this.data instanceof SelectionListener) {
            this.addSelectionListener((SelectionListener)((Object)this.data));
        }
        this.table.setColumnSelectionAllowed(false);
        this.table.addMouseListener(this);
        this.table.addMouseMotionListener(this);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.setVerticalScrollBarPolicy(22);
        this.setViewport(this.createViewport());
        this.setViewportView(this.table);
        if (this.data.getHeaderVisible()) {
            this.setColumnHeaderView(this.table.getTableHeader());
        }
    }

    protected DataModelAdapter getDataModelAdapter() {
        return this.data;
    }

    protected JTable getJTable() {
        return this.table;
    }

    protected int getRowCount() {
        return this.data.getRowCount();
    }

    protected void setMouseOverFocusEnabled() {
        this.mouseOverFocusEnabled = true;
    }

    protected void resizeAndRepaint() {
        ((CustomJTable)this.table).doResize();
    }

    protected void addRow() {
        this.data.addRow(this.table.getSelectedRow());
        this.resizeAndRepaint();
    }

    protected void deleteRow() {
        int n = this.table.getSelectedRow();
        this.table.clearSelection();
        this.data.deleteRow(n);
        this.selectionNotifyAll(-1, -1, 0, new CallbackAction(){

            public void callback(Object object) {
                Table.this.resizeAndRepaint();
            }
        });
    }

    protected void moveRow(boolean bl) {
        this.data.moveRow(this.table.getSelectedRow(), bl);
        this.resizeAndRepaint();
    }

    protected void addSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.addElement(selectionListener);
    }

    protected void removeSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.removeElement(selectionListener);
    }

    protected void selectionNotifyAll(int n, int n2, int n3, CallbackAction callbackAction) {
        int n4 = 0;
        while (n4 < this.selectionListeners.size()) {
            ((SelectionListener)this.selectionListeners.elementAt(n4)).selectionNotify(n, n2, n3, callbackAction);
            ++n4;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.table.columnAtPoint(mouseEvent.getPoint());
        if (n == -1 || n2 == -1) {
            this.selection = -1;
            this.table.clearSelection();
        } else {
            this.selection = n;
        }
        this.selectionNotifyAll(this.selection, n2, mouseEvent.getClickCount(), new CallbackAction(){

            public void callback(Object object) {
                Table.this.resizeAndRepaint();
            }
        });
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.mouseOverFocusEnabled || !this.data.isFocusEnabled()) {
            return;
        }
        if (this.focusRow == -1 || this.focusCol == -1) {
            return;
        }
        this.drawCellFocus(this.focusRow, this.focusCol, false);
        this.focusCol = -1;
        this.focusRow = -1;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.mouseOverFocusEnabled || !this.data.isFocusEnabled()) {
            return;
        }
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.table.columnAtPoint(mouseEvent.getPoint());
        if (n == -1 || n2 == -1) {
            this.drawCellFocus(this.focusRow, this.focusCol, false);
            this.focusCol = -1;
            this.focusRow = -1;
            return;
        }
        if (this.focusRow != n || this.focusCol != n2) {
            this.drawCellFocus(this.focusRow, this.focusCol, false);
        }
        this.focusRow = n;
        this.focusCol = n2;
        this.drawCellFocus(this.focusRow, this.focusCol, true);
    }

    protected void drawCellFocus(int n, int n2, boolean bl) {
        if (n == -1 || n2 == -1) {
            return;
        }
        Rectangle rectangle = this.table.getCellRect(n, n2, false);
        Graphics graphics = this.table.getGraphics();
        if (bl) {
            graphics.setColor(Color.blue);
            graphics.draw3DRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, false);
        } else {
            if (this.table.isCellSelected(n, n2)) {
                graphics.setColor(this.table.getSelectionBackground());
            } else {
                graphics.setColor(this.table.getBackground());
            }
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
    }

    protected void setRealSize(Dimension dimension) {
        this.table.setPreferredSize(dimension);
        this.table.setMinimumSize(dimension);
        this.table.setMaximumSize(dimension);
    }
}

