/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.components;

import com.netscape.management.client.components.IDirNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class TreePanelCellRenderer
extends JLabel
implements TreeCellRenderer {
    private boolean _isSelected = false;
    private boolean _isMultipleSelection = false;
    private boolean _hasFocus = false;
    private boolean _hasTreeFocus = false;
    private Color foregroundSelected;
    private Color backgroundSelected;
    private Color foregroundUnselected;
    private Color backgroundUnselected;
    private Color foregroundSelectedUnfocus;
    private Color backgroundSelectedUnfocus;

    public TreePanelCellRenderer() {
        this.setHorizontalAlignment(2);
        this.foregroundSelected = UIManager.getColor("textHighlightText");
        this.backgroundSelected = UIManager.getColor("textHighlight");
        this.foregroundUnselected = UIManager.getColor("controlText");
        this.backgroundUnselected = UIManager.getColor("window");
        this.foregroundSelectedUnfocus = UIManager.getColor("controlText");
        this.backgroundSelectedUnfocus = UIManager.getColor("control");
    }

    public void updateUI() {
        super.updateUI();
        this.setBackground(null);
    }

    public boolean isMultipleSelection(JTree jTree) {
        TreePath[] treePathArray = jTree.getSelectionPaths();
        return treePathArray != null && treePathArray.length > 0;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this._hasTreeFocus = jTree.hasFocus();
        this._isMultipleSelection = this.isMultipleSelection(jTree);
        this._hasFocus = bl4;
        this._isSelected = bl;
        if (this._isSelected) {
            if ((this._hasFocus || this._isMultipleSelection) && this._hasTreeFocus) {
                this.setForeground(this.foregroundSelected);
            } else {
                this.setForeground(this.foregroundSelectedUnfocus);
            }
        } else {
            this.setForeground(this.foregroundUnselected);
        }
        if (object instanceof IDirNode) {
            IDirNode iDirNode = (IDirNode)object;
            this.setIcon(iDirNode.getIcon());
            this.setText(iDirNode.getName());
            this.setFont(UIManager.getFont("Tree.font"));
            this.setToolTipText(iDirNode.getDN());
        } else {
            this.setText(jTree.convertValueToText(object, bl, bl2, bl3, n, bl4));
        }
        return this;
    }

    public void paint(Graphics graphics) {
        Icon icon = this.getIcon();
        int n = this.getIconTextGap() - 2;
        int n2 = 0;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (n < 0) {
            n = 0;
        }
        if (icon != null) {
            n2 = icon.getIconWidth() + n;
        }
        Color color = this._isSelected ? ((this._hasFocus || this._isMultipleSelection) && this._hasTreeFocus ? this.backgroundSelected : this.backgroundSelectedUnfocus) : this.backgroundUnselected;
        graphics.setColor(color);
        if (icon != null && this.getText() != null) {
            graphics.fillRect(n2 + 1, 1, n3 - 2 - n2, n4 - 2);
        } else {
            graphics.fillRect(1, 1, n3 - 2 - n2, n4 - 2);
        }
        super.paint(graphics);
        if (this._isSelected) {
            if (this._hasFocus) {
                graphics.setColor(Color.black);
                BasicGraphicsUtils.drawDashedRect(graphics, n2, 0, n3 - 1 - n2, n4);
            } else {
                graphics.setColor(color);
                graphics.drawRect(n2, 0, n3 - 1 - n2, n4 - 1);
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension = new Dimension(dimension.width + 3, dimension.height);
        }
        return dimension;
    }
}

