/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ug;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.DefaultResEditorPage;
import com.netscape.management.client.ug.IResEditorAdvancedOpt;
import com.netscape.management.client.ug.IResourceEditorPage;
import com.netscape.management.client.ug.ResEditorGroupTitlePage;
import com.netscape.management.client.ug.ResEditorOUTitlePage;
import com.netscape.management.client.ug.ResEditorUserTitlePage;
import com.netscape.management.client.ug.ResourceEditorActionPane;
import com.netscape.management.client.ug.ResourcePageObservable;
import com.netscape.management.client.ug.SearchResultPanel;
import com.netscape.management.client.ug.TabListCellRender;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiOptionPane;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;

public class ResourceEditor
extends AbstractDialog
implements ActionListener,
ListSelectionListener,
Observer {
    static Hashtable _ResourceEditorExtension;
    static Hashtable _DeleteResourceEditorExtension;
    static Hashtable _AccountPlugin;
    static String _sUniqueAttribute;
    static String _sUserIDFormat;
    static String _sUserRDNComponent;
    static String _sGroupRDNComponent;
    static Hashtable _hNewObjectClasses;
    public static final String KEY_NEW_OU_OBJECTCLASSES = "newOUObjectClasses";
    public static final String KEY_NEW_GROUP_OBJECTCLASSES = "newGroupObjectClasses";
    public static final String KEY_NEW_USER_OBJECTCLASSES = "newUserObjectClasses";
    ResourceEditorActionPane _actionPane;
    JPanel _titlePane;
    JPanel _plugin;
    JSplitPane _splitPane;
    CardLayout _cardLayout;
    JPanel _pagePanel;
    DefaultListModel _tabListModel;
    JList _tabListbox;
    JScrollPane _tabListScrollPane;
    ResourcePageObservable _observableLDAPEntry;
    LDAPEntry _ldapEntry;
    Object _advancedOpt;
    boolean _newUser;
    JFrame _parent;
    ConsoleInfo _info;
    ResourceSet _resource = new ResourceSet("com.netscape.management.client.ug.PickerEditorResource");
    boolean _fSaveOK = false;
    Hashtable _oldClassHashtable;
    SearchResultPanel _resultPanel = null;
    final char[] ESCAPED_CHAR = new char[]{',', '+', '\"', '\\', ';'};

    public ResourceEditor(JFrame jFrame, ConsoleInfo consoleInfo, Vector vector, String string) {
        super(jFrame);
        this._parent = jFrame;
        this._newUser = true;
        this.init(consoleInfo, true, vector, string);
    }

    public ResourceEditor(JFrame jFrame, ConsoleInfo consoleInfo, Vector vector, String string, SearchResultPanel searchResultPanel) {
        super(jFrame);
        this._parent = jFrame;
        this._newUser = true;
        this._resultPanel = searchResultPanel;
        this.init(consoleInfo, true, vector, string);
    }

    public ResourceEditor(JFrame jFrame, ConsoleInfo consoleInfo, LDAPEntry lDAPEntry) {
        super(jFrame);
        this._parent = jFrame;
        this._ldapEntry = lDAPEntry;
        this._newUser = false;
        this.init(consoleInfo, false, lDAPEntry, null);
    }

    public ResourceEditor(JFrame jFrame, ConsoleInfo consoleInfo, LDAPEntry lDAPEntry, SearchResultPanel searchResultPanel) {
        super(jFrame);
        this._parent = jFrame;
        this._ldapEntry = lDAPEntry;
        this._newUser = false;
        this._resultPanel = searchResultPanel;
        this.init(consoleInfo, false, lDAPEntry, null);
    }

    void init(ConsoleInfo consoleInfo, boolean bl, Object object, String string) {
        this._info = consoleInfo;
        if (bl) {
            this._observableLDAPEntry = new ResourcePageObservable(consoleInfo, null, bl);
            this._observableLDAPEntry.setObjectClass((Vector)object);
            this.setTitle(this._resource.getString("resourceEditor", "NewUserTitle"));
        } else {
            this._observableLDAPEntry = new ResourcePageObservable(consoleInfo, (LDAPEntry)object, bl);
            this.setTitle(this._resource.getString("resourceEditor", "EditUserTitle"));
        }
        if (string != null) {
            this._observableLDAPEntry.setCreateBaseDN(string);
        }
        this._observableLDAPEntry.addObserver(this);
        this._titlePane = new JPanel(new BorderLayout());
        this._actionPane = new ResourceEditorActionPane(this);
        this._cardLayout = new CardLayout();
        this._pagePanel = new JPanel(this._cardLayout);
        this._pagePanel.setBorder(BorderFactory.createEtchedBorder());
        this._tabListModel = new DefaultListModel();
        this._tabListbox = new JList(this._tabListModel);
        this._tabListbox.getAccessibleContext().setAccessibleDescription(this._resource.getString("resourceEditor", "navigator_tt"));
        this._tabListbox.setCellRenderer(new TabListCellRender());
        this._tabListbox.addListSelectionListener(this);
        this._tabListScrollPane = new JScrollPane(this._tabListbox);
        this._tabListScrollPane.setPreferredSize(new Dimension(100, 200));
        this._splitPane = new JSplitPane(1, this._tabListScrollPane, this._pagePanel);
        this._splitPane.setDividerLocation((int)this._tabListScrollPane.getPreferredSize().getWidth());
        this._splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.setMinimumSize(640, 480);
        this.setupPlugin(object);
        if (this._tabListModel.getSize() == 0) {
            this.addPage(new DefaultResEditorPage());
        }
        this.setDisplay();
    }

    void setupPlugin(Object object) {
        Object object2;
        Object object3;
        Object object4;
        Hashtable hashtable = ResourceEditor.getResourceEditorExtension();
        Enumeration enumeration = null;
        if (object instanceof LDAPEntry) {
            object4 = (LDAPEntry)object;
            object3 = object4.getAttribute("ObjectClass");
            enumeration = object3.getStringValues();
        } else {
            enumeration = ((Vector)object).elements();
        }
        if (this._oldClassHashtable != null) {
            object4 = this._oldClassHashtable.elements();
            while (object4.hasMoreElements()) {
                object3 = object4.nextElement();
                if (!(object3 instanceof Observer)) continue;
                this._observableLDAPEntry.deleteObserver((Observer)object3);
            }
        }
        object4 = this._tabListbox.getSelectedIndex() != -1 ? ((IResourceEditorPage)this._tabListbox.getSelectedValue()).getID() : "";
        this._tabListModel.removeAllElements();
        object3 = new Hashtable();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            object2 = ((String)enumeration.nextElement()).toLowerCase();
            if (((String)object2).equals("person")) {
                bl = true;
            } else if (((String)object2).equals("groupofuniquenames")) {
                bl2 = true;
            }
            Vector vector = (Vector)hashtable.get(object2);
            if (vector == null) continue;
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                String string = "";
                try {
                    Object v;
                    block24: {
                        Class clazz;
                        block23: {
                            clazz = (Class)enumeration2.nextElement();
                            string = clazz.getName();
                            if (object3.get(string) != null) continue;
                            v = null;
                            if (this._oldClassHashtable == null) break block23;
                            Object v2 = this._oldClassHashtable.get(string);
                            v = v2;
                            if (v2 != null) break block24;
                        }
                        if ((v = (Object)clazz.newInstance()) instanceof IResourceEditorPage) {
                            object3.put(string, v);
                            if (!this.addPage((IResourceEditorPage)v)) continue;
                            if (((IResourceEditorPage)v).getID().equals(object4)) {
                                n2 = n;
                            }
                            ++n;
                            continue;
                        }
                        Debug.println(string + " is not an instance of IResourceEditorPage.");
                        continue;
                    }
                    IResourceEditorPage iResourceEditorPage = (IResourceEditorPage)v;
                    if (iResourceEditorPage.getID() != null) {
                        if (iResourceEditorPage instanceof Observer) {
                            this._observableLDAPEntry.addObserver((Observer)((Object)iResourceEditorPage));
                        }
                        this._tabListModel.addElement(iResourceEditorPage);
                        if (iResourceEditorPage.getID().equals(object4)) {
                            n2 = n;
                        }
                        ++n;
                    }
                    object3.put(string, v);
                }
                catch (Exception exception) {
                    Debug.println(0, "Cannot create class: " + string);
                }
            }
        }
        this._tabListbox.setSelectedIndex(n2);
        this._oldClassHashtable = object3;
        if (bl) {
            object2 = new ResEditorUserTitlePage(this._observableLDAPEntry);
            this.setTitlePanel((JPanel)object2);
        } else if (bl2) {
            object2 = new ResEditorGroupTitlePage(this._observableLDAPEntry);
            this.setTitlePanel((JPanel)object2);
        } else {
            object2 = new ResEditorOUTitlePage(this._observableLDAPEntry);
            this.setTitlePanel((JPanel)object2);
        }
    }

    void setDisplay() {
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagUtil.constrain(container, this._titlePane, 0, 0, 0, 1, 1.0, 0.0, 18, 2, 0, 0, 0, 0);
        GridBagUtil.constrain(container, this._splitPane, 0, 1, 0, 1, 1.0, 1.0, 10, 1, 12, 0, 0, 0);
        GridBagUtil.constrain(container, this._actionPane, 0, 2, 0, 0, 1.0, 0.0, 16, 2, 12, 0, 0, 0);
    }

    public void setIndexAttribute(String string) {
        this._observableLDAPEntry.setIndexAttribute(string);
    }

    public LDAPEntry getLDAPEntry() {
        return this._ldapEntry;
    }

    public ResourcePageObservable getLDAPObservable() {
        return this._observableLDAPEntry;
    }

    boolean isMultiValuedRDN(String string) {
        if (string == null) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        boolean bl = false;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '\\') {
                char c = stringBuffer.charAt(n + 1);
                int n2 = 0;
                while (n2 < this.ESCAPED_CHAR.length) {
                    if (c == this.ESCAPED_CHAR[n2]) {
                        ++n;
                        break;
                    }
                    ++n2;
                }
            } else if (stringBuffer.charAt(n) == '\"') {
                bl = !bl;
            } else if (stringBuffer.charAt(n) == '+' && !bl) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this._tabListModel.size() != 0) {
            IResourceEditorPage iResourceEditorPage = (IResourceEditorPage)this._tabListbox.getSelectedValue();
            Debug.println("ResourceEditor.valueChanged: o=" + iResourceEditorPage);
            if (iResourceEditorPage != null) {
                this._cardLayout.show(this._pagePanel, iResourceEditorPage.getID());
            }
        } else {
            Debug.println("ResourceEditor.valueChanged: empty tab list");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Component component;
        if (actionEvent.getActionCommand().equals("Ok")) {
            int n = 0;
            while (n < this._tabListModel.getSize()) {
                if (!((IResourceEditorPage)this._tabListModel.elementAt(n)).isComplete()) {
                    this._tabListbox.setSelectedIndex(n);
                    return;
                }
                ++n;
            }
            try {
                String[] stringArray = LDAPDN.explodeDN((String)this._observableLDAPEntry.getDN(), (boolean)false);
                if (stringArray != null && this.isMultiValuedRDN(stringArray[0])) {
                    SuiOptionPane.showMessageDialog((Component)this.getFrame(), (Object)this._resource.getString("resourceEditor", "UnableToSaveRDNEntryText"), (String)this._resource.getString("resourceEditor", "SaveErrorTitle"), (int)0);
                    return;
                }
                int n2 = 0;
                while (n2 < this._tabListModel.getSize()) {
                    ((IResourceEditorPage)this._tabListModel.elementAt(n2)).save(this._observableLDAPEntry);
                    ++n2;
                }
                this._ldapEntry = this._observableLDAPEntry.save();
                int n3 = 0;
                while (n3 < this._tabListModel.getSize()) {
                    ((IResourceEditorPage)this._tabListModel.elementAt(n3)).afterSave(this._observableLDAPEntry);
                    ++n3;
                }
                this._ldapEntry = this._observableLDAPEntry._entry;
                if (this._resultPanel != null) {
                    if (this._resultPanel.getListCount() <= 0 || this._resultPanel.getSelectedRowCount() <= 0) {
                        this._resultPanel.addElement(this._ldapEntry);
                    } else {
                        this._resultPanel.updatedSelectedItem(this._ldapEntry);
                    }
                }
                this._fSaveOK = true;
            }
            catch (Exception exception) {
                SuiOptionPane.showMessageDialog((Component)this.getFrame(), (Object)(this._resource.getString("resourceEditor", "SaveErrorText") + exception), (String)this._resource.getString("resourceEditor", "SaveErrorTitle"), (int)0);
                if (Debug.isEnabled()) {
                    exception.printStackTrace();
                }
                ModalDialogUtil.sleep();
                return;
            }
            super.setVisible(false);
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            super.setVisible(false);
        } else if (actionEvent.getActionCommand().equals("advanced")) {
            if (((IResEditorAdvancedOpt)this._advancedOpt).run(this._info, this._observableLDAPEntry)) {
                int n = 0;
                while (n < this._tabListModel.getSize()) {
                    IResourceEditorPage iResourceEditorPage = (IResourceEditorPage)this._tabListModel.elementAt(n);
                    iResourceEditorPage.initialize(this._observableLDAPEntry, this);
                    ++n;
                }
            }
        } else if (actionEvent.getActionCommand().equals("help") && (component = (Component)this._tabListbox.getSelectedValue()) instanceof IResourceEditorPage) {
            ((IResourceEditorPage)((Object)component)).help();
        }
    }

    public IResourceEditorPage getPage(int n) {
        IResourceEditorPage iResourceEditorPage;
        try {
            iResourceEditorPage = (IResourceEditorPage)this._tabListModel.elementAt(n - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.println(0, "ResourceEditor.getPage: array index out of bounds exception");
            iResourceEditorPage = null;
        }
        return iResourceEditorPage;
    }

    public int getPageCount() {
        return this._tabListModel.getSize();
    }

    public boolean addPage(IResourceEditorPage iResourceEditorPage) {
        boolean bl = false;
        iResourceEditorPage.initialize(this._observableLDAPEntry, this);
        if (iResourceEditorPage instanceof Component && iResourceEditorPage.getID() != null) {
            this._tabListModel.addElement(iResourceEditorPage);
            this._pagePanel.add((Component)((Object)iResourceEditorPage), iResourceEditorPage.getID());
            bl = true;
            if (iResourceEditorPage instanceof Observer) {
                this._observableLDAPEntry.addObserver((Observer)((Object)iResourceEditorPage));
            }
        }
        return bl;
    }

    public void deletePage(int n) {
        if (n <= this.getPageCount() && n > 0) {
            Component component = (Component)this._tabListModel.elementAt(n - 1);
            this._tabListModel.removeElementAt(n - 1);
            this._cardLayout.removeLayoutComponent(component);
        }
    }

    public void setPageEnable(int n, boolean bl) {
        try {
            if (n > this.getPageCount() || n < 1) {
                Debug.println("ResourceEditor.setPageEnable: invalid page: " + n);
                return;
            }
            IResourceEditorPage iResourceEditorPage = (IResourceEditorPage)this._tabListModel.elementAt(n - 1);
            iResourceEditorPage.setEnable(bl);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.println(0, "ResourceEditor.java : setPageEnable : Array out of bound.");
        }
    }

    public void setReadOnly(boolean bl) {
        try {
            int n = this.getPageCount();
            int n2 = 0;
            while (n2 < n) {
                IResourceEditorPage iResourceEditorPage = (IResourceEditorPage)this._tabListModel.elementAt(n2);
                iResourceEditorPage.setReadOnly(bl);
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.println(0, "ResourceEditor.java : setReadOnly : Array out of bound...");
        }
    }

    public void setTitlePanel(JPanel jPanel) {
        if (jPanel != this._titlePane) {
            if (this._titlePane.getComponentCount() == 1) {
                this._titlePane.remove(0);
            }
            if (jPanel != null) {
                this._titlePane.add("North", jPanel);
                if (jPanel instanceof Observer) {
                    this._observableLDAPEntry.addObserver((Observer)((Object)jPanel));
                }
                this.validate();
                this.repaint();
            }
        }
    }

    public JPanel getTitlePanel() {
        if (this._titlePane.getComponentCount() == 1) {
            return (JPanel)this._titlePane.getComponent(0);
        }
        return null;
    }

    public boolean showModally() {
        super.showModal();
        return this._fSaveOK;
    }

    public boolean getSaveStatus() {
        return this._fSaveOK;
    }

    public JFrame getFrame() {
        return this._parent;
    }

    public ConsoleInfo getConsoleInfo() {
        return this._info;
    }

    public void registerAdvancedOption(IResEditorAdvancedOpt iResEditorAdvancedOpt) {
        this._advancedOpt = iResEditorAdvancedOpt;
        String string = iResEditorAdvancedOpt.getButtonText();
        if (string != null && string != "") {
            this._actionPane.setAdvancedText(string);
        }
        this._actionPane.enableAdvanced(true);
    }

    public void update(Observable observable, Object object) {
        String string;
        Debug.println("ResourceEditor.update: o=" + observable + " arg=" + object);
        if (observable instanceof ResourcePageObservable && (string = (String)object) != null && string.toLowerCase().equals("objectclass")) {
            this.setupPlugin(((ResourcePageObservable)observable).get("objectclass"));
        }
    }

    public void helpInvoked() {
        System.out.println("ResourceEditor: Help Not Implemented");
    }

    public static void setUniqueAttribute(String string) {
        _sUniqueAttribute = string;
    }

    public static String getUniqueAttribute() {
        return _sUniqueAttribute;
    }

    public static void setUserIDFormat(String string) {
        _sUserIDFormat = string;
    }

    public static String getUserIDFormat() {
        return _sUserIDFormat;
    }

    public static void setUserRDNComponent(String string) {
        _sUserRDNComponent = string;
    }

    public static String getUserRDNComponent() {
        return _sUserRDNComponent;
    }

    public static void setGroupRDNComponent(String string) {
        _sGroupRDNComponent = string;
    }

    public static String getGroupRDNComponent() {
        return _sGroupRDNComponent;
    }

    public static void setAccountPlugin(Hashtable hashtable) {
        _AccountPlugin = hashtable;
    }

    public static Hashtable getAccountPlugin() {
        return _AccountPlugin;
    }

    public static void setNewObjectClasses(Hashtable hashtable) {
        _hNewObjectClasses = hashtable;
    }

    public static Hashtable getNewObjectClasses() {
        return _hNewObjectClasses;
    }

    public static void setResourceEditorExtension(Hashtable hashtable) {
        _ResourceEditorExtension = hashtable;
    }

    public static Hashtable getResourceEditorExtension() {
        return _ResourceEditorExtension;
    }

    public static void setDeleteResourceEditorExtension(Hashtable hashtable) {
        _DeleteResourceEditorExtension = hashtable;
    }

    public static Hashtable getDeleteResourceEditorExtension() {
        return _DeleteResourceEditorExtension;
    }

    static {
        _sUniqueAttribute = "uid";
        _sUserIDFormat = "";
        _sUserRDNComponent = "uid";
        _sGroupRDNComponent = "cn";
        _hNewObjectClasses = new Hashtable();
    }
}

