/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.ResourceSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;

public class LDAPOutputStream
extends ByteArrayOutputStream {
    private LDAPConnection _ldc;
    private String _dn;
    private String _attribute;
    private ResourceSet _resource;

    public LDAPOutputStream(LDAPConnection lDAPConnection, String string, String string2) {
        this._ldc = lDAPConnection;
        this._dn = string;
        this._attribute = string2;
        this._resource = new ResourceSet("com.netscape.management.client.util.default");
    }

    public void delete() throws LDAPException {
        this._ldc.delete(this._dn);
    }

    private void modify() throws LDAPException {
        LDAPAttribute lDAPAttribute = new LDAPAttribute(this._attribute, new String(this.buf, 0, this.count));
        LDAPModification lDAPModification = new LDAPModification(2, lDAPAttribute);
        this._ldc.modify(this._dn, lDAPModification);
    }

    public void flush() throws IOException {
        super.flush();
        try {
            this.modify();
        }
        catch (LDAPException lDAPException) {
            switch (lDAPException.getLDAPResultCode()) {
                case 32: {
                    throw new IOException(this._resource.getString("error", "CannotModify1") + " " + (Object)((Object)lDAPException));
                }
            }
            throw new IOException(this._resource.getString("error", "CannotModify2") + " " + (Object)((Object)lDAPException));
        }
    }

    public void close() throws IOException {
        this.flush();
        super.close();
    }
}

