#!/bin/sh
#
# Script to ftp/upload patch system files to a target T4 system
#
#pragma ident   "@(#)6120.sh 1.7     03/10/13 SMI"
# 
#
# Algorithm:
#
#  o Prompt User for required information
#    - Prompt for $TARGET_SYSTEM (hostname or IP Address)
#      Ping $TARGET_SYSTEM user entered
#      -> Exit if ping fails (system unreachable)
#    - Prompt For $HOME_DIRECTORY Location 
#      -> Exit if can't write a file in home directory
#    - Prompt for top level directory of patch image ($PATCH_DIR)
#      -> Need to locate files.tar within that directory tree
#	 set $PATCH_DIR
#      -> copy files.tar image to /tmp/$PID
#	 set $PATCH_DIR /tmp/$PID
#      -> Exit if can't find patch location or reprompt
#    - Warn User they must set root password on target T4
#
#  o Set interrupts so cleanup routine is used
#   Cleanup Routine:
#      -> rm  ~/.netrc 
#      -> rm -r /tmp/$PID 
#
#  o Create ~/.netrc
#    Check for existing ~/.netrc and preserve if one exists
#    Dump the following into ~/.netrc:
#      machine $TARGET_SYSTEM
#      macdef init
#      bin
#      prompt
#      lcd /etc
#      cd $PATCHDIR
#      cd etc
#      mput *
#      lcd /web
#      cd ../web
#      mput *
#      mkdir snmp
#      lcd snmp
#      cd snmp
#      mput *
#      quit
#
#    Remove read permissions from ~/.netrc
#
#  o Start ftp process
#    exec 'ftp TARGET_T4'
#
#  o Perform File Validation ?
#    -> Perhaps snapshot a long filelisting and cmp with
#       local image?
#
#  o Cleanup Local Files
# 
#  o Restore preserved ~/.netrc if applicable 
#
#  o Exit

# Script Variables
TOC=patchtoc		  # Patch Table Of Contents File
TARGET=                   # T4 To Be Upgraded 
TRUE=1                    # Boolean true
FALSE=0                   # Boolean false
PATCHDIR=.		  # Patch Directory Location
RESP=' '
ERR=0			  # Error Counter
TMPDIR=/tmp/upload.$$     # Temporary Directory
TMPNETRC=/tmp/netrc.$$    # Backup copy of existing .netrc
HOMEDIR=$HOME		  # User's default home directory.

# Time Zone variables
TZDIST=`pwd`
TZDIR=etc/zoneinfo
TZROOT=/etc/zoneinfo

netrc_gen() {
  #  Routine to Create ~/.netrc
  echo "Enter Your Home Directory Path [$HOMEDIR]: \c"
  read NEW_HOME
  if [ "X$NEW_HOME" != 'X' ];then
     HOME=$NEW_HOME
     HOMEDIR=$HOME
     export HOME
  else
     # Check to see if $HOME exist
     if [ "X$HOME" = 'X' ]; then
        UID=`id | cut -b5`
        if [ "$UID" = 0 ]; then
           HOME='/'
           HOMEDIR=$HOME
           export HOME
        fi
     fi
  fi
  if [ -f $HOMEDIR/.netrc ]; then
    mv $HOMEDIR/.netrc $TMPNETRC    # Preserve existing .netrc
  fi
  echo "Enter ftp user"
  read FTPUSER
  echo "Enter ftp password"
  read FTPPW
  echo "Creating Auto ftp File In [$HOMEDIR/.netrc]..."
  if [ "X$FTPPW" != 'X' ];then
    echo "machine $TARGET login $FTPUSER password $FTPPW" > $HOMEDIR/.netrc
  else
    echo "machine $TARGET login $FTPUSER password \\r" > $HOMEDIR/.netrc
  fi
  echo "macdef init" >> $HOMEDIR/.netrc
  echo "bin"  >> $HOMEDIR/.netrc
  echo "prompt"  >> $HOMEDIR/.netrc

  # Controller/lpc/ep firmware
  # echo "cd /tmp/incoming"  >> $HOMEDIR/.netrc  # Testing Only
  echo "cd /"  >> $HOMEDIR/.netrc
  echo "lcd $TMPDIR"  >> $HOMEDIR/.netrc
  echo "mkdir etc"  >> $HOMEDIR/.netrc
  echo "mkdir web"  >> $HOMEDIR/.netrc
  echo "mkdir web/snmp"  >> $HOMEDIR/.netrc

  # Load Controller and loopcard firmware
  echo "mput t4l3*.bin"  >> $HOMEDIR/.netrc
  echo "mput t4l2*.bin"  >> $HOMEDIR/.netrc
  echo "mput lpc*.bin"  >> $HOMEDIR/.netrc

  # Load /etc files     # Only copy over bat.conf
  echo "cd etc"  >> $HOMEDIR/.netrc
  echo "lcd files/etc"  >> $HOMEDIR/.netrc
  echo "rename bat.conf bat_old.conf"  >> $HOMEDIR/.netrc # Save old
  echo "put bat.conf"  >> $HOMEDIR/.netrc      

  # Load Web files
  echo "cd ../web"  >> $HOMEDIR/.netrc
  echo "lcd ../web"  >> $HOMEDIR/.netrc
  echo "mput *"  >> $HOMEDIR/.netrc
  echo "cd snmp"  >> $HOMEDIR/.netrc
  echo "lcd snmp"  >> $HOMEDIR/.netrc
  echo "mput *"  >> $HOMEDIR/.netrc

  # Load Time Zone files
  echo "mkdir "  $TZROOT >> $HOMEDIR/.netrc
  echo "cd " $TZROOT  >> $HOMEDIR/.netrc

  cd $TMPDIR/files  
  TZALLDIR="`cd etc/zoneinfo; find . -type d -print`"

  for d in $TZALLDIR; do
  if [ "X$d" != "X." ]; then
  if [ "X`dirname $d`" != "X." ]; then
  echo "mkdir " "`dirname $d | tr -d "./"`/`basename $d`" >> $HOMEDIR/.netrc;
  else
  echo "mkdir " "`basename $d`" >> $HOMEDIR/.netrc;
  fi
  fi
  done

  echo "lcd ../../etc/zoneinfo" >> $HOMEDIR/.netrc
  echo "mput * " >> $HOMEDIR/.netrc


  for d in $TZALLDIR; do
  if [ "X$d" != "X." ]; then
  if [ "X`dirname $d`" != "X." ]; then
  echo "cd "  "`dirname $d | tr -d "./"`/`basename $d`" >> $HOMEDIR/.netrc;
  echo "lcd " "`dirname $d | tr -d "./"`/`basename $d`" >> $HOMEDIR/.netrc;
  echo "mput * " >> $HOMEDIR/.netrc;
  echo "cd ../.. " >> $HOMEDIR/.netrc;
  echo "lcd ../.. " >> $HOMEDIR/.netrc;
  else
  echo "cd " "`basename $d`" >> $HOMEDIR/.netrc;
  echo "lcd " "`basename $d`" >> $HOMEDIR/.netrc;
  echo "mput * " >> $HOMEDIR/.netrc;
  echo "cd .. " >> $HOMEDIR/.netrc;
  echo "lcd .. " >> $HOMEDIR/.netrc;
  fi
  fi
  done

  echo "quit\n\n"  >> $HOMEDIR/.netrc
  chmod 600 $HOMEDIR/.netrc
}

cleanup() {
  echo "\nCleaning Up Temporary Files..."
  cd $HOMEDIR
  rm -rf $TMPDIR 		# Cleanup Archive File
  rm -f $HOMEDIR/.netrc		# Remove .netrc file
  if [ -f $TMPNETRC ]; then
    mv $TMPNETRC $HOMEDIR/.netrc  # Restore previous .netrc
  fi
}

error_exit_code() {
  cleanup
  echo "Exiting $0...."
  exit 1
}

trap "error_exit_code" 1 2 3

# Mainline code starts here
echo  'Please Enter Hostname or IP Address Of T4 To Be Ugpraded: \c'
read TARGET    
ping $TARGET
ERRCODE=$?      
if [ $ERRCODE -ne $FALSE ]; then
  echo 'Target System Unreachable.'
  error_exit_code;
fi

# Get Location of T4 System Files To Upload
echo  "Please Enter Patch Location Pathname [$PATCHDIR]: \c"
read TMP    

if [ "999$TMP" != "999" ]; then
  PATCHDIR=$TMP
fi

# Verify Patch Contents
echo "Looking For Patch Contents In [$PATCHDIR]..."
# 
mkdir $TMPDIR   # Create /tmp directory With File Contents To Upload
ERR=0
FILENAME=patchtoc
PATCHTOC=$PATCHDIR/$FILENAME
echo "----------------- $PATCHTOC -------------------"
if [ -f "${PATCHTOC}" ]; then
  for file in `cat $PATCHDIR/$TOC`
  do
   if [ -s $PATCHDIR/$file ]; then
    echo "$file image located"
    cp $PATCHDIR/$file $TMPDIR
   else
    echo "$file image missing"
    ERR=`expr $ERR + 1`
   fi
  done
else
  echo "Patch TOC Not Found*** $PATCHDIR/$TOC ***"
  ERR=`expr $ERR + 1`
fi

if [ $ERR -gt 0 ]; then
  error_exit_code
fi

PWD=`pwd`
mkdir $TMPDIR/files
cd $TMPDIR/files
tar xfp $TMPDIR/files.tar       # Extract System Files Tar Image
cd $PWD

netrc_gen			# Generate netrc file

# Start ftp process
echo "Invoking ftp"
ftp $TARGET 

cleanup				# Remove temp directories

exit 0
