package GUI::Cache;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


use System;
use Util;
use Util::Http;
use strict;

sub get_dir {
  my($q) = @_;

 my $dir =  System->get_home() . "/DATA/OLD_REPORTS";
 opendir(O, $dir);
 my @a  = readdir(O);
 closedir(O);
 my %X = (); my $cnt = 0;
 my @O;
 foreach my $f (sort @a) {
    my @b = split(/:/, $f);
    next if ($#b < 1);
    next if (index(",message,host,DiskInquiry,san,", ",$b[0],") >= 0);
    open(O, "$dir/$f");
    my $A = ""; 
    my $ll;
    my $N = "";
    while ($ll = <O>) {
        if ($ll =~ /\'accessName\' \=\>/) {
           $A = $ll;
           $A =~ s/'accessName' => '//;
           $A = substr($A, 0, -3);
        } elsif ($ll =~ /\'name\' \=\>/  ) {
           $N = $ll;
           $N =~ s/'name' => '//;
           $N = substr($N,0, -3);
        }
    }
    close(O);
    my $access = $A;

    $access .= " / $N" if ($N && ($N ne $A));

    if (!$X{$b[0].$b[1]}) {
      push(@O, "$f\t$b[0]\t$b[1]\t$access");
    }
 }
 if ($q->{HTTP}) {
   print join("\n", @O);
 } else {
   return \@O;
 }
}


######################################################
#   ERASE CACHE
######################################################

sub erase {
  my($q) = @_;
  my $ERR;
  my $G = Labels->read();
  my $L = Labels->read('GUI::Cache');

  print "\n<body bgcolor=$Style::BGCOLOR>";
  if (my $deny = Roles->verifyRole($q, "admin")) {
     print $deny;
     return;
  }
  if ($q->{ACTION_deldb}) {
     if ($q->{host} eq "Local") {
       system(System->get_home() . "/sbin/delete_data_db");
     } else {
       Util::Http->runit($q->{host}, "/sbin/delete_data_db");
     }
  } elsif ($q->{ACTION_delall}) {
     if ($q->{host} eq "Local") {
       system(System->get_home() . "/sbin/delete_old_reports");
     } else {
       Util::Http->runit($q->{host}, "/sbin/delete_old_reports");
     }
     
  } elsif ($q->{ACTION_delete}) {
     foreach my $x (keys %$q) {
       if (substr($x,0,4) eq "del_") {
           my $file = substr($x,4);
           print "--> $G->{deleting} $file <br>\n";
           if (substr($file, 0, 5) eq "FILE_") {
             $file = substr($file, 5);
             if ($q->{host} eq "Local") {
                unlink System->get_home() . "/DATA/$file";
             } else {
                Util::Http->deleteFile($q->{host}, "/$file");
             }
           } else {
             if ($q->{host} eq "Local") {
                unlink System->get_home() . "/DATA/OLD_REPORTS/$file";
             } else {
                Util::Http->deleteFile($q->{host}, "OLD_REPORTS/$file");
             }
           }
        }
     }
  }
  print "<center>";
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
  
  print Html->header2('admin.system.erase_cache') ;

  my $l = "Local=$G->{local}|";
  foreach my $h (@$hosts) {
     $l .= "$h->{ipno}=$h->{hostname}|";
  }
  my $select = Util->makeSelect("host", $l, $q->{host});

 print "
  <form><input type=hidden name=GO value=GUI::Cache::erase>
 $ERR
 &nbsp;
<table border=1 cellspacing=0 width=90% bgcolor=white><tr>
   <td align=right bgcolor=$Style::LIGHT>Select Host:</td>
   <td>$select <input type=submit name=ACTION_display value=\"$L->{display}\">
 </table>
<table border=1 cellspacing=0 width=90% bgcolor=white>
<tr><td colspan=4 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{dev} $q->{host}</td>
<tr>
   <td bgcolor=$Style::LIGHT><center><b>$L->{type}</td>
   <td bgcolor=$Style::LIGHT>&nbsp;<b>$L->{devid}</td>
   <td bgcolor=$Style::LIGHT>&nbsp;<b>$L->{name}</td>
   <td bgcolor=$Style::LIGHT>&nbsp;<b>$L->{delete}</td>
 ";
 $ERR = "";
 
 my (@L, $out);
 $q->{host} = "Local" if (!$q->{host});
 if ($q->{host} eq "Local") {
   $out = &get_dir({});

 } elsif ($q->{host}) {
   my $rc = Util::Http->getCommand($q->{host}, "GUI::Cache::dir&HTTP=1");
   @L = split(/\n/, $rc);
   $out = \@L;
 }
 my $cnt;
 foreach my $l (@$out) {
     my($f,$b0, $b1, $access) = split(/\t/, $l);
     my $del = "<input type=checkbox name=\"del_$f\">";
     print "<tr><td>$b0</td><td>$b1</td><td>$access</td><td>$del</td>\n";
     $cnt++;
 }
 my $LS = "last_srs_topo";
 my $del;
 if (-f System->get_home() . "/DATA/$LS")  {
   $del  = "<input type=checkbox name=\"del_FILE_$LS\">";
   print "<tr><td>topo</td><td>SRS-topo</td><td>/DATA/$LS</td><td>$del</td>";
   $cnt++;
 }

 if (!$cnt) {
   print "<tr><td colspan=4><b>$L->{nothing}</td>";
 }
 print "</table><b>
  <input type=submit name=ACTION_delete value=\"$L->{submit_del}\">
  <input type=submit name=ACTION_delall value=\"$L->{submit_all}\">
  <input type=submit name=ACTION_deldb  value=\"$L->{submit_complete}\">
  </form>
  ";

}
sub erase2 {
 my($q) = @_;
 my $ERR;
 print "\n";
 my $renv = System->get_renv();
 my $hostname = $renv->{hostname};
 my $erase = $q->{file};

 if ($erase eq "COUNTERS") {
    my $dir =  System->get_home() . "/DATA/tmp";
    system("rm $dir/lux*");
    $ERR = "<font color=red><big><b><center>Fibre Counters deleted!</b></big></font></center>";
 }
 if ($erase eq "ALL") {
    my($DATA)  = System->get_home() . "/DATA";
    system("/bin/rm $DATA/topo/*");
    system("/bin/rm $DATA/catalog/*");
    system("/bin/rm $DATA/state/*");
 }
 my @b  = split(/:/, $erase);

 my $dir =  System->get_home() . "/DATA/OLD_REPORTS";
 opendir(O, $dir);
 my @a  = readdir(O);
 closedir(O);
 foreach my $file (@a) {
    my @c = split(/:/, $file);
    next if ($#c < 1);
    if ($erase eq "ALL" || ($b[0] eq $c[0] && $b[1] eq $c[1]) ) {
       unlink (System->get_home() . "/DATA/OLD_REPORTS/$file");
       $ERR .= "<font color=red><big><b><center>Cache file : $file was deleted</center></b></big></font>";
    }
 }
 &erase($q);
}


1;

