package GUI::Email;

use System;
use Html;
use Util;
use strict;
use Mail;

######################################################
#   TEST EMAIL
######################################################

sub test {
  my($q) = @_;
  my($err,  $addr, $header);

  my($renv, $dev, $host, $notifs) = PDM::ConfigFile->read();
  my $G = Labels->read();

  my($default) = $notifs->[0]->{email};
  print Html->body();
  my($h) = Html->header2("admin.gen_maint.test_email");
 
  print "\n<body bgcolor=$Style::BGCOLOR><center>&nbsp;";

  if ($q->{ACTION_submit}) {
        ($renv, $dev, $host, $notifs) = PDM::ConfigFile->read();

        $addr = $q->{email};
        if ($addr =~ /.+\@.+/) {

          my $rc = Mail->mail($addr, "Storage A.D.E", "Test Message", 
                  "$G->{customer}: $renv->{customer}\n"
                   . "-" x 50 . "\n" . $q->{message});
           
          if ($rc) {
             $err = Html->error($rc);
          } else {
            $err = Html->info($G->{delivered});
          }
        } else  {
          $err = "<table border=0 bgcolor=white><tr><td><b><font color=red>$G->{invalid_email}</table>";
        }
  }


  my $o =<<EOF;
  $h
$err
&nbsp;
<table border=2 cellspacing=0 cellpadding=0 bgcolor=white width=90%><tr><td>
<form  method=get>
<input type=hidden name=GO value=GUI::Email::test>
<table border=0 cellspacing=2 cellpadding=2 bgcolor=white width=100%>
 <tr><td align=right bgcolor=$Style::LIGHT><b>&nbsp;$G->{email_addr}: </td>
     <td><input type=text name=email size=30 value=\"$default\">
 <tr><td bgcolor=$Style::LIGHT align=right><b>&nbsp;$G->{message}: </td>
     <td><input type=text name=message size=50>
</table></table>
<b>
<input type=submit name=ACTION_submit value="$G->{submit}">
</form>
EOF

  print $o;

}


1;

