package GUI::Policy;

use System;
use Map;
use strict;

sub list {
  my($q) = @_;

  my $m = Map->getDeviceStateMap();
  $m = $m->{map};
  my $LB = Labels->read("GUI::Policy");

  print Html->body();
  print Html->header2("report.system.policy");
  my($b1,$b2,$b3,$b4);
  if ($q->{device} eq "CLOSE") {
     $b1 = "<b>"; $b2= "</b>";
  } else {
     $b3 = "<b>"; $b4= "</b>";
  }

  my $link = "[ <a href=$Http::WEBPROC?GO=GUI::Policy::list&device=CLOSE><font color=white>${b1}$LB->{summ}${b2}</font></a> | ".
     "<a href=$Http::WEBPROC?GO=GUI::Policy::list><font color=white>${b3}$LB->{detail}${b4}</font></a> ]";
  my $out = "<table border=1 cellspacing=0 bgcolor=white width=90%>
  <tr bgcolor=$Style::DARK><td colspan=5>
    <table border=0 cellspacing=0 cellpadding=2 width=100%>
      <tr><td align=right><font color=white>$link</td>
    </table>
  <tr bgcolor=$Style::LIGHT>
      <th width=5%>$LB->{dev}</th>
      <td align=right><b>$LB->{name}&nbsp;</th>
      <td><b>&nbsp;$LB->{value}</td>
      <th width=10%>$LB->{sev}</th>
      <th width=10%>$LB->{act}</th>
    ";
  my @SEV = ("<td><center>$LB->{notice}",
             "<td bgcolor=#FFFFD0><center>$LB->{warning}",
             "<td bgcolor=#FFC0C0><center><b><b>$LB->{error}",
             "<td bgcolor=#FFC0C0><center>$LB->{down}");
  my ($sign, $sign0);
  if ($q->{device} && $q->{device} ne "CLOSE") {
     $sign = $q->{sign} eq "P" ? "M" : "P";
     $sign0 = $sign eq "P" ? "+" : "";
     $q->{device} = "CLOSE" if ($sign eq "M");
  }
  my ($last_dev, $last_tag);
  foreach my $e0 (sort keys %$m) {
     my $device = $e0;
     $device =~ s/.availability//;
     next if (index(",se,se2,", ",$device,") >= 0) ;
     my $vals = $m->{$e0};
     if ($q->{device} eq $e0 || !$q->{device} || $q->{device} eq "CLOSE") {
       $out .= "
        <tr bgcolor=#F0F0F0><td><center><b>" .
        "$sign0<a href=$Http::WEBPROC?GO=GUI::Policy::list&device=$e0&sign=$sign>" .
         ucfirst($device) . "</a> " .
         "</td><td colspan=4><b>&nbsp;" . Util->abb("$device.medium");
     }
     next if ($sign eq "M");
     next if ($q->{device} eq "CLOSE" || ($q->{device} && $q->{device} ne $e0));
     foreach my $v (sort keys %$vals) {
         my ($v1, $v2, $tag_value, $tag_value2, $tag_name, $tag_name2);
         my ($avail, $sev, $action);
         my $availS = "";
         if (substr($v,-1) eq "~") { # transition
            ($v1,$v2) = split(/\,/, substr($v,0,-1));
            $v1 =~ s/O\.K\./OK/;
            $v2 =~ s/O\.K\./OK/;
            if ($v2 eq "START") {
              my $ix = rindex($v1, ".");
              $tag_name   = substr($v1,0,$ix);
              $tag_value2  = " (FIRST_REPORT)";
              $tag_value = substr($v1,$ix+1);

            } else {
              my $ix = rindex($v2, ".");
              $tag_name = substr($v2,0,$ix);
              $tag_value = substr($v2,$ix+1) . " <b>=></b>";

              my $ix = rindex($v1, ".");
              $tag_name2 = substr($v1,0,$ix);
              $tag_value2 = substr($v1,$ix+1);
            }
            ($sev, $action) = @{$vals->{$v}};

         } else {
            $v1 = $v;
            $v1 =~ s/O\.K\./OK/;
            my $ix = rindex($v1, ".");
            $tag_name = substr($v1,0,$ix);
            $tag_value = substr($v1,$ix+1);
            ($avail, $sev, $action) = @{$vals->{$v}};
            if ($tag_name ne "alarmEvent") {
              $availS = ($avail == 1) ? "<b>$LB->{yes}" : "<small>$LB->{no}";
            }
         }

         my $act = $action || "N";
         if ($sev >= 0) {
             $sev = $sev;
         } elsif ($avail == 1) {
             $sev = 0;
         } elsif ($avail == 0) {
             $sev = 2; $act = "Y"
         }
         $act = $act eq "Y" ? "<b>$LB->{yes}":"<small>$LB->{no}";
         my $dev0 = $device if ($device ne $last_dev);
         $last_dev = $device;
         my $tag0 = $tag_name if ($tag_name ne $last_tag);
         $last_tag = $tag_name;
         $out .= "<tr><td></td>" if ($tag0 && !$dev0);
         $out .= "<tr><td><center>$dev0</td>
                   <td align=right>&nbsp;<b>$tag0</td>
                   <td>&nbsp;$tag_value&nbsp;".  "$tag_value2</td>".
                  "$SEV[$sev]</td><td><center>$act</td>"
                   ;
      }
  }
  print "$out</table>";
            

}

1;
