package Health::Message;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Message.pm,v 1.29 2003/04/28 22:49:10 ccadieux Exp $


use base 'Health';
use Ilist;
use Message;
use Report;
use Catalog;
use Events;
use strict;
use Debug;

sub revision {'$Revision: 1.29 $'}

sub new {
  my($hm, $pdm) = @_;

  my($self) = {pdm => $pdm};
  bless ($self, 'Health::Message');

# Registers for A5K/ T3 message Reports.
#
#                            HM  Callback,  Filters
  $pdm->reportRequest($self, 'all_logic' , {category => Report::CAT_MESSAGE});
  $pdm->reportRequest($self, 'all_logic' , {category => Report::CAT_T3MESSAGE});
  $pdm->reportRequest($self, 'all_logic' , {category => Report::CAT_3310MESSAGE});
  $pdm->reportRequest($self, 'all_logic' , {category => Report::CAT_3510MESSAGE});
  return $self;
}

#####################################################


sub all_logic {
  my($hm, $report) = @_;
  my($pdm) = $hm->{pdm};

  my $hostid   =  $report->deviceName(); 
  my($log)     = $report->log();
  my($logErr)  = $report->logError();
  my $rep      = $report->content();
  my $renv     = System->get_renv();
  my $Config   = PDM::ConfigFile->read();
  my($id)      = $report->id('display');
  $DB::single = 1;

# $log->[2]{key}{name}
# $log->[2]{key}{line}

  my($id_ip, $id_cat, $id_dev, $id_disp) = ($report->{_value}{'id.ipno'},
                                            $report->{_id}{category},
                                            $report->{_id}{deviceName},
                                            $report->{_id}{display});
  if ($log) {  # so far, just t3/t4 messages;
    foreach my $sev (0, 1,2) {
      my $el = $log->[$sev];
      foreach my $target (keys %$el) {
         my $text   = $el->{$target}{line};
         my $disp   = $el->{$target}{name};
         my $count  = $el->{$target}{count};
         my $ip     = $el->{$target}{ip};
         my $egrid  = $el->{$target}{egrid};
         my $action = $el->{$target}{action};
         my $label  = $sev == 1 ? "array_warning" : ($sev == 2 ? "array_error": "array_notice");
         my ($t1, $wwn, $comp) = split(/\:/, $target); # caption may say PATH
         my $caption = "M.$comp" if ($comp);
         $report->{_value}{'id.ipno'} = $ip;
         $report->{_id}{category}  = $t1;
         $report->{_id}{deviceName}= $target =~ /HOST/ ? $renv->{hostname} : $wwn;
         $report->{_id}{display}   = $disp;
         my $ix = index($text, "\n");
         my $extra = $ix > 0 ? substr($text,0,$ix) : substr($text,0,60);
         $report->{_value}{"id.mgmtLevel"} = $renv->{solution} =~ /^se/ ? "C" : "D"; # BUG
         my $problo;
         my $lf = "logfile " . $report->id("logFile");
         if ($target =~ /HOST/) {
           $report->{_id}{deviceName}= $renv->{hostname};
           $report->{_id}{category}  = "host";
           $report->{_id}{display}   = "";

           Grid->setCode("host.LogEvent.$label");
           $hm->logEvent($text, $report, $hostid, 
             "$count ${label}(s) found in $lf on $id: $extra:", $sev, $label, 
                  {actionable => $action} );

         } else {
           $report->{_id}{deviceName} = $wwn;
           $problo = &problem($t1, $wwn, $Config);
           # EGRID t3.LogEvent.t3_warning;
           # EGRID t3.LogEvent.t3_error;
           Grid->setCode("$t1.LogEvent.$egrid");
           $hm->logEvent($text, $report, $wwn, 
                         "$count ${label}(s) found in $lf $problo: $extra:",
                       $sev, $caption || $label, 
                         { component => $comp, actionable => $action });
         }
         $report->{_value}{'id.ipno'} = $id_ip;
         $report->{_id}{category}     = $id_cat;
         $report->{_id}{deviceName}   = $id_dev;
         $report->{_id}{display}      = $id_disp;
      }
    }
  }

  my $cnt;
  my $sev = 0;  # 0,1,2 => NOTICE, WARN, ERR
  foreach my $el ('notices', 'warnings', 'errors') {
    if (exists($rep->{$el})) {
      my $WARN = $rep->{$el};
      foreach my $cat0 (keys %$WARN) {
        my($type, $enc, $cat) = split(/\:/, $cat0); # t3:key:mess_cat  or  DRIVER::mess_cat
        my $target;
        if (!$enc) {
           $enc = $hostid;
           $report->{_id}{category} = "host";
           Grid->setCode("host.LogEvent.driver.$cat");
        } else {
           $target = &problem($type, $enc, $Config);
           $report->{_id}{category} = $type;
           $report->{_id}{deviceName}= $enc;
           Grid->setCode("$type.LogEvent.driver.$cat");
        }
  
        my $data = $WARN->{$cat0};
        $cnt = 0;
        $data =~ s/\n/$cnt++/eg;
        my $data = $WARN->{$cat0};
        my $lf = "logfile " . $report->id("logFile");
        # EGRID host.LogEvent.driver.SSD_WARN
        # EGRID a5k.LogEvent.driver.SSD_WARN
        # EGRID t3.LogEvent.driver.SSD_WARN
     
        if ($cnt == 1) {
           $data =~ s/\tWWN:\t/ /;
           $data =~ s/\t/, /g;
           $hm->logEvent("", $report, $enc, 
                "Found in $lf on $id $target: $data", $sev, "driver.$cat");
        } else {
           $hm->logEvent($data, $report, $enc, 
               "Found $cnt 'driver.$cat' ${el}(s) in $lf on $id $target:", $sev, "driver.$cat");
        }
      }
    }
    $sev++;
  }
  $report->{_value}{'id.ipno'} = $id_ip;
  $report->{_id}{category}     = $id_cat;
  $report->{_id}{deviceName}   = $id_dev;
  $report->{_id}{display}      = $id_disp;
}

sub problem {
   my($type, $enc, $Config) = @_;
   my $d1 = $Config->deviceByKey($enc);
   if ($d1) {
     return "(indicating problem with $type $d1->{name}/$d1->{ipno})";
   } else {
     return "(indicating problem with $type:$enc)";
   }
}
1;
