package Health::TAPE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: TAPE.pm,v 1.13 2003/02/11 23:27:53 ccadieux Exp $


use base 'Health';
use NWS::TAPE;
use Ilist;
use Message;
use Catalog;
use Report;
use Events;
use strict;
use Debug;
sub revision {'$Revision: 1.13 $'}


sub new {
  my($hm, $pdm) = @_;

  my($self) = {pdm => $pdm};
  bless ($self, 'Health::TAPE');

# Specify each callback
#                            HM  Callback,  Filters
  $pdm->reportRequest($self, 'all_logic' , {category => Report::CAT_TAPE});
  return $self;
}

#####################################################


sub all_logic {
  my($hm, $report) = @_;
  my($pdm) = $hm->{pdm};
  my($ev, $ed, $pertains, $x ,$y, $contain, $sd);
  my($orep, $comp);
  $DB::single = 1;
  my($rep)     = $report->content;
  my($oreport) = PDM->getOldReport($report->fileKey);
  my $wwn      = $rep->{'id.wwn'};

  my($log)     = $report->log();
  my($id)      = $report->id("display");
  CIM->version("1.1");

  return if ( $hm->connectionEvent($wwn, $report, {method => 1} )); # return if cannot_connect

  my $freq  = System->get_renv()->{audit_freq} || 7;
  my $audit = System->get_audit() ? "YES" : Timer->isXdays("Audit$wwn", $freq);

  if (!$oreport || $audit eq "YES" ) {  # new t300 or audit time.
     my($etype) = $audit eq "YES" ? "tape.AuditEvent" : "tape.DiscoveryEvent";
     my($title) = $audit eq "YES" ? "Auditing a":"Discovered a new";
     my($dt)    = "A" if (!$audit);
     Grid->setCode($etype);

     $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => $etype ],
                  [ Target      => "tape:$wwn"   ],
                  [ TargetName  => $id    ],
                  [ EventId     => $pdm->getEventSequence  ],
                  [ Description => "$title TAPE called $id"],
                         ]);

     $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
      
     my($p) = NWS::TAPE->newSystem($rep);

     $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $p->[0] ],
                  [ DiscoveryType => $dt],
                    ]);

     my($monitors) = CIM::Instance->new('NWS_AgentMonitors', [
                  [ Agent       => $sd->[0]  ],
                  [ Element     => $p->[0] ],
                    ]);
#

     $ed = Message->new( { id        => $report->id,
                            instances => [$ev, @$sd, @$p, $monitors, $pertains ],
                            severity  => Message::SEVERITY_NORMAL });

     $pdm->saveMessage($ed);
  }
  $orep = ($oreport)? $oreport->content() : $rep; # same report if new disco.

  $hm->locationChangeEvent($report, $rep, $orep, $wwn);
  my($physicalFrame) = CIM::Key->new( ['CIM_PhysicalFrame', # frame key 
                       Tag               => $wwn,
                       CreationClassName => 'CIM_PhysicalFrame' ]);

  my($j);
  my($s1, $s2);
  $comp = "port.A";
  Grid->setCode("tape.StateChangeEvent.port");
  $hm->stateEvent($comp, $report, $rep, $orep, 'CIM_Card', $comp, $wwn);
         

}


sub status {
   my($hm, $rep, $orep, $comp) = @_;
   my($pdm) = $hm->{pdm};
   my($map) = $pdm->getDeviceStateMap("tape.availability");
   my($state, $ostate, $status, $ostatus, $old, $new, $sev, $act);

   $status  = $rep->getState("$comp.status");
   $ostatus = $orep->getState("$comp.status");

   ($old, $new, $sev, $act) = $map->transition("status.$ostatus", "status.$status", $orep, $rep);

   return ($ostatus, $status, $old, $new, $sev, $act);
}



1;
