package Provider::SunMC; 
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: SunMC.pm,v 1.4 2003/03/28 21:59:56 ccadieux Exp $

use PDM;
use Carp;
use Message;
use SAF;
use Util;
use strict;
use Catalog;
use Util::Http;
use Provider::SRS;
use base 'Provider::SRS';

use base 'Provider';
sub revision {'$Revision: 1.4 $'}
sub description {"SunMC"}
sub id          {"sunmc"}
sub url         {":18055"}
sub saf         {0}

sub new {
  my($self, $pdm)  = @_;

  my($p) = { pdm => $pdm };

  bless($p,'Provider::SunMC');
  return $p;
}

#SAN-T3
#SAN-Switch
#SAN-VE                 (instead of Vicom)
#SAN-Storage
#SAN-SE-Series


sub UPDATE {
  my($class, $q) = @_;
  my($active, $ip, $proxy, $to, $err, $name, $nat, $info, $ip2);
  my($renv, $dev, $host,$notifs, $o);
   my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('Provider')->section('sunmc');

  if ($q->{ACTION_update}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    unlink System->get_home() . "/DATA/last_sunmc_topo";
    $renv->{'pro.sunmc.active'} = $q->{active}? "Y":"N";
    $renv->{'pro.sunmc.ip'}     = $q->{ip};
    $renv->{'pro.sunmc.frequency'}     = ($q->{freq} +0) || 6;
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);

    $err = Html->info($L->{err_1}); 
  }

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

  if ($renv->{'pro.sunmc.active'} eq "Y") {
    $active = "checked" ;
  } else {
    $info = "<font color=red><b>$G->{inactive}</b>";
  }

  $ip      = $renv->{'pro.sunmc.ip'};
  $nat     = $renv->{'pro.sunmc.nat'};
  my $freq = $renv->{'pro.sunmc.frequency'};
  $ip      = Util->name2ip() if (!$ip);

 $o =<<EOF;
$err
<form  method=get>
 <input type=hidden name=GO value=GUI::Providers::display>
 <input type=hidden name=option value=$q->{option}>
<center>
<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr>
<td colspan=2 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{label}</td>

<tr><td bgcolor=$Style::LIGHT align=right>$G->{active}:</td>
      <td><input type=checkbox name=active $active> $info

<tr><td bgcolor=$Style::LIGHT align=right>$G->{ip}:</td>
      <td><input type=text name=ip value=\"$ip\" size=40>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{heartbeat}:</td>
      <td><input type=text name=freq value=\"$freq\" size=2 maxlength=2>
</table>
</table>
<b>
EOF
  if (!$deny) {
     $o .= "<input type=submit name=ACTION_update value=$G->{submit_update}>";
  }
  $o .= "</form>";
  return $o;

}


  
1;
