package Solution;

use System;
use strict;
use vars qw(%EX);

#
# device types that are not part of these rack-types.
#
%EX = ( se  => "", 
        se2 => ",3310,3510," 
      );


sub getId {
  my($class) = @_;
  my $id;
  my $renv = System->get_renv();

  if ($renv->{solution_model}) {
    $id =  $renv->{solution_model} . "." . Util->name2ip();
  }
  return $id;
}

sub exclude {
  my($class, $sol_type, $type) = @_;

  if (index($EX{$sol_type}, lc($type)) >= 0) {
     return 1;
  }
  return 0;
}

1;

