package Agent::6120;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: 6120.pm,v 1.24 2003/03/27 01:35:11 ccadieux Exp $

use Catalog;
use strict;
use State;
use Report;
use Agent;
use Agent::T3;
use Data::Dumper;
use base 'Agent::T3';


sub isSelectable { "Sun 6120"}
sub revision     { '$Revision: 1.24 $'}
sub type         { Report::CAT_6120 }
sub diskTotal    { 14   }

# do not remove this comment
# Report::CAT_T3MESSAGE

use vars qw(%N2IP $ERR);

sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::6120');
  return $self;
}



# ;u1ctr,fruCtlrPartnerId,u2ctr;

sub INSTRUMENTATION {
  my($agent, $device) = @_;
  my( $mode, $connect_err, $stats, $config, $config_errors);
  my($l, $config2, $config_rep, $stats_rep);
  my($sysprop, $elemprop0, $elemprop1, $key , $portWWN, $port2WWN, $slices, $luns, $vols, $volprop);
  my($fc);
  $DB::single = 1;

  my $renv    = System->get_renv();
  my $ping_to = $renv->{'timeout.ping'} || 10;
  my $http_to = $renv->{'timeout.http'} || 60;

  if (!Util->testIp($device->{ip},$ping_to)) {
     $config_rep->{"rc.error"} = "Ping: Ping failed on $device->{ip}/$device->{name} (to=$ping_to)";
     $config_rep->{"rc.key"} =   $device->{key};
     return $config_rep;
  }
  $elemprop0 = $agent->getTokens($device->{ip}, 0, $http_to, "ELEMPROP");
  $sysprop   = $agent->getTokens($device->{ip}, 0, $http_to, "SYSPROP");
  $slices    = $agent->getTokens($device->{ip}, 0, $http_to, "slice");
  $vols      = $agent->getTokens($device->{ip}, 0, $http_to, "vol");
  $volprop   = $agent->getTokens($device->{ip}, 0, $http_to, "volprop");
  $luns      = $agent->getTokens($device->{ip}, 0, $http_to, "lun");
  $fc        = $agent->getTokens($device->{ip}, 0, $http_to, "linkstat");
  my $volperf   = $agent->getTokens($device->{ip}, 0, $http_to, "volperf");

  if ($elemprop0) {
     ($portWWN, $port2WWN, $key, $config_rep) = $agent->parse_elem($elemprop0, $device);

     $config_rep->{"id.timestamp"} = time;
     $agent->parse_slice($config_rep, $slices);
     $agent->parse_vol($config_rep,   $vols);
     $agent->parse_vol($config_rep,   $volprop);
     $agent->parse_lun($config_rep,   $luns);
     $agent->parse_sys($config_rep, $sysprop);
     $agent->parse_fc($config_rep,  $fc);
     $agent->generic_parse($config_rep,  $volperf, "volume", "Flushes");
     $agent->volVerify($config_rep, $device);  

  } else {
     $config_rep->{"rc.error"} = "Tokens: No tokens returned from $device->{ip}/$device->{name}";
     $config_rep->{"rc.key"} =   $device->{key};
     return $config_rep;
  }
  $config_rep->{"rc.error"}       = $connect_err;
  $config_rep->{"rc.key"}         = $key;
  $config_rep->{"rc.portWWN"}     = $portWWN;
  $config_rep->{"rc.port2WWN"}    = $port2WWN;
  return $config_rep;
}




    # call tokens.
    # parse and write in this format $r
    # ;unitId0lnkstatIndex2Ctrl1;
    # ;unitId0lnkstatIndex2Ctrl1Loop2;
    # ???      = ;unitId0lnkstatIndex2Ctrl1Loop2;SimErr;0;
    # linkfail = ;unitId0lnkstatIndex2Ctrl1Loop2;FailCnt;0; 
    # sync     = ;unitId0lnkstatIndex2Ctrl1Loop2;LossSyncCnt;3; 
    # link/signal = ;unitId0lnkstatIndex2Ctrl1Loop2;LossSignalCnt;3; 
    # seq      = ;unitId0lnkstatIndex2Ctrl1Loop2;ProtoErrCnt;0; 
    # word     = ;unitId0lnkstatIndex2Ctrl1Loop2;InvTxWord;0; 
    # crc      = ;unitId0lnkstatIndex2Ctrl1Loop2;InvCRCCnt;0; 
    # ORDER : link, signal, seq, crc, sync, word


sub FCCounters {
  my($class ,$arg) = @_;
  my (%X, $x);
  my $report = {};
  my($renv, $devs, $host,$notifs) = PDM::ConfigFile->read;
  my $to = $renv->{'timeout.http'} || 60;
  
  foreach my $d (@$devs) {
    next if ($d->{type} ne "6120");
    next if ($d->{active} eq "N");
    next if (!$d->isMineToMonitor());

    my $fc = $class->getTokens($d->{ipno}, 0,  $to, "linkstat");
    $class->parse_fc($report, $fc);
    
    for ($x = 0; $x <= 1; $x++) {
      my $y = $x + 1;
      my $k   = "fc_stats.unit$x-ctrl$y-loop2";
      my $val =  $report->{"$k.FailCnt"}     . "\t" .
               $report->{"$k.LossSignalCnt"}."\t" .
               $report->{"$k.ProtoErrCnt"} . "\t" .
               $report->{"$k.InvCRCCnt"}   . "\t" .
               $report->{"$k.LossSyncCnt"} . "\t" .
               $report->{"$k.InvTxWord"} ;

      $X{"0|$d->{key}|port.$x|6120"} = $val;
    }
  }
  return {data => \%X, hba => {}} ;
}

sub parse_fc {
  my($class, $report, $fc) = @_;

  foreach my $el (@$fc) {
      if ($el =~ /unitId(\d+)lnkstatIndex(\d+)Ctrl(\d+)Loop(\d+)/) {
         my $unit  = $1;
         my $index = $2;
         my $ctrl  = $3;
         my $loop  = $4;
         $el= Util->trim($el);
         my($name, $comp, $val) = split(/\,/, substr($el,1,-1));
         next if (!$comp);
         $report->{"fc_stats.unit${unit}-ctrl${ctrl}-loop$loop.$comp"} = $val;
      }
  }
}

  
sub getTokens {
  my($class, $ip, $unit, $to, $page) = @_;
  my $out;
  if ($page eq "ELEMPROP") {
    foreach my $file ('frudata','fruprop','portprop') {
      $out .= Util::Http->get("http://guest\@$ip/$file.htm", $to);
      return undef if (length($out) < 10);
    }
  } elsif ($page eq "SYSPROP") {
    foreach my $file ('sysdata','system','sysprop') {
      $out .= Util::Http->get("http://guest\@$ip/$file.htm", $to);
    }

  } else {
    $out = Util::Http->get(
              "http://guest\@$ip/$page.htm?unitIndex=$unit",$to);
  }
  return undef if (length($out) < 10);
  my @x = split(/\n/, $out);
  return \@x;
}


sub NUgetAllFiles {
  my ($agent, $name, $other)=@_;
  my @URLS;
  my @FILES =
    (
    "frudata.htm",
    "fruprop.htm",
    "portprop.htm",
    "sysdata.htm",
    "system.htm",
    "sysprop.htm",
    "slice.htm",
    "lun.htm",

    "htmltoc",
    "log.htm",
    "monitor.htm",
    "ntp.htm",
    "portperf.htm",
    "resource.list",
    "schedule.htm",
    "source.list",
    "syscount.htm",
    "sysdate.htm",
    "sysoper.htm",
    "sysperf.htm",
    "timeprop.htm",
    "vol.htm",
    "volperf.htm",
    "volprop.htm",
  );
  return \@FILES;
}

1;
