package Agent::9900;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#172.20.104.65

use strict;
use Agent;
use base 'Agent';
use Util;

sub isSelectable {"Sun 9900"}

sub revision {'$Revision: 1.6 $'}
sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::9900');
  return $self;
}
use vars qw($ERR);

sub RUN {
  my($agent, $ras_flag) = @_;
  my $dc;

  my($renv) = System->get_renv();
  $DB::single = 1;
  Timelapse->start(ref($agent));

  foreach my $dev ( $agent->deviceList() ) {
     next if ($dev->{active} eq "N");
     $dc++;  
     my $sys_report = $agent->INSTRUMENTATION($dev);
     my $wwn = $dev->{key};
     my $connect_errs = $sys_report->{"rc.error"};

     my($id) = {
                deviceName=> $wwn,
                active    => $dev->{active},
                class     => "storage.9900",
                name      => $dev->{name},
                display   => "$dev->{name}/$dev->{ipno}",
                category  => Report::CAT_9900,
                ip        => $dev->{ipno},
               };

     $sys_report = {} if (!$sys_report);
     $agent->copyDev($dev, $sys_report);
     my $new_rep;

     if ($connect_errs) {   
       $new_rep = Report->new($id, $sys_report,undef, Report::STATUS_CANNOT_CONNECT );
     } else {
       $sys_report->{'id.name'}     = $dev->{name};
       $sys_report->{"id.mgmtLevel"}= $dev->{mgmtLevel};
       $sys_report->{"id.ip"}       = $dev->{ip};
       $sys_report->{"id.ipno"}     = $dev->{ipno};
       $sys_report->{"id.wwn"}      = $dev->{key};
       $new_rep = Report->new($id, $sys_report);

     }
     PDM->saveReport($new_rep);
  }

  Debug->print2("  No devices found") if (!$dc);
  Timelapse->stop(ref($agent));
}

sub getWWN {
  my($agent, $ip) = @_;

  my($DIR)   = System->get_home() . "/snmp/bin";
  my($renv)  = System->get_renv();
  my($TO)    = $renv->{'timeout.snmp'} + 20;

  my($MIBS)  = System->get_home() . "/snmp/mibs";
  $ENV{LD_LIBRARY_PATH} = System->get_home() . "/bin/lib";
  my($OPT)   = "-r 1 -t $TO -m all -Os ";

  my $com = "$DIR/snmpwalk $OPT $ip public enterprises.116.5.11.4.1.1.5";
  my($err0,$O) = Util->run_command($com, "9900.txt", $TO+5);

  my $rc = {};
  my $key;
  foreach my $x (@$O) {
     my(@a) = split(/ +\= */, $x);
     $a[1] = substr($a[1],1,-1) if (substr($a[1],0,1) eq "\"");
     if ($a[0] =~ /raidlistMibNickName/) {
         $rc->{name} = $a[1];
     } elsif ($a[0] =~ /raidlistSerialNumber/) {
         $key = $a[1];
     }
  }
  return undef if (!$key);
  $rc->{ip}   = $ip;
  $rc->{ipno} = $ip;
  $rc->{type} = "9900";
  $rc->{key}  = "$rc->{type}-$key";
  $rc->{wwn}  = $rc->{key};
  return $rc;
  
}


  


sub INSTRUMENTATION {
  my($agent, $device) = @_;
  my(@s, %dev, $in, %info);
  my(%R);

  my($ip)    = $device->{ip};
  my(@counts, @stats, $stat, $x);
  my($DIR)   = System->get_home() . "/snmp/bin";
  my($renv)  = System->get_renv();
  my($TO)    = $renv->{'timeout.snmp'} + 20;

  my($MIBS)  = System->get_home() . "/snmp/mibs";
  $ENV{LD_LIBRARY_PATH} = System->get_home() . "/bin/lib";
  my($OPT)   = "-r 1 -t $TO -m all -Os ";

  my($err0,$system) = Util->run_command(
           "$DIR/snmpwalk $OPT $ip public system", "9900.txt", $TO+5);

  if ($err0) {
     $R{'rc.error'} = $err0;
     return \%R;
  }

  my($err3,$enterprise) = Util->run_command(
            "$DIR/snmpwalk $OPT $ip public enterprises.116", "9900.txt", $TO +5);

  foreach my $x (@$system) {
     my(@a) = split(/ +\= */, $x);
     $a[1] = substr($a[1],1,-1) if (substr($a[1],0,1) eq "\"");
     $a[0] = substr($a[0],0,-2) if (substr($a[0], -2) eq ".0");
     $R{"system.$a[0]"} = $a[1];
  }

  my($t, $key) = split(/\-/, $device->{key});

  my %MAP = (SM => "Shared Memory", PS => "Power Supply", CSW => "Internal Bus");

  foreach my $x (@$enterprise) {
     my(@a) = split(/ +\= */, $x);
     $a[1] = substr($a[1],1,-1) if (substr($a[1],0,1) eq "\"");
     next if ($a[0] !~ /\.$key$/ && substr($a[0],-2) ne ".0");

     $a[0] = substr($a[0],0,-2) if (substr($a[0], -2) eq ".0");
     $a[0] =~ s/\.$key$//;

     if ($a[0] =~ /^raidExMib/) {
        if ($a[0] !~ /MibVersionManagement/) {
          $R{"info." . substr($a[0],9)} =  $a[1];
        }

     } elsif ($a[0] =~ /^raidlist/) {
        $R{"raid." . substr($a[0],8)} = $a[1];

     } elsif ($a[0] =~ /^dkcHW/) {
        my $vv = $a[1];
        $vv =~ s/\(\d+\)$//;
        $R{"controller." . substr($a[0],5)} = $vv;
     
     } elsif ($a[0] =~ /^dkuHW/) {
        my $vv = $a[1];
        $vv =~ s/\(\d+\)$//;
        $R{"disk." . substr($a[0],5)} = $vv;
     }
  }

  $agent->addIdentification(\%R);
  $R{'rc.key'} = $R{"id.wwn"};

  return \%R;
}


sub FRUS {
  my($class, $r, $name) = @_;
  my($v) = $r->{_value};
  my $devtype = $r->category();
  my $model = $v->{"system.sysDescr"};
  my @FRUS;
  my $st0 = $v->{"swSystem.swAdmStatus"};
  my $st1 = $v->{"swSystem.swOperStatus"};
  $st0 =~ s/\(\d+\)//;
  $st1 =~ s/\(\d+\)//;

  my $rev = $v->{"swSystem.swFirmwareVersion"};
  my $type = lc($v->{"id.device_userLabel"});

  push(@FRUS, [$name, "storage", "9900", $type, "9900", $model, " N/A", $rev, "$st0-$st1"]);
  return \@FRUS;

}



sub REPORT {
  my($class, $host, $r, $arg) = @_;

  my($out);
  my($v) = $r->{_value};

  my $last;
  $out = $class->reportHead("9900", $r);
  my $pow = $v->{"controller.PS"} . " / " . $v->{"disk.PS"};
  $pow =~ s/\(\d\)//g;
  my $fan = $v->{"controller.Fan"} . " / " . $v->{"disk.Fan"};
  $fan =~ s/\(\d\)//g;

  $out .=<<EOF;
<tr><td bgcolor=$Style::LIGHT align=right>Name:</td> <td>&nbsp;$v->{'id.device_name'}</td>
         <td bgcolor=$Style::LIGHT align=right>IP:</td>   <td>&nbsp;$v->{'id.device_ip'}</td>
     <tr><td bgcolor=$Style::LIGHT align=right>Product:</td> <td>&nbsp;$v->{'info.Name'}</td>
         <td bgcolor=$Style::LIGHT align=right>Serial#:</td>   <td>&nbsp;$v->{'id.wwn'}</td>
     <tr><td bgcolor=$Style::LIGHT align=right>Power:</td> <td>&nbsp;$pow</td>
         <td bgcolor=$Style::LIGHT align=right>Fan:</td>   <td>&nbsp;$fan</td>
     </table>
EOF
  my %V;
  my %MAP = (SM => "Shared Memory", PS => "Power Supply", CSW => "Internal Bus");
              
  foreach my $e (keys %$v) {
     my ($u1, $rest) = split(/\./, $e, 2);
     my $val = $v->{$e};
     $val =~ s/\(\d+\)//;
     my $name = $MAP{$rest} || $rest;
     $V{$u1} .= "<tr><td width=40% align=right bgcolor=$Style::LIGHT>" . 
                $name . ":</td><td>&nbsp;$val</td>";
  }
  foreach my $e ('raid', 'controller','disk', 'info', 'system') {
     $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
       <tr><td colspan=2 bgcolor=$Style::DARK><font color=white>&nbsp;<b>" . uc($e) . "</td>";
     $out .= $V{$e}; 
     $out .= "</table>";
  }  
  $out .= "&nbsp;<p>&nbsp;<p>";
  return $out;


}


1;
