package GUI::Navigation;
use Html;
use System;
use Navigation;
use GUI::Welcome;
use strict "vars";



sub index {
  my($q) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  #print Http->text_header("Set-Cookie: RAS_LANG=" . $ruser->{language}. "; path=/;");
  my $window = $ruser->{window} || $renv->{window};
  my $lang = $ruser->{language} || $renv->{language} || "en";
  print Html->text_header();

  if ($window eq "N") { # no top frame
     if ($q->{MENU}) {
       if (substr($q->{MENU},0,1) eq ">") {
          $q->{MENU} = substr($q->{MENU},1);
          #Navigation::nf_top($q);
          &welcome($q);
       } else {
          eval {
            Http->runFunction($q->{MENU}, $q);
          };
          if ($@) {
             print "Execution error: $@<br>\n";
          }
       }
     } else {
       #Navigation::nf_top($q);
       GUI::Welcome::welcome($q);  # welcome is default
     }
     return;
  #} elsif ($ENV{HTTPS} || $Http::httpua !~ /la\/4.7/ || $lang ne "en" ) {  # 7 no javascript on top frame
  } else {
     if ($q->{MENU}) {
       if (substr($q->{MENU},0,1) eq ">") {
          $q->{MENU} = substr($q->{MENU},1);
       }
       $q->{FRAME} = 1;

       Navigation::nf_top($q);
     } else {
       my $nav = Navigation->read();
       my $in = $nav->{ROOT}{info};
       my $welc = $in->{frame2} || "GUI::Welcome::welcome";

       print <<EOF;
       <header><title>$in->{desc}</title></header>
       <frameset rows=$Style::TOP_FRAME_HEIGHT,* border=0>
         <frame src=$Http::WEBPROC?GO=GUI::Navigation::index&MENU=X name=top scrolling=no>
         <frame src=$Http::WEBPROC?GO=$welc name=bottom scrolling=auto>
       </frameset>
EOF
     }
     return;

  }

}

sub top {
  my($q) = @_;
  print "\n";
  Navigation::nf_top($q);

}

sub clean_url {
  my($url) = @_;
  my $new;
  if (substr($url,0,1) eq "/") {
     $new = $url;
  } elsif (substr($url,0,1) eq ">") {
     $new = "$Http::WEBPROC?GO=GUI::Navigation::frame&MENU=" . substr($url,1);
  } else {
     $new = "$Http::WEBPROC?GO=$url";
  }
  return $new;
}

# Navigation::file&FILE=/help.html&MENU=help

sub file {
  my($q) = @_;

  my $file = $q->{FILE};

  print Html->body();
  print Html->header2("$q->{MENU}");

  Html->readHtdocs($file, undef, "PRINT");
}

sub doc {
  my($q) = @_;
  my $file = $q->{FILE};

  print Html->body();
  print Html->header2("$q->{MENU}");
  if ($q->{DOC}) {
    Html->readHtdocs("${file}_doc", undef, "PRINT");
  } else {
    Html->readHtdocs($file, undef, "PRINT");
  }
}


sub ReleaseNotes {
  my($q) = @_;
  print Html->body();
  print Html->header2("help_sys.release_notes");

  my($out, $l);
  opendir(DIR, System->get_home() . "/docs");
  my @files = readdir(DIR);
  closedir(DIR);
  my $list = "Select other file: ";
  my ($cnt, $first);
  foreach my $f (@files) {
    if ($f =~ /^ReleaseNotes/) {
       $first = $f if (!$first);
       $list .= "<a href=$Http::WEBPROC?GO=GUI::Navigation::ReleaseNotes&file=$f>$f</a> | ";
    }
  }
  if ($list) {
     chop($list); chop($list);
  }
  my $f1 = $q->{file} || $first;
  my $f2 =  System->get_home() . "/docs/$f1";
  print $list;
  open(O, $f2);
  while ($l = <O>) {
    last if ($l =~ /MEDIA CONTENTS/);
    $out .= $l;
  }
  close(O);
  print "</center>\n<pre><b>File: $f1</b>\n$out";
}


# LEFT/RIGHT FRAME if needed

sub frame {
  my($q) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $window = $ruser->{window} || $renv->{window};
  print Html->text_header();
  
  if ($window ne "N") { # window eq B/S/N
     print <<EOF;
<frameset cols=$Style::LEFT_FRAME_WIDTH,* border=0>
    <frame src=$Http::WEBPROC?GO=GUI::Navigation::left_menu&MENU=$q->{MENU} name=main scrolling=auto>
    <frame src=$Http::WEBPROC?GO=GUI::Navigation::welcome&MENU=$q->{MENU} name=detail scrolling=auto>
</frameset>
EOF
  } else {
    GUI::Navigation::welcome($q);
  }
}

# LEFT MENU 

sub left_menu {
  my($q) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $nav = Navigation->read();
  my $style = $nav->{ROOT}{info}{style};
  my $js;
  my $cnt = 1;
  print Html->text_header();
  print "\n\n$style";
  my $ext = $Style::LEFT_GIF_EXT;

  if (exists $nav->{$q->{MENU}}) {
    my $nav1 = $nav->{$q->{MENU}};
    my $head = &menu_head( $nav1->{info}{title});
    my $out = "<table border=0 cellpadding=0 cellspacing=1 width=100%>";
    my @O = split(/,/, $nav1->{order});
    foreach my $el (@O) {
        my $item = $nav1->{items}{$el};
        next if ($item->{skip} && index($item->{skip}, "m") >= 0);

        my($url, $out0, $targ) = &read_url($item);
        $out .= $out0;
        my $target = $item->{target} || "detail";
        my $t = $out0 ? "" : ($targ || "target=$target");

        my $act = Navigation::active($item, $ruser, $renv);
        my $title = $item->{short} || $item->{title};
        if (($act == 2 || $act == 1) && $item->{separator}) {
           $out .= "<tr><td colspan=2>$item->{separator}</td>";
        }
        if ($act == 2) {
           $out .= "<tr><td valign=middle><img name=b$cnt src=gif/bout$ext.gif width=9 height=9>" .
          "</td><td><a href=\"$url\" $t onmouseover=bover($cnt) " .
          "onmouseout=bout($cnt) onclick=bclick($cnt)>$title</a></td>\n";
           $out .= "<tr><td></td>";
           $out .= "<tr><td></td>";
        } elsif ($act == 1) {
           $out .= "<tr><td valign=top><font color=silver>&nbsp;-</td><td><font color=silver>$title</td>\n";
           $out .= "<tr><td></td>";
           $out .= "<tr><td></td>";
        }
        $cnt++;
    }
    print $head;
    print $out;
    print "</table>";
  } else {
    print "Cannot access $q->{MENU} in navigation file!";
  }
}


sub read_url {
  my($item) = @_;
  my ($url, $out);
  my $nav_url = $ENV{HTTPS} ? ($item->{secure_url} || $item->{url})  : $item->{url};

  my $target;
  if (substr($nav_url,0,7) eq "WINDOW ") {
     if ($nav_url =~ / https*\:\//) {
       $url = &trans(substr($nav_url,7));
       $target = "target=newwin";
     } else {
       $url = &clean_url(substr($nav_url,7));
       $out .= "<script>\nfunction win2(a) {\n" .
           "  var b = '$url'; \n"   .
           "  var O = window.open(b,'procW','$item->{window}');\n" .
           "  O.focus(); \n}</script>\n";
       $url = "javascript:win2()";
     }
   } else {
     if ($nav_url =~ /^https*\:\//) {
       $url = &trans($nav_url);
       $target = "target=_top";
     } else {
       $url = &clean_url($nav_url);
     }
   }
   return ($url, $out, $target);
}

sub trans {
  my($url) = @_;
  my $h = $Http::httphost;
  if (index($url, '$host$') >= 0) {
    $url =~ s/\$host\$/$h/;
  }
  if (index($url, '$se2_port$') >= 0) {
    # 9080 | 9443
    my $port = $ENV{HTTPS} ? 9443 : 9080;
    $url =~ s/\$se2_port\$/$port/;
  }
  return $url;
}


# RIGHT MENU

sub welcome {
  my($q, $TOPDONE) = @_;

  my $renv   = System->get_renv();
  my $ruser  = System->get_ruser();
  my $sysLb =  Labels->read();
  $TOPDONE = $q->{TOPDONE} if (exists $q->{TOPDONE} && !$TOPDONE);
  print Html->text_header();

  my $window = $ruser->{window} || $renv->{window};
  my $nav    = Navigation->read();
  my $style = $nav->{ROOT}{info}{style};
  my $ix     = index($q->{MENU}, ".");
  my $tab    = substr($q->{MENU}, 0, $ix);
  my $crumb;
  if (!$TOPDONE && $window eq 'N') {
     Navigation::nf_top($q);
  }

  if (exists $nav->{$tab}) {
    if ($window eq 'N') {
      $crumb = "<a href=$Http::WEBPROC?GO=GUI::Navigation::welcome&MENU=$tab>$nav->{$tab}{info}{title}</a> >";
    #} else {
    #  $crumb = "$nav->{$tab}{info}{title}.";
    }
  }
  if ($q->{MENU} ne 'ROOT') {
   if ($window eq 'N') {
     $crumb = "<a href=$Http::WEBPROC?GO=GUI::Navigation::welcome&MENU=ROOT>$nav->{ROOT}{info}{title}</a> > $crumb";
   } else {
     #$crumb = "$nav->{ROOT}{info}{title} > $crumb";
   }
  }

  if (exists $nav->{$q->{MENU}}) {
    my $nav1 = $nav->{$q->{MENU}};
    #my ($help, $u) = Html->help($nav1->{info}{help});
    my $help = "<script> function o_win(x){ var w=window.open('/?GO=GUI::Navigation::help&ROOT=$q->{MENU}','help','menubar=yes,scrollbars,resizable,width=600,height=700'); w.focus(); } </script> <a href=javascript:o_win()>$sysLb->{help}</a>";
    my $desc;
    if ($nav1->{info}{desc} ne $nav1->{info}{title}) {
       $desc = "<table border=0 width=90% cellpadding=5 bgcolor=white><tr><td>
                  $nav1->{info}{desc}</table>" ;
    } else {
       $desc = "<table border=0><tr><td></table>";
    }

    my $out =<<EOF;
     \n$style<body bgcolor="$Style::BGCOLOR" vlink=navy><center>
      <table border=0><tr><td></table>
      <table border=0 width=90% cellpadding=2>
      <tr><td><font color=black>$crumb <b>$nav1->{info}{title}</td>
          <td align=right>[ $help ]</table>
      $desc
      <table border=0 width=90% cellspacing=0 bgcolor=#F0F0F0><tr><td>
      <table border=0 width=100% cellspacing=2 cellpadding=4>
      <tr><td colspan=2 bgcolor=$Style::DARK><img src=/gif/dot_clear.gif height=5></td>
EOF
    my @O = split(/,/, $nav1->{order});
    foreach my $el (@O) {
        my $item = $nav1->{items}{$el};
        next if ($item->{skip} && index($item->{skip}, "w") >= 0);
        my $act = Navigation::active($item, $ruser, $renv);
        my($url, $out0) = &read_url($item);
        $out .= $out0;
        
        if ($act == 2) {
           my $targ = "target=$item->{target}" if ($item->{target});
           $out .= "<tr><td bgcolor=$Style::WELCOME_BG1 width=25% align=right>[ <a href=\"$url\" $targ>$item->{title}</a> ]</td>
          <td bgcolor=white>$item->{desc}</td>";
        } elsif ($act == 1) {
           $out .= "<tr><td bgcolor=$Style::WELCOME_BG1 width=25% align=right><font color=#404040>[ $item->{title} ]</td>
          <td bgcolor=white>$item->{desc}</td>";
        }
    }
    $out .= "</table></table>";
    print $out;
  } else {
    print "Cannot access $q->{MENU} in navigation file!";
  }

}

use vars qw($TITLE);

sub get_titles {
  my($lang) = @_;
  if (exists $TITLE->{$lang}) {
     return $TITLE->{$lang};
  }
  my $file = System->get_home() . "/Lang/htdocs/Help/$lang/titles.txt";
  if (!-f $file) {
    $file = System->get_home() . "/htdocs/Help/titles.txt";
  }
  my ($l);
  if (open(O, $file)) {
     while ($l = <O>) {
        chop($l);
        my @a = split(/\t/, $l);
        $TITLE->{$lang}{$a[0]} = $a[1];
     }
  }
  close(O);
  return $TITLE->{$lang};
}

sub help_loop { 
  my($q, $sp, $titles, $item, $el, $act) = @_;
  my ($out, $x);
  my $cnt = 0;
  my $title0 = $item->{title};

  my @helps = split(/,/, $item->{help});
  my $last = $q->{SUMMARY} ? 0 : $#helps;
  my $IN = "&INFRAME=1" if ($q->{INFRAME} || $q->{FRAME});
  $last = $#helps if ($#helps < $last);

  for ($x=0; $x <= $last; $x++) {
       my $help = $helps[$x];
       my ($t, $t2, $ind);
       if ($cnt == 0) {
         $t = $title0;
         $t2 = $item->{desc};
         $ind = "-";
       } else {
         $t2 = $t = $titles->{$help};
         $ind = "&nbsp;&nbsp;&nbsp;&nbsp;";
       }
       my ($c1, $c2);
       if ($act == 1) {
           $c1 ="<font color=gray>"; $c2 ="</font>";
       }
       my $found = 0;
       my $extra;
       if ($q->{search}) {
          my $file = &find_help_file($help);
          open(O1, $file); my @L = <O1>; close(O1);
          my $ss = "@L";
          $ss =~ s/$q->{search}/$found++/egi;
          $extra = " > $titles->{$help}" if ($x && $found);
       }
       if (!$q->{search} || $found) {
         my $sch = Util->encode($q->{search});
         my $target = "target=help_main" if ($q->{FRAME});
         my $url;
         if ($q->{DOC}) {
           if ((index($item->{skip}, "m") < 0 || $item->{doc})) {
             print $out; $out = "";
             print "\n<a name=\"$el\">&nbsp;<br><page node=\"$el\">\n" if (!$q->{SUMMARY});
             $q->{file} = $item->{help}; $q->{ROOT} = $el;
             my($out, $cnt, $last, $a2) = GUI::Navigation::help2_display($q); # display doc
             if ($x == 0) {
               &print_module($a2, $item); #  display browser page
             }
             print "$out</UL>";
             print "&nbsp;<p>&nbsp;<br>";
           }
           last if ($x == 0);
         } elsif ($q->{NOHREF}) {
           $url = "<a href=#$el>$c1$t$extra$c2</a>";
         } else {
           my $h1 = ($x == 0) ? $item->{help} : $help;
           $url = "<a href=\"$Http::WEBPROC?GO=GUI::Navigation::help2&file=$h1&ROOT=$el&search=$sch$IN\" $target>$c1$t$extra$c2</a>" . ($found? "&nbsp&nbsp;[$found]" : "");
         }
         if ($q->{FRAME}) {
           $out .= "<tr><td nowrap>$sp$ind$url</td>\n";
         } else {
           $out .= "<tr><td>$sp$ind$url</td><td>$t2&nbsp;</td>\n";
         }
         $cnt++;
       }
   }
   if ($#helps < 0 && $q->{DOC} && (index($el, ".") != rindex($el, ".")) ) {
      print "<font color=red>No help file available for this page: $el</font><br>\n";
   }
   return ($out, $cnt);
}

# DOC 
sub print_module {
  my($crumbs , $item) = @_;
  my $q = {};
  my $found = 0;
  my(@urls, $cnt);
  push(@urls, $item->{url}); 
  my @u = split(/,/, $item->{doc_url}); # more pages that should be displayed in the doc
  push(@urls, @u); 
  foreach my $url (@urls) {
    if (substr($url,0,1) ne "/") {
       $cnt++;
       my $ix = index($url, "&");
       if ($ix > 0) {
         Http::parse(substr($url, $ix+1), $q, 1);
         $url = substr($url, 0,$ix) ;
       }
       my $ix = rindex($url, "::");
       if ($ix > 0) {
          my $mod = substr($url, 0, $ix);
          $mod =~ s/\:\:/\//g;
          eval {
            require "$mod.pm";
          };
          if (!$@) {
             print STDERR "$mod\n";
             print "<table border=0 cellspacing=0 cellpadding=2 width=100%>$crumbs</td>
                    <tr><td></td>
                    <tr><td>
                    <table border=1 cellspacing=0 cellpadding=0 width=100%><tr><td>";
             $crumbs = "";
             my $f = $url;
             $q->{DOC} = 1;
             &$f($q);
             print "</table></table></b></center>";
             print "<table border=0 cellspacing=0 width=99%><tr><td align=right><small>[ $url ]</table>";
             $found = 1;
          }
       }
    }
  }
  if (!$found) {
     print "$crumbs";
  }
  return $found;
}

sub find_help_file {
  my($f) = @_;
  my $renv  = System->get_renv();
  my $ruser = System->get_ruser();
  my $lang  = $ruser->{language} || $renv->{language};
  my $file = System->get_home() . "/Lang/htdocs/Help/$lang/$f.html";
  if (!-f $file) {
     $file = System->get_home() . "/htdocs/Help/$f.html";
  }
  return $file;
}
 
sub help_header {
   "<table border=0 width=100% bgcolor=$Style::DARK cellpadding=2><tr><td><big><b><font color=white>&nbsp;Storage Automated Diagnostic Environment Help</table>";
}

sub help2 {
  my($q) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $lang = $ruser->{language} || $renv->{language};

  my $window = $ruser->{window} || $renv->{window};
  my $nav = Navigation->read();
  print Html->body(undef, {color => "#F0F0F0", margin => "vlink=navy"} );
  $q->{INFRAME} ||= $q->{WIN};
  if (!$q->{FRAME} && !$q->{INFRAME}) {
   print Html->header2("help_sys.help_page", undef, undef, undef, {noHeader => 1}) 
  } else {
   print &help_header();
  }

  my ($out, $cnt, $last, $a2) = &help2_display($q, $nav);

  if (!$cnt) {
    &help({ });
  } else {
    print "
    <table border=0 cellspacing=0><tr><td></table>
    <table border=0 cellspacing=0 cellpadding=0 width=100% bgcolor=white>$a2</table></center>";
    print  $out;
  }
}

sub help2_display {
  my($q, $nav) = @_;
  my ($l, $out, $cnt);
  $nav = Navigation->read() if (!$nav);

  my ($last, $a2) = &header_($q, $q->{ROOT}, $nav);

  my @F    = split(/,/, $q->{file});

  foreach my $f (@F) {
    my $file = &find_help_file($f);
    if (open(O, $file)) {
      my $cnt2 =0;
      while ($l = <O>) {
         if ($cnt2++ < 10 && $l =~ /^#include (.+)/) {
            open(O2, System->get_home() . "/htdocs/$1");
            my @LL = <O2>; close(O2);
            $out .= "@LL";
         } else {
           $l =~ s/<a name=\w+>//ig;
           $l =~ s/<a href/'<ahref/ig;
           $l =~ s/($q->{search})/<font color=red><u>$1<\/u><\/font>/ig if ($q->{search});
           $out .= $l;
         }
      }
      $out .= "<table border=0 cellspacing=0 width=99%><tr><td align=right><small>[ $q->{ROOT}:$q->{file} ]</table>";
      close(O);
      $cnt++;
    }
  }
  return ($out, $cnt, $last, $a2);
}

#  Navigation->help({ ROOT => "admin", SUMMARY => 1, FRAME=>1});
sub help {
  my($q) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $role = $ruser->{role};
  my $window = $ruser->{window} || $renv->{window};
  my $nav = Navigation->read();
  my $lang = $ruser->{language} || $renv->{language};
  my $F = System->get_home() . "/DATA/toc_$lang.html";

  print Html->body(undef, {color => "#F0F0F0", margin => "vlink=navy"} ) if (!$q->{NOHREF});
  $q->{INFRAME} ||= $q->{WIN};
  if (!$q->{FRAME} && !$q->{INFRAME}) {
    print Html->header2("help_sys.help_page", undef, undef, undef, {noHeader => 1});
  } elsif ($q->{FRAME}) {
    my ($b1,$b2, $b3, $b4);
    if ($q->{SUMMARY} == 1) {
       $b1 = "<b>"; $b3 = "</b>";
    } else {
       $b2 = "<b>"; $b4 = "</b>";
    }
    print "<table border=0 cellpadding=3 width=110% bgcolor=$Style::DARK>
    <tr><td align=right><font color=white>
    [ <a href=/?GO=GUI::Navigation::help&SUMMARY=0&FRAME=1><font color=white>${b2}Open$b4</font></a> | 
    <a href=/?GO=GUI::Navigation::help&SUMMARY=1&FRAME=1><font color=white>${b1}Close$b3</font></a> ]&nbsp;
    <tr><td></td>
    <tr><td></td>
    </table>
    ";
  } else {
    print &help_header();
  }
  my ($tab_list, $sub_tab);
  my $cnt = 0;
  my ($i, $out, $sub);
  my $toc;
  my $opt = $q->{NOHREF} ? "0 cellspacing=1" : "0 cellspacing=1";

  if ($q->{FRAME}) {
    $toc = "<table border=$opt width=110% cellpadding=2>";
  } else {
    $toc = "<table border=$opt width=95% bgcolor=white cellpadding=2>";
  }
  my $titles = &get_titles($lang);

  my($toc0,$cnt0) = &help_($titles, $ruser, $renv, $nav, $q->{ROOT} || "ROOT", 0, $q);
  $toc .= $toc0;
  $toc .= "</table>";
  print $toc;
  if (!$cnt0  && !$q->{NOHREF}) {
    print Html->warning("No help found for '$q->{search}'");
  }
}

sub header_ {
  my($q, $node, $nav) = @_;
  my ($base, $el);
  my ($v, $x,$crumb, $last);
  my $nav1 = {};
  my $G = Labels->read();
  my @a = split(/\./, $node);
  my $IN = "&INFRAME=1" if ($q->{INFRAME} || $q->{FRAME});
  for ($x=0; $x <= 1; $x++) {
    $v .= "." if ($x);
    $v .= $a[$x];
    last if (!$a[$x]);
    if ($a[$x] ne "ROOT") {
      $nav1  = $nav->{$v};
      my $cr = $nav1->{info}{title};
      $last  = $cr;
      if ($cr) {
        $crumb .= " > <a href=$Http::WEBPROC?GO=GUI::Navigation::help&ROOT=$v$IN>$cr</a>";
      } elsif (exists $nav->{$a[$x-1]}{items}{$a[$x]} ) {
        $crumb .= " > $nav->{$a[$x-1]}{items}{$a[$x]}{title}";
      }
    }
  }
  if ($#a == 2 && $nav1) {
     $last = $nav1->{items}{$a[2]}->{title}; $last =~ s/ /&nbsp;/g;
     $crumb .= " > $last";
  }

  my $start = ($q->{NOHREF}||$q->{DOC}) ? "" : "<a href=$Http::WEBPROC?GO=GUI::Navigation::help&SUMMARY=1$IN>Help</a>";
  my ($x1, $x2, $frm);
  if (!$q->{INFRAME}) {
    $x1  = "<a href=$Http::WEBPROC?GO=GUI::Navigation::help&SUMMARY=1$IN>$G->{index}</a> | ";
  }
  $x2  = "<a href=$Http::WEBPROC?GO=GUI::Navigation::help$IN>$G->{toc}</a>";
  if ($q->{WIN}) {
    $frm = "<a href=\"/help_frame2.html&1=$q->{ROOT}&file=$q->{file}&INFRAME=1\">Frame</a> | ";
  }
  if ($q->{search} && length($q->{search}) < 3) {
    delete $q->{search};
    $q->{SUMMARY} = 1;
    print Html->warning($G->{enter3});

  } elsif ( index(",body,title,href,html,", ",$q->{search},") >= 0) {
    delete $q->{search};
    $q->{SUMMARY} = 1;
    print Html->warning("Invalid search word!");
  }
  my $search = $q->{search} || $G->{search};
  my $x3 =<<EOF;
    <input type=hidden name=GO value=GUI::Navigation::help>
    <input type=hidden name=INFRAME value=$q->{INFRAME}>
    <input type=text name=search size=12 value=\"$search\"
           onfocus="if(this.value==this.defaultValue) this.value='';">
    <input type=submit name=ACTION_search value="GO">
EOF

  my ($hc,$big, $form);
  if ($q->{NOHREF} == 9) {
    return ($last, "<tr><tr><td colspan=2>");

  } elsif ($q->{NOHREF}) {
    $big   = "<big>";
    $crumb = substr($crumb, 2);
    $hc    = "";
    $form = "<td align=right nowrap>[ <a href=#_TOP>Top</a> ]</td>" if ($crumb);
  } else {
    $hc = "bgcolor=#F0F0F0";
    $form = "<td align=right nowrap>[ $frm $x1 $x2 ] $x3</td>";
  }

  $crumb =~ s/ href=/ nothing=/g if ($q->{NOHREF});

  return ($last, "<tr><tr><td colspan=2 $hc>
   <table border=0 cellspacing=0 cellspacing=0 width=100%>
        <tr><td><form>$big<b>$start $crumb</td>$form</form>
   </table>
    ");
  
}

use Html::Tree;

sub toc {
  my($q) = @_;

  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $role = $ruser->{role};
  my $window = $ruser->{window} || $renv->{window};
  my $nav = Navigation->read();
  my $lang = $ruser->{language} || $renv->{language};
  my $F = System->get_home() . "/DATA/toc_$lang.html";
  my @M;
  print Html->body(undef, {color => "#F0F0F0", margin => "vlink=navy"} );
  print "</center>";
  &toc_($ruser, $renv, $nav, "ROOT", "", \@M);

  my ($b1,$b2, $b3, $b4);
  if ($q->{SUMMARY} == 1) {
      $b1 = "<b>"; $b3 = "</b>";
  } else {
      $b2 = "<b>"; $b4 = "</b>";
  }
  print "<table border=0 cellpadding=3 width=110% bgcolor=$Style::DARK>
    <tr><td align=right><font color=white>
    [ <a href=/?GO=GUI::Navigation::toc&level=10><font color=white>${b2}Open$b4</font></a> | 
      <a href=/?GO=GUI::Navigation::toc&level=0><font color=white>${b1}Close$b3</font></a> ]&nbsp;
    <tr><td></td>
    <tr><td></td>
    </table>
    ";

  my $tree =  Html::Tree->new({
                this => "$Http::WEBPROC?GO=GUI::Navigation::toc",
                   q => $q,
              sysgif => '/gif',
             target  => "help_main",
              nosort => 1,
                name => "ROOT"});

  print $tree->read(\@M);

}

sub toc_ {
  my($ruser, $renv, $nav, $node, $level, $M) = @_;
  my($i);
  my $nav1 = $nav->{$node};
  my @O = split(/,/, $nav1->{order});
  my $this = $nav1->{info}{title};
  $this = "" if (!$this eq "Start");
  for ($i=0; $i <= $#O; $i++) {
    my $el = $O[$i];
    my $item = $nav1->{items}{$el};
    #next if (index($item->{skip}, "s") >= 0);
    my $act = Navigation::active($item, $ruser, $renv);
    next if ($act == 0);
    if (substr($item->{url},0,1) eq ">") {
       my $dir = $this eq "Start" ? $item->{title} : "$this/$item->{title}";
       &toc_( $ruser, $renv, $nav, substr($item->{url},1),$dir, $M);
    } elsif ($item->{help}) {
      my $url = "$Http::WEBPROC?GO=GUI::Navigation::help2&file=$item->{help}&ROOT=$node.$el&INFRAME=1";
      my $i = $item->{title}; $i =~ s/[ \/]/&nbsp;/g;
      push(@$M, ["$level/$i", $url ]);
    }
  }
}


sub help_ {
  my($titles, $ruser, $renv, $nav, $node, $level, $q) = @_;
  my $out;
  my $nav1 = $nav->{$node};
  my @O = split(/,/, $nav1->{order});

  if ($q->{NOHREF} && $q->{DOC}) {
     if ($level == 1) {  # admin, monitor etc..
     }
  }
  if ($level == 0 && !$q->{FRAME}) {
     my ($last, $out0) =  &header_($q,$node, $nav) ;
     $out .= $out0;
     if (index($node, ".") > 0) {
        $out .= "<tr bgcolor=$Style::LIGHT><td colspan=2><b>$last</td>";
     }
  }
  my $scol =  "bgcolor=$Style::LIGHT";
  my $FR = "&INFRAME=1" if ($q->{FRAME} || $q->{INFRAME});
  my ($last, $i, $cnt);
  for ($i=0; $i <= $#O; $i++) {
    my $el = $O[$i];

    if ($q->{FILTER}) {  # request a subset of the doc document
       my $l1 = length($q->{FILTER});
       my $v  = "$node.$el";
       $v     = "ROOT.$v" if (substr($v,0,4) ne "ROOT");
       my $l2 = length($v);
       my $l3 = $l1 < $l2 ? $l1 : $l2;  
       next if (substr($v,0,$l3) ne substr($q->{FILTER},0,$l3) );
    }
    my $item = $nav1->{items}{$el};
    my $sp = "&nbsp;&nbsp;&nbsp;" x ($level -1) if ($level > 0);
    #next if ($item->{skip} && index($item->{skip}, "t") >= 0);

    my $act = Navigation::active($item, $ruser, $renv);
    next if ($act == 0);

    if (substr($item->{url},0,1) eq ">") {
      my $t1;
      my $target = "target=help_main" if ($q->{FRAME});
      my $u;
      if ($q->{NOHREF}) {
         $u = $item->{title};
      } else {
         $u = $q->{search} ? $item->{title} : 
                "<a href=$Http::WEBPROC?GO=GUI::Navigation::help&ROOT=" . 
                substr($item->{url},1) . "$FR $target>$item->{title}</a>";
      }
      if ($level == 0) {
        $t1 = "<tr><td></td><tr $scol><td>$sp<b>$u</td>";
        $t1 .= " <td><b>$item->{desc}</td>\n" if (!$q->{FRAME});
      } else {
        $t1 = "<tr><td>$sp-$u</td>";
        $t1 .= " <td>$item->{desc}</td>\n" if (!$q->{FRAME});
      }
      if (!$q->{SUMMARY} || $level < 1) {
        my($out1, $cnt1) = &help_loop($q, $sp, $titles, $item, "$node.$el", $act) ;
        $out .= $out1;
        $cnt += $cnt1;
      }
      my ($out0, $cnt0) = &help_($titles, $ruser, $renv, $nav, substr($item->{url},1), $level+1, $q);
      $out .= $t1 if ($cnt0);
      $out .= $out0;
      $cnt+= $cnt0;

    } else {
      if (( $q->{SUMMARY} && $level == 1) ||
          (!$q->{SUMMARY} || $level <  1)) {
         my($out1, $cnt1) = &help_loop($q, $sp, $titles, $item, "$node.$el", $act);
         $out .= $out1;
         $cnt += $cnt1;
      } else {
         $cnt++;
      }
    }
    $last = $item;
  }
  return ($out, $cnt);
}



sub site {
  my($q) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $role = $ruser->{role};
  my $window = $ruser->{window} || $renv->{window};
  my $nav = Navigation->read();
  print Html->body();
  print Html->header2('help_sys.site_map', "95%");

  my ($tab_list, $sub_tab);
  my $cnt = 0;
  my ($i, $out, $sub);
  print "<table border=0 cellspacing=1 width=95% bgcolor=white cellpadding=2>";

  print &site_($q, $ruser, $renv, $nav, 'ROOT', 0);
  print "</table>";
}

sub site_ {
  my($q, $ruser, $renv, $nav, $node, $level) = @_;
  my $out;
  my $nav1 = $nav->{$node};
  my @O = split(/,/, $nav1->{order});
  my ($last, $i);
  for ($i=0; $i <= $#O; $i++) {
    my $el = $O[$i];
    my $item = $nav1->{items}{$el};
    my $sp = "&nbsp;&nbsp;&nbsp;" x ($level -1) if ($level > 0);
    next if ($item->{skip} && index($item->{skip}, "s") >= 0);
    my $act = Navigation::active($item, $ruser, $renv);
#   print "$item->{url}, $item->{role}, $item->{rack}, $act<br>";
    next if ($act == 0);
    $out .= "</td><td valign=top>" if ($level == 0);

    if (substr($item->{url},0,1) eq ">") {
      if ($level == 0) {
        $out .= "<table border=0 cellspacing=0 cellpadding=2 bgcolor=$main::LIGHT width=100%><tr><td>" . 
                 "$sp<b>$item->{title}</b></table>\n";
      } else {
        $out .= "$sp<b>$item->{title}</b><br>\n";
      }
      $out .=  &site_($q, $ruser, $renv, $nav, substr($item->{url},1), $level+1);
    } elsif (substr($item->{url}, 0, 1) eq "/")  {
      if ($act == 2) {
        $out .= "$sp<a href=$item->{url}>$item->{title}</a><br>\n";
      } elsif ($act == 1) {
        $out .= "$sp<font color=gray>$item->{title}</font><br>\n";
      }
    } else {
      if ($act == 2) {
        $out .= "$sp<a href=$Http::WEBPROC?GO=$item->{url}>$item->{title}</a><br>\n";
      } elsif ($act == 1) {
        $out .= "$sp<font color=gray>$item->{title}</font><br>\n";
      }
    }
    $last = $item;
  }
  return $out;
}


  

sub menu_head {
  my($name) = @_;
  my ($corners, $W);
  my $renv = System->get_renv();
  $W = "110%";
  my $ext = $Style::LEFT_GIF_EXT;
  if (substr($renv->{color_scheme},0,4) eq "hci2"){
    $corners = ""; 
  } else {
    $corners = " <tr> <td valign=top><img src=/gif/rcorner2.gif ></td>
      <td align=right valign=top><img src=/gif/lcorner2.gif></td>";
  }

  my $head =<<EOF;
<head>
 <script> var click = 0;  function pic(id,gif) {     if (navigator.appName == "Netscape") {       document.images["b" + id].src = "/gif/" + gif + "$ext.gif";     } else {       document.all["b" + id].src = "/gif/" + gif + "$ext.gif";     }  }  function bover(id) {     pic(id,'bover');   }  function bout(id) {     if (click) {        pic(click, 'bclick');     }     if (id == click) {        return;     }     pic(id,'bout');   }  function bclick(id) {     if (click) {       pic(click,'bout');     }     click = id;     pic(id,'bclick');   } 
</script>
</head>
<body bgcolor=$Style::LEFT_BG link=$Style::LEFT_FG vlink=$Style::LEFT_FG  alink=yellow leftmargin=0 marginwidth=0 marginheight=0 topmargin=0><center>
 <table border=0  cellspacing=0 cellpadding=0 bgcolor=$Style::LEFT_HEAD_BG width=$W>
    <tr><td colspan=2><center>
        <table border=0 cellspacing=0 cellpadding=2 width=70%>
           <tr><td><center><font color=$Style::LEFT_HEAD_FG><b>$name</table>
              $corners
        </table>
    <table border=0><tr><td></table>
EOF

  return $head;
}



1;
