package GUI::Optimization;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use PDM::ConfigFile;
use GUI::Hosts;
use strict;
use Html;

#  $Id: Optimization.pm,v 1.15 2003/04/11 17:36:04 ccadieux Exp $

sub upd {
  my($q, $post) = @_;
  my($renv, $dev, $host, $notifs, $c1, $c2);
  my($err1, $info, $err2, $err3, $err5, $err6, $err8);
  my($error);

  my $deny = Roles->verifyRole($q, "admin|expert");
  my $G = Labels->read();
  my $L = Labels->read("GUI::Optimization");

  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }
  print Html->body();
  $info = "";
  my($warn2, $warn3, $cat, $last_win);
  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();

  if ($q->{ACTION_submit} ) {
    while (1) {
       $renv->{fsa}          = $q->{fsa} ? 1:0;
       $renv->{optimize_t3}  = $q->{optimize_t3} ? 1:0;
       $renv->{array_max_thread}   = $q->{max};
       $renv->{switch_max_thread}  = $q->{sw_max};
  
       if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
          print "$G->{e_100} <br>";
       } else {
          System->set_renv($renv);
          $info = Html->info($L->{l1});
       }
       last;
    }

  }
  my ($button1, $button2);
  if (!$deny) {
    $button1 = " <input type=submit name=ACTION_submit value=\" $L->{submit_options} \">" ;
  }

  my $h = Html->header2("admin.gen_maint.optimization");

  my $fsac = "checked" if ($renv->{fsa});
  my $t3opti = "checked" if ($renv->{optimize_t3});
  my $select = Util->makeSelect("max", "1=1|2|4|6|8|10", $renv->{array_max_thread});

  my $sw_select = Util->makeSelect("sw_max", "1=1|2|4|6|8|10", $renv->{switch_max_thread});

  my $f2;
  if ($renv->{solution} eq "N") {
    $f2 =<<EOF;
<tr><td colspan=3 bgcolor=$Style::BGCOLOR>&nbsp;</td>

<tr><td colspan=3 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{sw_parallel0}</td>
<tr><td></td><td colspan=2>$L->{sw_parallel}</td>
<tr><td></td>
    <td align=right bgcolor=$Style::LIGHT width=40%>$L->{sw_total}: </td>
    <td>$sw_select</td>
<tr><td></td><td align=right bgcolor=$Style::LIGHT width=40%>$L->{t3_total}: </td>
    <td>$select</td>


<tr><td colspan=3 bgcolor=$Style::BGCOLOR>&nbsp;</td>
<tr><td colspan=3 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{t3_opti2}</td>

<tr><td></td><td colspan=2>$L->{t3_opti_info}</td>
<tr><td></td><td align=right bgcolor=$Style::LIGHT width=40%>$L->{t3_opti}: </td><td><input type=checkbox name=optimize_t3 $t3opti></td>
EOF
  }


  my $o =<<EOF;

<body bgcolor=$Style::BGCOLOR>
<form method=post>
 <input type=hidden name=GO value=GUI::Optimization::upd>
<center>
$h
$info
$error
$err2
<table border=0 cellspacing=0 cellpadding=2 width=90% bgcolor=white>
<tr><td colspan=3 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{fsa1}</td>
<tr><td></td><td colspan=2>$L->{fsa_info}</td>

<tr><td></td><td align=right bgcolor=$Style::LIGHT width=40%> $L->{fsa}: </td>
    <td><input type=checkbox name=fsa $fsac>
  $f2
</table>
<b><table border=0><tr><td></table>
  $button1
</form>
EOF
  print $o;

}


1;
 
