package GUIAdmin::SE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: SE.pm,v 1.15 2003/03/10 03:23:30 ccadieux Exp $

use PDM;
use MIME::Base64;

use strict;
use Debug;
use Carp;
use Roles;
use GUIAdmin;
use GUI::Devices;
use base 'GUIAdmin';
use Logic::SE;

sub description {'Sun Solutions'}
sub isDevice   {1}
sub ipRequired {1}


sub addDevice {
  my($class, $q) = @_;

  my($ho, $o, $err, $ipno, $x, $info);
  my($renv, $dev, $host,$notifs, $sel);
  print Html->body();
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('GUIAdmin::SE');

  require "GUI/Devices.pm";
  if ($q->{ACTION_back}) {
    GUI::Devices::add($q);
    return;

  } elsif ($q->{ACTION_add}) {
    my($active) = "Y";
    my ($err, $nodes) = Logic::SE->addToConfig($q);
    if ($err) {
       $info = $err->toHtml();
    } elsif ($#$nodes >= 0) {
       print Html->info( ($#$nodes + 1) . "device(s) added!");
       GUI::Devices::list($q);
       return;
    }
  }
out:
  print GUI::Devices::add0($q);

  my($h) = Html->header($G->{add} . " " . $class->description(),"","",
              "Maintenance.General#adddevice", undef, {nohelp => 1});
  

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $sel = ($q->{host} eq "")? "selected":"";

  my($phost) = "<select name=host><option value=\"\">[$G->{select}]</option>".
              "<option value=\"\" $sel>$G->{local}</option>";

  foreach $x (@$host) {
    next if($x->{dh} eq "Y");
    $sel = ($q->{host} eq $x->{hostname})? "selected":"";
    $phost .= "<option value=" . $x->{hostname} . " $sel>" . $x->{hostname} ."</option>";
  }
  $phost .= "</select>";

  $o =<<EOF;
<form  method=get>
 <input type=hidden name=GO value="GUIAdmin::SE->addDevice">
<center>
$h
<table border=0 cellpadding=2 width=90% bgcolor=white><tr><td>$L->{add_as_dev}</table>
$info
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=2 bgcolor=$Style::DARK><b><font color=white>&nbsp;$G->{enter_device_info}</td>

<tr><td bgcolor=$Style::LIGHT width=30% align=right>$G->{device_name}:</td>
    <td><input type=text name=name size=15 maxlength=15 value="$q->{name}">

<tr><td bgcolor=$Style::LIGHT align=right>$G->{primary_host}:</td>
    <td>$phost</td>
<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right> $G->{ip_name}:</td>
    <td><input type=text name=ip size=40 maxlength=40 value="$q->{ip}">


<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right> $L->{login}:</td>
    <td><input type=text name=login size=20 maxlength=20 value="$q->{login}">
<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right> $L->{password}:</td>
    <td><input type=password name=password size=20 maxlength=30 value="$q->{password}">

</table>
</table>
<b>
EOF

  print $o;
  if (!$deny) {
     print "<input type=submit name=ACTION_add value=\" $G->{submit_add} \">";
  }
  print "<input type=submit name=ACTION_back value=\"$G->{submit_back}\"></form>";

}


sub updDevice {
  my($class, $q) = @_;
  my($ho, $o);
  my($name, $err, $ip, $ipno);
  my($renv, $dev, $host,$notifs, $x, $D, $type, $key, $h1, $h, $sel, $active);
   my $deny = Roles->verifyRole($q, "admin");
  print Html->body();

  require "GUI/Devices.pm";
  my $G = Labels->read();
  my $L = Labels->read('GUIAdmin::SE');

  if ($q->{ACTION_back}) {
    GUI::Devices::list($q);
    return;

  } elsif ($q->{ACTION_update}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $D = $dev->[$x];

    $dev->[$x]{host}     = $q->{host};
    $dev->[$x]{name}     = $q->{name};
    $dev->[$x]{login}    = $q->{login};
    $dev->[$x]{password} = $q->{password};
    my $encode = MIME::Base64::encode("$q->{login}:$q->{password}");
    chomp($encode);
    $dev->[$x]{LID}      = $encode;
    $dev->[$x]{key}  = $dev->[$x]{wwn};
    #$dev->[$x]{class} = "storage.se";
    $dev->[$x]{hba}  = $q->{hba};
    GUIAdmin->clearSlave($q->{host}, $host);

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err = Html->info( $G->expand('device_updated',  $name));

  } elsif ($q->{ACTION_delete}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $type = $dev->[$x]{type};
    $key =  $dev->[$x]{ip};
    GUIAdmin->clearSlave($q->{host}, $host);

    Events->saveEvent("DD", $type,  $key) if ($key);
    $dev->[$x]{_name} = "";
    $name = $dev->[$x]{name} . "/ " . $dev->[$x]{ip};
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    &main::log_change($G->expand('device_deleted',  $name));
    $q->{ERR} = Html->info($G->expand('device_deleted',  $name));
    GUI::Devices::list($q);
    return;
  }
out:

   print Html->header2("admin.gen_maint.maint_device", undef, ": " . $class->description() , " ");


  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $h = $dev->[$q->{no}];

  $ip = $h->{ip}; $ipno = $h->{ipno};

  $sel = ($h->{host})? "":"selected";
  $ho = "<select name=host><option value=\"\" $sel>$G->{local}</option>";
  foreach $h1 (@$host) {
       next if($h1->{dh} eq "Y");
       $sel = ($h1->{hostname} eq $h->{host}) ? "selected":"";
       $ho .= "<option name=$h1->{hostname} $sel>$h1->{hostname}</option>";
  }
  $ho .= "</select>";

  $active = ($h->{active} eq "Y") ? "On":"Off";

  $o =<<EOF;
<body bgcolor=$Style::BGCOLOR>
<form method=get>
 <input type=hidden name=GO value="GUIAdmin::SE->updDevice">
 <input type=hidden name=no value=$q->{no}>
<center>
$err
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100% bgcolor=white>
<td colspan=2 bgcolor=$Style::DARK><b><font color=white>&nbsp;$G->{enter_device_info}</td>

<tr><td bgcolor=$Style::LIGHT align=right>$G->{device_type}:</td>
    <td>
      <table border=0 cellspacing=0 width=100%> <tr>
        <td><b>&nbsp;$h->{type} $h->{model}</td>
        <td bgcolor=$Style::LIGHT align=right>$G->{monitoring}:</td>
        <td ><b>&nbsp;$active</td>
      </table>

<tr><td bgcolor=$Style::LIGHT width=30% align=right>$G->{device_name}:</td>
    <td><input type=text name=name size=20 maxlength=40 value="$h->{name}">

<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right>$G->{device_ip}:</td>
    <td>&nbsp;$ip</td>
<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right>$G->{ip_number}:</td>
    <td>&nbsp;$ipno</td>

<tr><td bgcolor=$Style::LIGHT align=right>$G->{primary_host}:</td>
    <td><b>$ho</td>

<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right> $L->{login}:</td>
    <td><input type=text name=login size=20 maxlength=20 value="$h->{login}">
<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right> $L->{password}:</td>
    <td><input type=password name=password size=20 maxlength=30 value="$h->{password}">

</table></table>
<b>

EOF
  print $o;
  if (!$deny) {
      print "<input type=submit name=ACTION_update value=\"$G->{submit_update}\">
             <input type=submit name=ACTION_delete value=\"$G->{submit_delete}\">";
  }
  print " <input type=submit name=ACTION_back value=\"$G->{submit_back}\">
  </form>";
}

1;

