package GUIAdmin::SVE2;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: SVE2.pm,v 1.6 2003/03/21 23:29:26 ccadieux Exp $

use PDM;
use Util;
use Html;
use strict;
use Debug;
use Carp;
use GUIAdmin;
use GUI::Devices;
use base 'GUIAdmin';
use Logic::SVE2;

sub isDevice {1}
sub description {'Sun DSP1100'};

sub ipRequired {1}

sub discover {
  my( $q, $post, $util) = @_;
  my($o, $warn);
  print Html->text_header();

  if ($q->{ACTION} =~ /Confirm/) {
     &discoverSVE2($q, $post, $util);
     return 'DONE';
  }

  my $h = Html->header2("admin.gen_maint.discovery", undef, "Sun DSP1100", "discover_SVE2");

  $o =<<EOF;
 <body bgcolor=$Style::BGCOLOR>
 <center>
 $h
 <table border=0><tr><td>$warn</table>
</table>
<table border=1 cellspacing=0 cellpadding=4 width=80% bgcolor=white>
  <form method=get>
  <input type=hidden name=GO value=GUI::Discover::discover>
  <input type=hidden name=PKG value=GUIAdmin::SVE2::discover>
  <input type=hidden name=host value=$q->{host}>
  <tr><td align=right width=25% bgcolor=$Style::LIGHT>Enter Name: </td>
      <td><b><input type=text size=30 name=name></td>
  <tr><td align=right width=25% bgcolor=$Style::LIGHT>Enter IP: </td>
      <td><b><input type=text size=30 name=ip></td>
  <tr><td align=right width=25% bgcolor=$Style::LIGHT>Enter Login: </td>
      <td><b><input type=text size=20 name=login></td>
  <tr><td align=right width=25% bgcolor=$Style::LIGHT>Enter Password: </td>
      <td><b><input type=password size=20 name=password></td>
 </table><b>
     <input type=submit name=ACTION value="Confirm SVE2 Discovery">
 </form>
EOF
  print $o;
  return 0;

}

sub discoverSVE2 {
  my( $q, $post, $util) = @_;

  my(%T, @a, $loc, $ip);
  my(%F, @NEW);

  my ($err, $nodes) = Logic::SVE2->addToConfig($q);
  print $err->toHtml() if ($err);

  foreach my $node (@$nodes) {
      print " Found SVE2 $node->{wwn} <br>\n";
  }
}

sub addDevice {
   my($class, $q) = @_;
   &discover($q);
} 

sub updDevice {
  my($class, $q) = @_;
  my($ho, $o);
  my($name, $err, $ip, $ipno);
  my($renv, $dev, $host,$notifs, $x, $D, $type, $key, $h1, $h, $sel, $active);

  print Html->body();
  require "GUI/Devices.pm";
   my $deny = Roles->verifyRole($q, "admin");

  if ($q->{ACTION} eq "Back") {
    GUI::Devices::list($q);
    return;

  } elsif ($q->{ACTION} eq "Update") {
    ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $D = $dev->[$x];

    $dev->[$x]{host}   = $q->{host};
    $dev->[$x]{name}   = $q->{name};
    $dev->[$x]{login}  = $q->{login};
    $dev->[$x]{password}= $q->{password};
    $dev->[$x]{class}  = "switch.dw";
    GUIAdmin->clearSlave($q->{host}, $host);

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err = Html->error("Device $name updated!", "green");

  } elsif ($q->{ACTION} eq "Delete") {
    ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $type = $dev->[$x]{type};
    $key =  $dev->[$x]{ip};
    GUIAdmin->clearSlave($q->{host}, $host);

    Events->saveEvent("DD", $type,  $key) if ($key);
    $dev->[$x]{_name} = "";
    $name = $dev->[$x]{name} . "/ " . $dev->[$x]{ip};
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    &main::log_change("Device $name deleted");
    $q->{ERR} = Html->error("Device $name deleted!");
    GUI::Devices::list($q);
    return;
  }
out:

  $h1 = Html->header2("admin.gen_maint.maint_device", undef, "Sun DSP1100"," ");

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $h = $dev->[$q->{no}];

  $ip = $h->{ip}; 
  $ipno = $h->{ipno};
  my $login = $h->{login};
  my $password = $h->{password};

  $sel = ($h->{host})? "":"selected";

  $ho = "<select name=host><option value=\"\" $sel>Local</option>";
  foreach $h1 (@$host) {
       next if($x->{dh} eq "Y");
       $sel = ($h1->{hostname} eq $h->{host}) ? "selected":"";
       $ho .= "<option name=$h1->{hostname} $sel>$h1->{hostname}</option>";
  }
  $ho .= "</select>";

  $active = ($h->{active} eq "Y") ? "On":"Off";
  my $type1 = $h->{userLabel} || $h->{type};

  $o =<<EOF;
<body bgcolor=$Style::BGCOLOR>
<form  method=get>
 <input type=hidden name=GO value="GUIAdmin::SVE2->updDevice">
 <input type=hidden name=no value=$q->{no}>
<center>
$h1
$err
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr>
<td colspan=2 bgcolor=$Style::DARK><b><font color=white>&nbsp;Device Information</td>

<tr><td bgcolor=$Style::LIGHT align=right>Device Type :</td>
    <td>
      <table border=0 cellspacing=0 width=100%> <tr>
        <td><b>&nbsp;$type1</td>
        <td bgcolor=$Style::LIGHT align=right>Monitoring:</td>
        <td ><b>&nbsp;$active</td>
      </table>

<tr><td bgcolor=$Style::LIGHT width=30% align=right>Device Name :</td>
    <td><input type=text name=name size=40 maxlength=40 value="$h->{name}">

<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right>IP Name :</td>
    <td>&nbsp;$ip</td>

<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right>IP Address :</td>
    <td>&nbsp;$ipno</td>
<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right>Login:</td>
    <td>&nbsp;<input type=text name=login size=30 value=\"$login\"></td>
<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right>Password:</td>
    <td>&nbsp;<input type=password name=password value=\"$password\"></td>

<tr><td bgcolor=$Style::LIGHT align=right>Primary Host :</td>
    <td><b>$ho</td>


</table>
</table>
<b>

EOF

#<tr><td bgcolor=$Style::LIGHT align=right>Data-Path Host :</td> <td><b>$dataho</td>

  print $o;
  if (!$deny) {
      print "<input type=submit name=ACTION value=\"Update\">
             <input type=submit name=ACTION value=\"Delete\">";
  }
  print " <input type=submit name=ACTION value=\"Back\"> </form>";

}


1;

