package Health::3310;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#Name:  $
#  $Id: 3310.pm,v 1.22 2003/05/29 17:43:24 ccadieux Exp $


use base 'Health';
use NWS::3310;
use Ilist;
use Message;
use Catalog;
use Report;
use System;
use Events;
use strict;
use Debug;

sub revision {'$Revision: 1.22 $'}

sub new {
  my($hm, $pdm) = @_;

  my($self) = {pdm => $pdm};
  bless ($self, 'Health::3310');

# Specify each callback
#                            HM  Callback,  Filters
  $pdm->reportRequest($self, 'all_logic' , {category => Report::CAT_3310});
  $pdm->reportRequest($self, 'all_logic' , {category => Report::CAT_3510});
  return $self;
}

#####################################################

sub all_logic {
  my($hm, $report) = @_;
  my($pdm) = $hm->{pdm};
  my($ev, $ed, $pertains, $x ,$y, $contain, $sd);
  my($orep, $key);
  my($rep)     = $report->content;
  my($oreport) = PDM->getOldReport($report->fileKey);
  my($ip)      = $report->id('ip');
  $DB::single = 1;
  my $wwn      = $report->id('deviceName');
  my($id)      = $report->id('display');
  my($shortid) = $report->name();
  my($log)     = $report->log();
  my($renv)    = System->get_renv();
  my $mgmtLevel = $report->value('id.mgmtLevel') || 'D';
  my $path     = $report->value("id.device_path");
  my $type     = $report->id('category');

  CIM->version("1.1");

  my $invalidate_catalog = 0;

  if ($hm->connectionEvent($wwn, $report, {method => ($path ? 1:2)} )) {  # IB / OOB
     return;
  }
  my($tran, $reps) = Transition->getTransition({ key => $report->deviceName(),
                                         code => 'ethernet',
                                        value => $report->value("info.ethernet_status"),
                             transition_value => "ping_failed",
                                       repeat => '12h',
                                 });
  $hm->connection("ethernet", $wwn, $tran, $report, "Ethernet", $reps, 
                         {connect_errs => $report->value("info.ethernet_errs"),
                                method => 2});

  my $freq = $renv->{audit_freq} || 7;
  my $audit = System->get_audit() ? "YES" : Timer->isXdays("Audit$wwn", $freq);

  if (!$oreport || $audit eq "YES" ) {  # new t300 or audit time.
     my($etype) = $audit eq "YES" ? "$type.AuditEvent" : "$type.DiscoveryEvent";
     my($title) = $audit eq "YES" ? "Auditing a":"Discovered a new";

     my($dt)    = "A" if (!$audit);
     $invalidate_catalog = 1;
     Grid->setCode($etype);

     $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => $etype  ],
                  [ Target      => "$type:$wwn"    ],
                  [ TargetName  => $id     ],
                  [ SourceIP    => $ip     ],
                  [ MgmtLevel   => $mgmtLevel ],
                  [ EventId     => $pdm->getEventSequence  ],
                  [ Description => "$title $type called $id"],
                         ]);

     $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
      
     my($p) = NWS::3310->newSystem($rep);

     $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $p->[0] ],
                  [ DiscoveryType => $dt],
                    ]);
     my($monitors) = CIM::Instance->new('NWS_AgentMonitors', [
                  [ Agent       => $sd->[0]  ],
                  [ Element     => $p->[0] ],
                    ]);

     $ed = Message->new( {  id        => $report->id,
                            instances => [$ev, @$sd, @$p, $monitors, $pertains ],
                            severity  => Message::SEVERITY_NORMAL });

     $pdm->saveMessage($ed);
  }

  $orep = ($oreport)? $oreport->content() : $rep; # same report if new disco.

  $hm->locationChangeEvent($report, $rep, $orep, $wwn);

  my($physicalFrame) = CIM::Key->new( ['CIM_PhysicalFrame',   # key of the frame
                        Tag               => $rep->get("id.wwn") ,
                        CreationClassName => 'CIM_PhysicalFrame' ]);

  my $enc_status = $rep->get("info.status");
  my $oenc_status = $orep->get("info.status");
  Grid->setCode("$type.AlarmEvent.enclosure");  # firmware_version, revision
  $hm->alarm($report, $orep, "3310", "info", "status", $shortid, $id, $wwn, 
             "enclosure.status");


  # Check counter values
  Grid->setCode("$type.AlarmEvent.port.statistics");
  $hm->portStatEvents($report, 7, $rep, $orep, "channel");

###########
# INFO
###########
    for my $e ('firmware_version','Revision') {
      my $e0 = lc($e);
      my $ofirm = $orep->{"info.$e"};
      my $nfirm = $rep->{"info.$e"};
      if ($ofirm ne $nfirm) {
         Grid->setCode("$type.AlarmEvent.$e0");  # firmware_version, revision
         $hm->alarmEvent("info.$e","",$report,$wwn,
                   "$id: $e changed from '$ofirm' to '$nfirm'", undef, $e0);
      }
    }

###########
# CHANNELS
###########
    for ($y=1; $y <= 20; $y++) {
      my $comp = "channel.$y.curwid";
      if ($orep->{$comp} && !$rep->{$comp}) {
          Grid->setCode("$type.AlarmEvent.channel");
          my $desc = "Channel " . $orep->{"channel.$y.idx"} . " is missing";
          $hm->alarmEvent($comp,"",$report,$wwn,"$id: $desc", undef, "channel");
      }
    }

###########
# FRUS
###########
    for ($y=1; $y <= 100; $y++) {
        my $comp = "fru.$y";
        last if (!$rep->get("$comp.item"));
        next if ($rep->get("$comp.item") ne $orep->get("$comp.item"));
        my $item = $rep->get("$comp.item");
        my $orev = $orep->get("$comp.revision");
        my $nrev = $rep->get("$comp.revision");

        my $oserial = $orep->get("$comp.serial_number");
        my $nserial = $rep->get("$comp.serial_number");

        if ($orev ne $nrev) {
          my $desc = "The revision of $item on $id changed from '$orev to '$nrev";
          Grid->setCode("$type.AlarmEvent.revision");
          $hm->alarmEvent($comp, "", $report, $wwn, $desc, 1, "revision" );
        }
        if ($oserial ne $nserial) {
           my $desc = "The serial# of $item on $id changed from '$oserial to '$nserial";
           Grid->setCode("$type.AlarmEvent.fru_serial");
           $hm->alarmEvent($comp, "", $report, $wwn, $desc, 1, "serial_number" );
        }
    }
  
###########
# DISKS 
###########
    my $diskTotal = $rep->get('info.total_physical_drives');
    for ($y=1; $y <= $diskTotal; $y++) {
        my $comp = "components.disk.$y";

        my $oserial = NWS::3310->getKey($orep, $comp); 
        my $nserial = NWS::3310->getKey($rep, $comp);  

        if ($oserial eq $nserial) {
           Grid->setCode("$type.StateChangeEvent.disk");
           $hm->stateEvent($comp, $report, $rep, $orep, 'CIM_PhysicalPackage', $nserial, $wwn);

        } else {
           if ($oserial) {
             Grid->setCode("$type.ComponentRemoveEvent.disk");
             $hm->removeCompEvent($comp,$physicalFrame,$report,'CIM_PhysicalPackage',$oserial, $wwn);
           }
           if ($nserial) {
             my($part) = NWS::3310->newDiskDrive($rep, $comp);
             Grid->setCode("$type.ComponentInsertEvent.disk");
             $hm->insertCompEvent($comp,$physicalFrame, $report, $part, $nserial, $wwn);
           }
       }
    }

#############
# LOGICAL DRIVE
#############
    my $LUNS = $rep->get('info.total_logical_drives');

    for ($y = 1; $y <= $LUNS; $y++) {
      my $comp = "logical_drive.$y";
      if (!exists($rep->{"$comp.status"})) {
         my $lun = NWS::3310->newLun($rep, $comp);
         Grid->setCode("$type.ComponentInsertEvent.lun");
         $hm->insertCompEvent($comp, $physicalFrame, $report, $lun, "$wwn.$comp", $wwn, {logicalDevice => 1} );
      } else {
         Grid->setCode("$type.StateChangeEvent.lun");
         $hm->stateEvent($comp, $report, $rep, $orep,
                         'CIM_PhysicalPackage', "$wwn.logical.$y",  $wwn);
      }
      my $opar = $orep->{"$comp.total_partitions"};
      my $npar = $rep->{"$comp.total_partitions"};
      if ( $opar ne $npar) {
        Grid->setCode("$type.AlarmEvent.volume");
        $hm->alarmEvent($comp,"",$report,$wwn,"$id: Total partitions has been changed on $comp from '$opar' to '$npar'", undef, "volume");
      }
      my $orl = $orep->{"$comp.raid_level"};
      my $nrl = $rep->{"$comp.raid_level"};
      if ( $orl ne $nrl) {
        Grid->setCode("$type.AlarmEvent.raid_level");
        $hm->alarmEvent($comp,"",$report,$wwn,"$id: Raid level has been changed on $comp from '$orl' to '$nrl'", undef, "raid_level");
      }
      # PARTITION 
      my $py;
      my $part_num = $rep->{"$comp.total_partitions"};
      for ($py = 1; $py <= $part_num; $py++) {
         my $comp1 = "$comp.partition.$py";
         my $osize = $orep->{"$comp1.effective_size"};
         my $nsize = $rep->{"$comp1.effective_size"};
         if ( $osize ne $nsize) {
           Grid->setCode("$type.AlarmEvent.size");
          $hm->alarmEvent($comp,"",$report,$wwn,"$id: Effective size has been changed on $comp from $osize to $nsize", undef, "size");
         }
      }
    }
    return;

    # N/A
    #emu temperature check
     my $emu_num = $rep->{'info.emu_cnt'};
     for ($y = 0; $y < $emu_num; $y++) {
        my $comp = "emu.$y";
        my $osize = $orep->{"$comp.temperature"};
        my $nsize = $rep->{"$comp.temperature"};
        if ( $osize ne $nsize) {
          Grid->setCode("$type.AlarmEvent.temperature");
          $hm->alarmEvent($comp,"",$report,$wwn,"$id: Temperature status has been changed on $comp from '$osize' to '$nsize'", undef, "temperature");
        }
    } 
 
    #power check
     my $power_num = $rep->{'info.power_cnt'};
     for ($y = 0; $y < $power_num; $y++) {
        my $comp = "power.$y";
        my $ostatus = $orep->{"$comp.status"};
        my $nstatus = $rep->{"$comp.status"};
        if ( $ostatus ne $nstatus) {
          Grid->setCode("$type.AlarmEvent.power");
          $hm->alarmEvent($comp,"",$report,$wwn,"$id: Power status has been changed on $comp from '$ostatus' to '$nstatus'", undef, "power");
        }
    }
 
    #fan check
     my $fan_num = $rep->{'info.fan_cnt'};
     for ($y = 0; $y < $fan_num; $y++) {
        my $comp = "fan.$y";
        my $ostatus = $orep->{"$comp.status"};
        my $nstatus = $rep->{"$comp.status"};
        if ( $ostatus ne $nstatus) {
          Grid->setCode("$type.AlarmEvent.fan");
          $hm->alarmEvent($comp,"",$report,$wwn,"$id: Fan status has been changed on $comp from '$ostatus' to '$nstatus'", undef, "fan");
        }
    }

}

  

sub status {
  my($hm, $rep, $orep, $comp) = @_;

  my $pdm = $hm->{pdm};
  my $map = $pdm->getDeviceStateMap("3310.availability");

   my $status  = $rep->getState("$comp.status");
   my $ostatus = $orep->getState("$comp.status");

   my($oav, $av, $sev, $act);
   if (index($comp, ".disk.") > 0) {
     ($oav, $av, $sev, $act) = $map->transition("disk_status.$ostatus", "disk_status.$status", $orep, $rep);
   } elsif (index($comp, "logical_drive") >= 0) {
     ($oav, $av, $sev, $act) = $map->transition("lun_status.$ostatus", "lun_status.$status", $orep, $rep);
   }

   return ($ostatus, $status, $oav, $av, $sev, $act);

}


1;
