package Linktest::6120;
use strict;
use Linktest::Node;
use base 'Linktest::Node';

sub portTest {0}
sub needPassword {0}

sub class {'storage.6120'}

sub type2 {"ST"}


sub prompt_info {
  my($node) = @_;
  return ($node->{logical}, $node->{port});
}
 

sub node_isolation {
  my ( $node_a, $node_b, $failed_node, $mode ) = @_;

  Linktest->debug_header( $node_a, $node_b, "t4_node_isolation" );
  my $linkEnv = System->get_linkEnv();

  my $diagnostic_node;
  my $answer;
  my $status;
  my $out;

  if ( $mode eq "PORT" ) {
    # The testing will be done by running the disk test
    $diagnostic_node = $node_a;
  } else {
    # The testing will be done by the test of the node we connected to
    $diagnostic_node = $node_b;
  }

  # try the SFP first

  $node_a->prompt('remove_device_cable' );
  $node_a->prompt('replace_port_sfp');
  $node_a->prompt('restore_device_cable' );
  $answer = Linktest->ask_continue();
  if ( $answer ne "n" ) {
    # utilize the port diagnostic
    $out = $node_b->start_diagnostic("E");
  } else {
    $node_a->prompt('remove_device_cable' );
    $node_a->prompt('restore_device_ori_sfp' );
    $node_a->prompt('restore_device_cable' );
    Linktest->premature_exit();
  }
  if ( $out->{rc} == 0 ) {
    # the test passed with a new SFP. The SFP is the suspect.
    $node_a->prompt('suspect_device_sfp' );
    Linktest->retest_msg();
    return $Linktest::FOUND_SUSPECT_FRU;
  }

  $node_a->prompt('remove_device_cable' );
  $node_a->prompt('restore_device_ori_sfp' );
  $node_a->prompt('replace_device_cable' );
  $answer = Linktest->ask_continue();
  if ( $answer ne "n" ) {
    # utilize the port diagnostic
    $out = $node_b->start_diagnostic( "E");
  } else {
    $node_a->prompt('remove_device_cable' );
    $node_a->prompt('restore_device_cable' );
    Linktest->premature_exit();
  }
  if ( $out->{rc} == 0 ) {
    # the test passed with a new cable. The cable is the suspect.
    $node_a->prompt('suspect_device_cable' );
    Linktest->retest_msg();
    return $Linktest::FOUND_SUSPECT_FRU;
  }
  # it wasn't the SFP or the CABLE.
  $node_a->prompt('remove_device_cable' );
  $node_a->prompt('restore_device_cable' );
  $node_a->prompt('suspect_device' );
  $node_a->prompt('ra_detected_bad_device');
  return $Linktest::FOUND_SUSPECT_FRU;

}

#sub start_diagnostic {
#  my($node, $mode) = @_;
#  my($test, $options, $sparcv9);
#
#  my($verbose, $wb_patterns, $option_user_pattern) = $node->diag_defaults();
#
#  my $user_password = $node->password();
#
#  my $controller;
#  if($node->{port} eq 1){
#    $controller = "Alternate";
#  }else{
#     # Must be 0 or primary
#    $controller = "Primary";
#  }
#
#  $options = "$verbose -y -q -f -o " . '"' . "dev=$node->{ip}|passwd=$user_password|usr=root|pattern=$wb_patterns|controller=$controller" . $option_user_pattern . '"';
#  return $node->run_diagnostic("ondg", $sparcv9, $options, 5);
#}


sub start_diagnostic {
  my($node, $mode) = @_;
  my($test, $options, $sparcv9, $estimated_time);

  my($verbose, $wb_patterns, $option_user_pattern) = $node->diag_defaults();

  $test = "6120test";
  $estimated_time = 5;

  $options = "$verbose -q  -f -o " . '"' . "dev=$node->{logical}|partition=2|rawsub=e|method=SyncIO+AsyncIO|rawcover=1|rawiosize=0x32768|selectpattern=$wb_patterns" . $option_user_pattern . '"';

  return $node->run_diagnostic("6120test", $sparcv9, $options, 5);
}


1;


