package Linktest::INTERNAL;

use strict;
use Linktest::Node;
use base 'Linktest::Node';


sub portTest {0}

sub class {'storage.internal'}

sub type2 {"ST"}

sub prompt_info {
  my($node) = @_;
  return ($node->{logical}, $node->{port});
}

sub node_isolation {
  my ( $node_a, $node_b, $failed_node, $mode ) = @_;

  Linktest->debug_header( $node_a, $node_b, "interanl_node_isolation" );
  my $linkEnv = System->get_linkEnv();

  my $diagnostic_node;
  my $answer;
  my $status;
  my $out;

  if ( $mode eq "PORT" ) {
    $diagnostic_node = $node_b;
  } else {
    $diagnostic_node = $node_a;
  }

  # try the GBIC first
  $node_a->prompt('remove_device_cable' );
  $node_a->prompt('replace_device_gbic' );
  $node_a->prompt('restore_device_cable' );
  $answer = Linktest->ask_continue();
  if ( $answer ne "n" ) {
    $out = $diagnostic_node->start_diagnostic("E" );
  } else {
    $node_a->prompt('remove_device_cable' );
    $node_a->prompt('restore_device_gbic' );
    $node_a->prompt('restore_device_cable' );
    Linktest->premature_exit();
  }
  if ( $out->{rc} == 0 ) {
    # the test passed with a new GBIC. The GBIC is the suspect.
    $node_a->prompt('suspect_device_gbic' );
    Linktest->retest_msg();
    return $Linktest::FOUND_SUSPECT_FRU;
  }

  $node_a->prompt('remove_device_cable' );
  $node_a->prompt('restore_device_gbic' );
  $node_a->prompt('replace_device_cable' );
  $answer = Linktest->ask_continue();
  if ( $answer ne "n" ) {
    $out = $diagnostic_node->start_diagnostic("E" );

  } else {
    $node_a->prompt('remove_device_cable' );
    $node_a->prompt('restore_device_cable' );
    Linktest->premature_exit();
  }
  if ( $out->{rc} == 0 ) {
    # the test passed with a new cable. The cable is the suspect.
    $node_a->prompt('suspect_device_cable' );
    Linktest->retest_msg();
    return $Linktest::FOUND_SUSPECT_FRU;
  }

  $node_a->prompt('remove_device_cable' );
  $node_a->prompt('restore_device_cable' );

  # it wasn't the GBIC or the CABLE.
  $node_b->prompt('multiple_suspects' );
  if ($linkEnv->{option_pattern_type} ne "all") {
    $node_a->prompt('ra_all_patterns' );
  }
  $node_b->prompt('ra_fcdisktest' );
  if ( $node_a->{type} eq 'hba' ) {
    $node_a->prompt('ra_hbatest' );
  } elsif ( $node_a->{type} eq 'switch' ) {
    $node_a->prompt('ra_switchtest' );
  } elsif ( $node_a->{type} eq 'switch2' ) {
    $node_a->prompt('ra_switch2test' );
  } elsif ( $node_a->{type} eq 'brocade' ) {
    $node_a->prompt('ra_brocadetest' );
  } elsif ( $node_a->{type} eq 'mcdata' ) {
    $node_a->prompt('ra_mcdatatest' );
  }

  return $Linktest::PROBLEM_UNDETECTED;

}

sub start_diagnostic {
  my($node, $mode) = @_;
  my($test, $options, $sparcv9, $estimated_time);

  my($verbose, $wb_patterns, $option_user_pattern, $option_pattern_type) = 
                 $node->diag_defaults();


  $test = "fcdisktest";

  $options = "$verbose -q -i1 -f -o " . '"' . "dev=$node->{logical}|partition=2|selftest=Enable|wrdevbuf=Enable|selectpattern=$wb_patterns|rawsub=Enable|method=SyncIO+AsyncIO|rawcover=1|rawiosize=0x32768" . $option_user_pattern . '"';

  if ($option_pattern_type eq "user") {
    $estimated_time = 2;
  } elsif ($option_pattern_type eq "critical") {
    $estimated_time = 3;
  } else {
    $estimated_time = 4;
  }

  return $node->run_diagnostic($test, $sparcv9, $options, $estimated_time);
}



1;

