package Logic::Ethers;
use strict;

# 00:C0:DD:00:B2:01     sw1b

sub read{
  my($class) = @_;

  my (%E,$l);
  open(O, "/etc/ethers");
  while ($l = <O>) {
     my($et, $name) = split(/\s+/, $l);
     $E{$name} = $et;
  }
  close(O);
  my $ether = \%E;
  bless($ether, 'Logic::Ethers');
  return $ether;
}

sub write {
  my($ether) = @_;
  open(O, ">/etc/ethers");
  foreach my $e (sort keys %$ether) {
     print O "$ether->{$e}\t$e\n";
  }
  close(O);
}

sub valid {
  my($class, $et) = @_;

  if ($et !~ /^[0-9A-F][0-9A-F]\:[0-9A-F][0-9A-F]\:[0-9A-F][0-9A-F]\:[0-9A-F][0-9A-F]\:[0-9A-F][0-9A-F]\:[0-9A-F][0-9A-F]$/) {
     return 0;
  }
  return 1;
}

sub readHosts {
  my($class, $FILTER) = @_;
  my (%H, $l);
  my $E = $class->read();
  open(O, "/etc/hosts");
  my $hostname = System->hostname();
  my $ix = index($hostname, ".");
  $hostname = substr($hostname, 0, $ix) if ($ix > 0);

  while ($l = <O>) {
     chop($l);
     next if (substr($l,0,1) eq "#");
     my($ip, $name) = split(/\s+/, $l);
     next if ($ip !~ /^$FILTER/ &&
              substr($name, 0, length($hostname)) ne $hostname);
     $H{$ip} = [$name, $E->{$name}];
  }
  close(O);
  my $h = \%H;
  bless($h, 'Logic::Ethers_h');
  return $h;
}




package Logic::Ethers_h;

sub nameExists {
  my($class, $name) = @_;
  my $H = Logic::Ethers->readHosts();
  foreach my $el (keys %$H) {
     my $e = $H->{$el};
     return 1 if ($e->[0] eq $name);
  } 
  return 0;
}
  
1;

