package TO::3310;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::STORAGE';
use strict;
sub type { '3310'}
sub leaf { 1 }

sub portLabel {
  my($class, $port) = @_;
  return "port-$port";
}

sub getPortCIMId {
  my($node , $port) = @_;    #  0 / 1
  my $pi = $node->portInfo();
  return $pi->[$port]{PortWWN};
}


sub new {
  my($class, $to, $host, $dev, $exists) = @_;

  my $storages  =  $to->[2];
  my $syns      =  $to->[4];
  my $key       = $dev->{key};
  my $type              = $dev->{type};

  my $obj = $exists || {};
  my $org_name          = $obj->{info}{name};
  $obj->{info}{type}    = $type;
  $obj->{info}{class}   = "storage.$type";
  $obj->{info}{name}    = "$type:$key";
  $obj->{info}{BoxName} = $dev->{name};
  $obj->{info}{host}    = $host;
  $obj->{info}{host_type} = "ib";
  $obj->{info}{VendorID}= "SUN";
  $obj->{info}{LGroup}  = "Sun $type";
  $DB::single= 1;

  require Agent::3310;
  my $rc = Agent::3310->getWWN($dev->{ipno});

  my $report = $rc->{report};
  Agent::3310->getPortWWNS($dev, $report);

  my ($x, $ports, $cnt);
  if ($dev->{type} eq "3510") {
    for ($x=0; $x <= 20; $x++) {
       next if (!exists $report->{"port.$x.id"});
       my $wwn = $report->{"port.$x.wwn"} ;
       $obj->{portInfo}[$x]{PortWWN}      = $wwn;
       $obj->{portInfo}[$x]{LocalPortWWN} = $wwn;
       $obj->{portInfo}[$x]{id}           = $report->{"port.$x.id"};
       $syns->{$wwn}  = "$type:$key:$x";
       $obj->{info}{port_cnt} = $x + 1;
    }
  } elsif (!exists $obj->{port}) {
    my $hnode = $to->nodeByName("host:$host");
    if ($hnode) {
       my $hnode_p = $hnode->{port};
       my $lp = $#$hnode_p+1;
       $hnode_p->[$lp]  = "$obj->{info}{name}:0";
       $hnode->{portInfo}[$lp]{RegisterName} = 'scsi';
       my $ix_port = $obj->{port};
       $ix_port->[0] = "host:$host:$lp";
       $obj->{portInfo}[0] = {PortWWN => $key, portType => 'scsi'};
    }
  }
  $obj->{info}{disk_cnt} = $report->{"info.total_physical_drives"};
  bless($obj, "TO::$type");
  $syns->{$key} = "$type:$key";
  delete $storages->{$org_name} if ($org_name);
  $storages->{"$type:$key"} = $obj;
  return $obj if ($exists); 

  for ($x=1; $x <= 200; $x++) {
     last if (!exists $report->{"components.disk.$x.model"});
     $obj->{diskInfo}[$x-1] = {
                 status => $report->{"components.disk.$x.status"},
                 };
     $cnt++;
  }
  $obj->{port}= [];
  
  return $obj;
}

sub addFromConfig {
  my($class, $topo, $Config) = @_;

  my $devs = $Config->myDevices();
  my $renv = $Config->renv();

  foreach my $dev (@$devs) {
     next if ($dev->{type} ne $class->type());
     next if (!$dev->isMineToMonitor());
     my $k = $dev->{type} . ":" . $dev->key();
     my $exists = $topo->nodeByName($k);
     if (!$exists) {
        my $wwn = $dev->{wwn} || $dev->{wwn2} || $dev->{wwn3} || $dev->{wwn4};
        $exists = $topo->nodeByKeySkipN($wwn,4);
     }
     $class->new($topo, $renv->{hostname}, $dev, $exists);
  }
}

sub statusFunc {
  my($class, $name, $State, $arg, $node) = @_;

  my $Comp    = $State->components();
  my $i       = $Comp->value("$name:e");
  my $iIB     = $Comp->value("$name:ib");

  my $enc     = TO->val($i->[0], $iIB->[0]);
  my $encInfo = TO->val2(1,$i, $iIB);

  my $port;
  my $portInfo;
  my ($other, $otherInfo) = $Comp->summary($name, 
                              ["power","fan","cpu","controller"], ["components"]);

  my($disk, $diskInfo, $d);

  for ($d=1; $d <= 12; $d++) {
     my $i1 = $Comp->value("$name:components.disk.$d",0);
     if ($i1 >= 1) {
        $disk     .= "$i1,";
        $diskInfo .= $Comp->value("$name:components.disk.$d",1) . ",";
     } else {
        $disk     .= ",";
        $diskInfo .= ",";
     }
  }
  return ($enc, $port, $disk, $other, $encInfo, $portInfo, $diskInfo, $otherInfo);
}




sub iconLayout {
  my($obj) = @_;
  my ($cat, $label2, $ses);
  my $rows =  $obj->{info}{disk_cnt} / 12;
  my ($x, $dd);
  for ($x=1; $x <= $rows; $x++) {
    $dd .= "$x/";
  }
  chop($dd) if ($dd);
  my $ports = $obj->{info}{port_cnt} || 1;

  $cat = "a,3310,$ports/  ,12,$dd,PFCTO,Power/Fan/CPU/Controller/Other,E0D0F0/3310.gif";

  $label2 = $obj->{info}{LGroup};
  $ses = 1;

  return ($cat, $label2, $ses);
}

# "a,$t3,2/12,-$dt,$dd,LMPVA,Loop/Midplane/Power/Volumes/Alerts,D0D0F0/t3pg.gif";

1;
