package TO::FCSWITCH;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use TO;
use TO::PARENTSWITCH;
use base 'TO::PARENTSWITCH';
use Carp;

sub leaf            { 0 }
sub type            { croak "ABSTRACT" }
sub getDevStatus    { croak "ABSTRACT" }
sub getLocalPortWWN { croak "ABSTRACT" }
sub getZones        { croak "ABSTRACT" }
sub statusFunc      { croak "ABSTRACT" }
sub extraPortInfo   { return {} }


sub newFromDev {
  my($class, $Topo, $host, $dev) = @_;
  my($x);
  my $TYPE = $class->type();
  my $name = "$TYPE:$dev->{wwn}";
  my $new = 0;
  my $err;
  my $ip;
  my($switches) = $Topo->[1];
  my($syns)     = $Topo->[4];

  if (!defined($switches->{$name})) {
     $new= 1;
     my($obj) = {};
     $obj->{info}{name}   = $name;
     $obj->{info}{type}   = $TYPE;
     $obj->{info}{BoxName} = $dev->{name};
     $obj->{info}{class}  = "switch.$TYPE";
     $obj->{info}{sw_WWN} = $dev->{wwn};
     $obj->{info}{mgmtLevel} = $dev->{mgmtLevel} || "D";
     $obj->{info}{sw_ipAddr} = $dev->{ipno};
     if ($dev->{primary}) {
       $obj->{info}{sw_ipAddr_remote} = $dev->{primary};
       $obj->{info}{sw_remote_fcaddr} = "0x". $dev->{fc};
     }
     $obj->{port} = [];
     my ($err0, $V) = $class->getDevStatus($dev); 
     if ($err) {
         $Topo->[6]{$TYPE} = {error => $err0};
     }
     $err .= $err0;

     my $port_cnt = $V->{'port.count'};
     $obj->{info}{ProductID} = ($dev->{userLabel}||$TYPE) . "-$port_cnt";

     for ($x=0; $x < $port_cnt; $x++) {
        my $local = $class->getLocalPortWWN($V, $dev, $x);
        $syns->{$local} = "$name:$x";

        $obj->{portInfo}[$x] = { 
                sw_PortType   => $V->{"port.$x.type"},
                sw_PortNum    => $x,
                sw_PortState  => lc($V->{"port.$x.state"}),
                sw_ipAddr_remote => $dev->{ipno},
                PortWWN       => $V->{"port.$x.link_wwn"},
                LocalPortWWN  => $local,
                PortFC        => $V->{"port.$x.link_fc"},
                 };
        my $extra = $class->extraPortInfo($x, $V);
        foreach my $ex (keys %$extra) {
           $obj->{portInfo}[$x]{$ex} = $extra->{$ex};
        }
         
        if ($V->{"port.$x.link_port"}) {
           $obj->{portInfo}[$x]{PortTargetPort} = $V->{"port.$x.link_port"};
           $obj->{port}[$x] = "$TYPE:" . $V->{"port.$x.link_wwn"} . ":" . 
                              ($V->{"port.$x.link_port"}+0);
        }
     }
     $obj->{info}{host} = $host;
     $obj->{info}{host_type} = "oob";
     
     $obj->{info}{portCount} = $port_cnt;
     bless($obj, 'TO::' . uc($TYPE));

     $ip = $dev->{ipno};
     my $ZO = {};

     $err = $class->getZones($dev, $ZO);

     foreach my $k (keys %$ZO) {
        my($a, $t, $no, $type) = split(/\./, $k);  # zone.hd_name.0.name = "asdasda"
        $obj->{zones}{$t}[$no] = $ZO->{$k};
     }

     $syns->{$dev->{wwn}} = $name;
     $switches->{$name}  = $obj;
  }
  return ($new ,$switches->{$name}, $err);
}


sub iconLayout {
  my($sw, $orient) = @_;
  return "F0D8D8/switch2.gif,FPT,Fan/Power/Temp,$orient" ; # ,h = horiz switch
}


sub ip {
  my($sw) = @_;
  my $i = $sw->{info};
  return $i->{sw_ipAddr};
}


1;
