package TO::T3;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use TO::STORAGE;
use base 'TO::STORAGE';
use strict;

# portLabel expect port=0/1

sub leaf { 1 }
sub diskTotal {9}
sub type {'t3'}

sub portLabel {
  my($class, $port) = @_;
  return "ctrl-" . ($port+1);
}

sub getPortCIMId {
  my($node , $port) = @_;    #  0 / 1
  my $pi = $node->portInfo();
  return $pi->[$port]{PortWWN};
}

#
# returns the port name , as entered in Reports and State.
#
sub getPortId {
  my($class, $port) = @_;    #  0 / 1
  if ($port == 0) {
     return 'controller.u1ctr';
  } else {
     return 'controller.u2ctr';
  }
}

sub disk_map {
}

sub new {
  my($class, $to, $host, $dev, $already) = @_;

  my $storages  =  $to->[2];
  my $syns      =  $to->[4];
  my $key = $dev->{key};
  my $t3 = $class->type();
  my $obj = {};

  if ($already) {
     $obj = $already;  
     $obj->{info}{units} = $dev->{units} ? $dev->{units} : ($dev->{wwn2} ? 2:1);
     $obj->disk_map();
     return $obj;
  } 

  $obj->{info}{type}    = $t3;
  $obj->{info}{class}   = "storage.$t3";
  $obj->{info}{name}    = "$t3:$key";
  $obj->{info}{BoxName} = $dev->{name} || $dev->{ipno};
  $obj->{info}{host}    = $host;
  $obj->{info}{host_type} = "oob";
  $obj->{info}{VendorID}= "SUN";
  $obj->{info}{Model}   = $dev->{model};
  $obj->{info}{LGroup}  = "StorEdge-" . uc($t3) . "-00";
  $obj->{info}{PortWWN} = $dev->{wwn};
  $obj->{info}{NodeWWN} = $dev->{wwn};
  $obj->{info}{ipAddr}  = $dev->{ipno};
  $obj->{info}{units}   = $dev->{units} ? $dev->{units} : ($dev->{wwn2} ? 2:1);
  $obj->{info}{userLabel}  = $dev->{userLabel};
  $obj->{info}{mgmtLevel}  = $dev->{mgmtLevel} || "D";
  $obj->{info}{PG}      = 0;
  $obj->{port}          = [];
  $syns->{$dev->{wwn}}  = "$t3:$key:0";
  $obj->{portInfo}[0]   = {PortWWN => $dev->{wwn}};
  if ($dev->{wwn2}) {
     $obj->{info}{PG}  = 1;
     $obj->{portInfo}[1]   = {PortWWN => $dev->{wwn2}};
     $syns->{$dev->{wwn2}}  = "$t3:$key:1";
  }
  
  bless($obj, "TO::" . uc($t3));
  $obj->disk_map();
  $syns->{$key} = "$t3:$key";
  $storages->{"$t3:$key"} = $obj;
  return $obj;
}

sub addFromConfig {
  my($class, $topo, $Config) = @_;

  my $devs = $Config->myDevices();
  my $renv = $Config->renv();

  foreach my $dev (@$devs) {
     next if ($dev->{type} ne $class->type());
     next if (!$dev->isMineToMonitor());
     my $k = $dev->{type} . ":" . $dev->key();
     my $already = $topo->nodeByName($k);
     $class->new($topo, $renv->{hostname}, $dev, $already);
  }
}

sub diagramApplet {
  my($class, $name, $Comp, $to) = @_;

  my $Config = PDM::ConfigFile->read();
  my $renv = $Config->renv();
  my $dev = $Config->deviceByKey($name);
  my $width = 305;
  my $height = 232;
  my $gif = "t3_open";
  my $hi = $renv->{gui_bandwidth} || "L";
  if ($dev->{wwn2}) {
    $gif = "t3pg_open";
    $width = 303; $height = 437
  }

  open(O, System->get_home() . "/System/Products/$gif.htm");
  my (%M, $l);
  while ($l = <O>) {
     $l =~ s/"//g;
     if ($l =~ /coords = (\d+),(\d+),(\d+),(\d+)\s+HREF=([^>]+)/) {
        $M{$5} = "$1,$2,$3,$4";
     }
  }
  close(O);
  my $applet =<<EOF;
 <applet code="IMap.class" width=$width height=$height>
 <param name="mapimage" value="/gif/$gif$hi.gif">
 <param name="fgcolor" value="#FFFFFF">
 <param name="bgcolor" value="#666699">
 <param name="alarmFlag" value=1>
 <param name="border" value="1,#FFFFFF">
 <param name="boxSize" value=10>
 <param name="font" value="arial,normal,10">
 <param name="margins" value="5,5">
 <param name="outline" value="#FF0000">
EOF
  my $cnt = 1; my $y;
  foreach my $el (keys %M) {
    my $c = $Comp->{"$name:$el"};
    $applet .= "<param name=shape-$cnt value=\"rect,$M{$el}\">\n";

    if ($c && defined($c->[0])) {
      my $status = int($c->[0] + 0.5);
      my $text = $c->[1];
      $applet .= "<param name=\"status-$cnt\" value=$status>\n";
      my $len = 0;
      my $cnt2 = 1;
      my @w = split(/\s+/, $text);
      my $curr = "";
      for ($y=0; $y <= $#w; $y++) {
        my $w1 = $w[$y];
        $curr .= "$w1 ";
        if (length($curr . $w[$y+1]) > 42) {
          $applet .= "<param name=\"text-$cnt-$cnt2\" value=\"$curr\">\n";
          $cnt2++;
          $curr= "";
        }
      }
      if ($curr) {
          $applet .= "<param name=\"text-$cnt-$cnt2\" value=\"$curr\">\n";
      }
    } else {
      $el = ($el eq "e") ? "Comm-OOBand" : ($el eq "ib"? "Comm-InBand": $el);
      $applet .= "<param name=\"text-$cnt-1\" value=\"$el\">\n";
    }
      
    $cnt++;
  }
  $applet .= "</applet>";
  return $applet;
}

sub statusFunc {
  my($class, $name, $State, $arg, $node) = @_;

  my $Comp    = $State->components();
  my $i       = $Comp->value("$name:e");
  my $iIB     = $Comp->value("$name:ib");
  my $enc     = TO->val($i->[0], $iIB->[0]);
  my $encInfo = TO->val2(1,$i, $iIB);

  my $port =  $Comp->value("$name:controller.u1ctr",0) . "," .
              $Comp->value("$name:controller.u2ctr",0);

  my $portInfo = $Comp->value("$name:controller.u1ctr",1) . "," .
                 $Comp->value("$name:controller.u2ctr",1);

  my($disk, $diskInfo, $otherInfo, $other, $u, $d);
  my($l1, $l2, $l3, $l4, $p1, $p2, $p3, $p4, $v1, $v2, $v3, $v4);
  my $disk_map = $node->info("disk_map");
  $diskInfo = ",";
  my $units = $node->{info}{units} || ( $node->{info}{PG} ? 2 : 1 );

  for ($u=1; $u <= $units; $u++) {
     for ($d=1; $d <= $class->diskTotal(); $d++) {
         my $i1 = $Comp->value("$name:disk.u${u}d$d*",0);
         if ($i1 >= 1) {
            $disk     .= "$i1,";
            $diskInfo .= $Comp->value("$name:disk.u${u}d$d*",1) . ",";
         } elsif (index($disk_map, ",$u-$d,") >= 0) {
            $disk     .= "-1,";
         } else {
            $disk     .= ",";
            $diskInfo .= ",";
         }
     }
  }
#   LMPV

     $l1 = $Comp->value("$name:loopcard.u1l1*");
     $l2 = $Comp->value("$name:loopcard.u1l2*");
     $l3 = $Comp->value("$name:loopcard.u2l1*");
     $l4 = $Comp->value("$name:loopcard.u2l2*");

     $p1 = $Comp->value("$name:power.u1pcu1*");
     $p2 = $Comp->value("$name:power.u1pcu2*");
     $p3 = $Comp->value("$name:power.u2pcu1*");
     $p4 = $Comp->value("$name:power.u2pcu2*");

     $v1 = $Comp->value("$name:volume.u1vol1");
     $v2 = $Comp->value("$name:volume.u1vol2");
     $v3 = $Comp->value("$name:volume.u2vol1");
     $v4 = $Comp->value("$name:volume.u2vol2");

     my $m1 = $Comp->value("$name:midplane.u1mpn");
     my ($alarm, $alarm_info);
     foreach my $e (keys %$Comp) {
         if ($e =~ /^$name:alarm\./ || $e =~ /$name:disk.log/) {
            my $el = $Comp->value($e);
            if ($el->[0] > $alarm) {
                 $alarm = $el->[0]; $alarm_info = $el->[1];
            }
         }
     }

     $other = TO->val($l1->[0], $l2->[0], $l3->[0], $l4->[0])  . "," .
               $m1->[0] . "," .
              TO->val($p1->[0], $p2->[0], $p3->[0], $p4->[0]) . "," .
              TO->val($v1->[0], $v2->[0], $v3->[0], $v4->[0]) . "," . $alarm;

     $otherInfo = TO->val2(1,$l1, $l2, $l3, $l4)  . "," .
              $m1->[1] . "," .
              TO->val2(1,$p1, $p2, $p3, $p4) . "," .
              TO->val2(1,$v1, $v2, $v3, $v4) . "," . $alarm_info;

     return ($enc, $port, $disk, $other, $encInfo,
          $portInfo, $diskInfo, $otherInfo);
    
}



sub ipAddr {
  my($class) = @_;
  return $class->{info}{ipAddr};
}


sub getDiskList {
  my($node) = @_;
  my (@L, $x);
  my $ports = $node->{portInfo};
  for ($x=1; $x <= $node->diskTotal(); $x++) {
     push(@L, "disk.u1d$x");
  }
  if ($ports->[1]) {
    for ($x=1; $x <= $node->diskTotal(); $x++) {
      push(@L, "disk.u2d$x");
    }
  }
  return \@L;
}

sub iconLayout {
  my($obj) = @_;
  my ($cat, $label2, $ses);
  my $dt = $obj->diskTotal();
  my $t3 = uc($obj->type());
  my $t3l = $obj->type() || "t3";

  my $units = $obj->{info}{units};
  $units = 2 if (!$units && $obj->{info}{PG});

  if ($units > 1) {
     my ($dd, $x);
     for ($x=1; $x <= $units; $x++) {
        $dd .= "${x}d/";
     }
     chop($dd);
     $cat = "a,$t3,2/12,-$dt,$dd,LMPVA,Loop/Midplane/Power/Volumes/Alerts,D0D0F0/${t3l}pg.gif";
     $ses = 2;
  } else {
     $cat = "a,$t3,1/1,-$dt,1d,LMPVA,Loop/Midplane/Power/Volumes/Alerts,D0D0F0/$t3l.gif";
     $ses = 1;
  }
  $label2 = $obj->{info}{userLabel} || lc($t3);
  $ses    = 1;
  return ($cat, $label2, $ses);
}

sub getLogicalPaths{
  my($self) = @_;
  my $volinfo =$self->volInfo();
  my @paths;
  foreach my $path (keys %$volinfo){
    push(@paths, $path);
  }
  return @paths;
}

1;
