/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.inventory.StorEdge_6120Account;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayObject;
import com.sun.netstorage.array.mgmt.se6120.internal.CIMUtils;
import com.sun.netstorage.array.mgmt.se6120.internal.Constants;
import com.sun.netstorage.array.mgmt.se6120.internal.DevComm;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyBroker;
import com.sun.netstorage.array.mgmt.se6120.internal.RequestBroker;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdge_6120ArrayProvider;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public class ArrayInventory
implements Constants {
    private static ArrayList inventory = new ArrayList();
    private static ArrayInventory instance = new ArrayInventory();
    private static boolean initialized = false;

    private ArrayInventory() {
    }

    public static synchronized ArrayInventory getInstance() {
        return instance;
    }

    public synchronized ArrayObject getArrayObject(String hostIP) {
        Iterator invIter = inventory.iterator();
        ArrayObject ret = null;
        while (invIter.hasNext()) {
            ArrayObject tempObj = (ArrayObject)invIter.next();
            if (!tempObj.getHost().equals(hostIP)) continue;
            ret = tempObj;
        }
        return ret;
    }

    public ArrayList getArrayInventory() {
        return inventory;
    }

    public void removeInventoryMember(String hostIP) {
        this.removeInventoryMember(ArrayObject.getInstance(hostIP, "user", "pass"));
    }

    public synchronized void removeInventoryMember(ArrayObject ao) {
        if (inventory.contains(ao)) {
            inventory.remove(inventory.indexOf(ao));
            ArrayObject.removeArray(ao);
            RequestBroker.getInstance().removeArray(ao);
            ModifyBroker.getInstance();
            ModifyBroker.removeArray(ao);
        }
    }

    public synchronized void addInventoryMember(ArrayObject ao) {
        if (!inventory.contains(ao)) {
            inventory.add(ao);
            RequestBroker.getInstance().addArray(ao);
            DevComm.getInstance().init(instance.getArrayInventory());
            ModifyBroker.getInstance();
            ModifyBroker.addArray(ao);
        }
    }

    public synchronized void updateInventoryMember(ArrayObject ao) {
        if (inventory.contains(ao)) {
            inventory.set(inventory.indexOf(ao), ao);
            DevComm.getInstance().init(instance.getArrayInventory());
        }
    }

    public synchronized void init() {
        if (!initialized) {
            CIMObjectPath cop = new CIMObjectPath("StorEdge_6120Account", "\\root\\se6x20");
            try {
                StorEdge_6120Account sac = new StorEdge_6120Account();
                Vector vAcct = sac.enumerate("\\root\\se6x20", StorEdge_6120ArrayProvider.getCIMOMHandle());
                Enumeration enum1 = vAcct.elements();
                while (enum1.hasMoreElements()) {
                    CIMInstance inst = (CIMInstance)enum1.nextElement();
                    String IP = (String)CIMUtils.getPropertyValue(inst, "Name");
                    String pass = "";
                    Vector vPass = (Vector)CIMUtils.getPropertyValue(inst, "UserPassword");
                    if (null != vPass && vPass.size() > 0) {
                        pass = (String)vPass.elementAt(0);
                    }
                    if (null == IP) continue;
                    WBEMDebug.trace2((String)("creating " + IP));
                    instance.addInventoryMember(ArrayObject.getInstance(IP, "root", pass));
                }
            }
            catch (Exception ex) {
                WBEMDebug.trace1((String)"Could not create ArrayObject:", (Throwable)ex);
            }
            initialized = true;
        }
    }
}

