/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.RequestBroker;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdge_6120ArrayProvider;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

public class ArrayObject {
    private String host;
    private int port = 80;
    private String user;
    private String password;
    private String firwareVersion = "unknown";
    private boolean useCRAM = true;
    private boolean isAlive = true;
    private Thread refreshThread = null;
    private boolean keepRunning = true;
    private boolean cacheBeingUpdated = false;
    private boolean pauseRefresh = false;
    private static final int SLEEP_A_MINUTE = 60000;
    private static int DISCOVERY_INTERVAL_IN_MIN = 5;
    private static String DISCOVERY_INTERVAL_IN_MIN_KEY = "ArrayObject.discoveryIntervalInMin";
    private static HashMap instances = new HashMap();
    static final int FEATURE_DISK_SCRUBBING = 1;
    static final int FEATURE_PARALLEL_INIT = 2;
    static final int FEATURE_ARRAY_HOT_SPARE = 3;
    static final int FEATURE_BOOT_R = 4;
    private int major = 0;
    private int minor = 0;
    private int patch = 0;

    private ArrayObject() {
        try {
            FileInputStream propStream = new FileInputStream(StorEdge_6120ArrayProvider.getPropertyFilePath());
            Properties props = new Properties();
            props.load(propStream);
            DISCOVERY_INTERVAL_IN_MIN = Integer.parseInt(props.getProperty(DISCOVERY_INTERVAL_IN_MIN_KEY, new Integer(DISCOVERY_INTERVAL_IN_MIN).toString()));
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)"Unable to load properties!", (Throwable)e);
        }
    }

    public static ArrayObject getInstance(String host, String user, String pass) {
        ArrayObject ao = (ArrayObject)instances.get(host);
        if (null == ao) {
            ao = new ArrayObject();
            ao.host = host;
        }
        ao.user = user;
        ao.password = null == pass ? "" : pass;
        instances.put(ao.host, ao);
        return ao;
    }

    public static ArrayObject getInstance(String host, int port, String user, String pass) {
        ArrayObject ao = ArrayObject.getInstance(host, user, pass);
        ao.port = port;
        return ao;
    }

    public static void removeArray(ArrayObject ao) {
        instances.remove(ao.getHost());
    }

    public String getHost() {
        return this.host;
    }

    public String getHostName() {
        String hostName;
        block3: {
            hostName = this.host;
            String ipAddress = this.host;
            if (ipAddress == null) break block3;
            try {
                StringTokenizer ipTokenizer = new StringTokenizer(ipAddress, ".");
                byte[] ipByteArray = new byte[ipTokenizer.countTokens()];
                int i = 0;
                while (ipTokenizer.hasMoreTokens()) {
                    String ipToken = ipTokenizer.nextToken();
                    int ipValue = Integer.parseInt(ipToken);
                    ipByteArray[i] = (byte)ipValue;
                    ++i;
                }
                InetAddress inet = InetAddress.getByAddress(ipByteArray);
                hostName = inet.getHostName();
            }
            catch (Exception e) {
                WBEMDebug.trace2((String)(this + " could not get hostname "));
                hostName = this.host;
            }
        }
        return hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getCRAMFlag() {
        return this.useCRAM;
    }

    public void endRefreshThread() {
        this.keepRunning = false;
        if (null != this.refreshThread) {
            this.refreshThread.interrupt();
        }
    }

    public void cacheRefreshed() {
        if (null != this.refreshThread && !this.cacheBeingUpdated) {
            this.refreshThread.interrupt();
        }
    }

    public boolean equals(Object obj) {
        boolean ret = false;
        if (null != obj && obj instanceof ArrayObject) {
            ret = this.host.equals(((ArrayObject)obj).getHost());
        }
        return ret;
    }

    public int hashCode() {
        return this.host.hashCode();
    }

    void startRefreshThread() {
        if (null != this.refreshThread) {
            return;
        }
        this.refreshThread = new Thread(new Runnable(){

            public void run() {
                while (ArrayObject.this.keepRunning) {
                    try {
                        if (!ArrayObject.this.cacheBeingUpdated) {
                            WBEMDebug.trace2((String)(ArrayObject.this + " Cache expiring... "));
                            ArrayObject.this.cacheBeingUpdated = true;
                            RequestBroker.getInstance().invalidateCache(ArrayObject.this);
                        }
                        ArrayObject.this.cacheBeingUpdated = false;
                        try {
                            int i = 0;
                            while (i < DISCOVERY_INTERVAL_IN_MIN) {
                                WBEMDebug.trace2((String)(ArrayObject.this + " Refreshing in ... " + (DISCOVERY_INTERVAL_IN_MIN - i) * 60000 + " ms"));
                                Thread.sleep(60000L);
                                if (ArrayObject.this.pauseRefresh) continue;
                                ++i;
                            }
                        }
                        catch (InterruptedException iex) {
                            WBEMDebug.trace2((String)(ArrayObject.this + " Interrupted... "));
                            ArrayObject.this.cacheBeingUpdated = true;
                        }
                    }
                    catch (Exception ex) {
                        WBEMDebug.trace1((String)"", (Throwable)ex);
                    }
                }
            }
        });
        this.refreshThread.setName(this + " Refresh");
        this.refreshThread.setDaemon(true);
        this.refreshThread.start();
    }

    protected synchronized void pauseRefresh(boolean pause) {
        this.pauseRefresh = pause;
    }

    public boolean permitUpload() {
        return true;
    }

    public String toString() {
        return "ArrayObject:" + this.getHost();
    }

    protected void setFirmwareVersion(String firwareVersion) {
        this.major = 0;
        this.minor = 0;
        this.patch = 0;
        try {
            this.major = Integer.parseInt(firwareVersion.substring(0, 2));
            this.minor = Integer.parseInt(firwareVersion.substring(2, 4));
            this.patch = Integer.parseInt(firwareVersion.substring(4, 6));
        }
        catch (Exception ex) {
            WBEMDebug.trace2((String)("Could not parse firmware version for frimware version: " + firwareVersion), (Throwable)ex);
        }
        this.firwareVersion = firwareVersion;
    }

    protected String getFirwareVersion() {
        return this.firwareVersion;
    }

    public static boolean isFeatureSupported(int feature, int major, int minor, int patch) {
        boolean retVal = false;
        switch (feature) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (major <= 3 && (major != 3 || minor < 1)) break;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    public boolean isFeatureSupported(int feature) {
        return ArrayObject.isFeatureSupported(feature, this.major, this.minor, this.patch);
    }
}

