/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.ArrayException;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayInventory;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayObject;
import com.sun.netstorage.array.mgmt.se6120.internal.Constants;
import com.sun.netstorage.array.mgmt.se6120.internal.DevComm;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyModule;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.RequestBroker;
import com.sun.netstorage.array.mgmt.se6120.internal.SetRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdgeIOException;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.UnsignedInt16;

public class ModifyCluster
extends ModifyModule
implements Constants {
    private static String CLASSNAME = "ModifyCluster";
    public static final int CMDS_NUMBER = 3;
    private static final String[] classes = new String[]{"StorEdge_6120SystemSetting", "StorEdge_6120Cluster"};

    public void shutdown() {
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "handleRequest";
        boolean validClass = false;
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        String classname = request.getCIMClassName();
        int i = 0;
        while (i < classes.length) {
            if (classname.toLowerCase().equals(classes[i].toLowerCase())) {
                validClass = true;
                break;
            }
            ++i;
        }
        if (!validClass) {
            WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " not handling."));
            return false;
        }
        if (!(request instanceof SetRequest)) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        Properties props = ((SetRequest)request).getProperties();
        Vector<String> postv = new Vector<String>();
        String val = null;
        boolean refreshDone = false;
        if (classname.equalsIgnoreCase("StorEdge_6120Cluster")) {
            WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " handling Cluster."));
            val = props.getProperty("Caption");
            if (val != null) {
                postv.add("sysId=" + URLEncoder.encode(val));
                DevComm.getInstance().post(this.getSystem(), postv, "sysApplySettings");
                RequestBroker.getInstance().invalidateCache(this.getSystem());
                refreshDone = true;
            }
            boolean shutdown = false;
            boolean reset = false;
            boolean resetLabels = false;
            try {
                Vector status = (Vector)((SetRequest)request).getPropertyValue("OperationalStatus");
                if (status != null && status.size() > 0) {
                    Vector otherStatus;
                    int statusValue = ((UnsignedInt16)status.elementAt(0)).intValue();
                    if (statusValue == 15) {
                        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " OperationalStatus is Dormant."));
                        shutdown = true;
                    } else if (statusValue == 1 && (otherStatus = (Vector)((SetRequest)request).getPropertyValue("OtherStatusDescriptions")) != null && status.size() > 0) {
                        String otherStatusValue = (String)otherStatus.elementAt(0);
                        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " OperationalStatus is Other and " + "OtherStatusDescriptions value is: " + otherStatusValue));
                        if ("Rebooting".equals(otherStatusValue)) {
                            reset = true;
                        } else if ("Reseting Labels".equals(otherStatusValue)) {
                            resetLabels = true;
                        } else if ("Refresh".equals(otherStatusValue) && !refreshDone) {
                            RequestBroker.getInstance().invalidateCache(this.getSystem());
                            return true;
                        }
                    }
                }
            }
            catch (CIMException ex) {
                // empty catch block
            }
            if (shutdown) {
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " performing shutdown of Cluster."));
                RequestBroker.getInstance().setClusterOperationalStatus(this.getSystem(), 15, null);
                try {
                    DevComm.getInstance().post(this.getSystem(), new Vector(0), "sysShutdown");
                }
                catch (ArrayException ae) {
                    WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " caught and swallowed ArrayException: " + ae.getMessage()));
                }
            }
            if (reset) {
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " Performing the reset of the cluster."));
                try {
                    DevComm.getInstance().post(this.getSystem(), new Vector(0), "sysReset");
                }
                catch (ArrayException ae) {
                    WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " caught and swallowed ArrayException: " + ae.getMessage()));
                }
                RequestBroker.getInstance().setClusterOperationalStatus(this.getSystem(), 1, "Rebooting");
            }
            if (resetLabels) {
                String resetCommand = "boot -w";
                if (ArrayInventory.getInstance().getArrayObject(this.getSystem().getHost()).isFeatureSupported(4)) {
                    resetCommand = "boot -r";
                }
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " Performing command: " + resetCommand));
                String[] cmds = new String[3];
                String[] resp = new String[3];
                int[] timeouts = new int[3];
                resp[0] = ">";
                resp[1] = "are you sure?";
                resp[2] = ">";
                cmds[0] = "rm properties";
                cmds[1] = resetCommand;
                cmds[2] = "Y";
                timeouts[0] = 180;
                timeouts[1] = 200;
                timeouts[2] = 5;
                try {
                    DevComm.getInstance().telnetMultiPost(this.getSystem(), cmds, resp, new String[0], resp, timeouts);
                }
                catch (Exception ae) {
                    WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " caught and swallowed ArrayException: " + ae.getMessage()));
                }
                RequestBroker.getInstance().setClusterOperationalStatus(this.getSystem(), 1, "Reseting Labels");
            }
            return true;
        }
        if (classname.equalsIgnoreCase("StorEdge_6120SystemSetting")) {
            val = props.getProperty("SegmentSize");
            if (val != null) {
                postv.add("sysStripeUnitSize=" + val);
            }
            if ((val = props.getProperty("ReadAheadMode")) != null) {
                postv.add("sysReadAhead=" + val);
            }
            if ((val = props.getProperty("ReconRate")) != null) {
                postv.add("sysReconRate=" + val);
            }
            if ((val = props.getProperty("CacheMode")) != null) {
                postv.add("sysCacheMode=" + val);
            }
            if ((val = props.getProperty("FailoverMode")) != null) {
                postv.add("sysMpSupport=" + val);
            }
            if ((val = props.getProperty("DiskScrubber")) != null) {
                postv.add("sysDiskScrubber=" + val);
            }
            if ((val = props.getProperty("ONDGMode")) != null) {
                postv.add("sysOndgMode=" + val);
            }
            DevComm.getInstance().post(this.getSystem(), postv, "sysApplySettings");
            RequestBroker.getInstance().invalidateCache(this.getSystem());
            return true;
        }
        return false;
    }

    public ModifyCluster(ArrayObject array) {
        super(array);
    }
}

