/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.ArrayException;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayObject;
import com.sun.netstorage.array.mgmt.se6120.internal.DevComm;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyModule;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.SetRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdgeIOException;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;

public class ModifyTimeSettings
extends ModifyModule {
    public static final String CLASSNAME = "ModifyTimeSettings";
    public static final int NTP_CMDS_NUMBER = 2;

    public ModifyTimeSettings(ArrayObject system) {
        super(system);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String timeZoneName;
        SetRequest setRequest;
        block8: {
            String METHOD = "handleRequest";
            WBEMDebug.trace3((String)"ModifyTimeSettings.handleRequest entered");
            if (request == null) {
                WBEMDebug.trace2((String)"ModifyTimeSettings.handleRequest Null argument.");
                throw new CIMException("CIM_ERR_FAILED");
            }
            String classname = request.getCIMClassName();
            if (!classname.equalsIgnoreCase("StorEdge_6120OperatingSystem")) {
                WBEMDebug.trace2((String)"ModifyTimeSettings.handleRequest Not supported.");
                return false;
            }
            if (!(request instanceof SetRequest)) {
                WBEMDebug.trace2((String)"ModifyTimeSettings.handleRequest Not supported.");
                throw new CIMException("CIM_ERR_NOT_SUPPORTED");
            }
            setRequest = (SetRequest)request;
            String[] cmds = new String[2];
            String[] prompts = new String[2];
            String[] resp = new String[]{">", ">"};
            Boolean ntpEnabled = (Boolean)setRequest.getPropertyValue("NTPEnabled");
            if (ntpEnabled != null && ntpEnabled.booleanValue()) {
                WBEMDebug.trace3((String)"ModifyTimeSettings.handleRequest NTP time used.");
                String ntpIpAddr = (String)setRequest.getPropertyValue("NTPServerIpAddr");
                if (ntpIpAddr != null && ntpIpAddr.length() != 0) {
                    cmds[0] = "ntp server " + ntpIpAddr;
                    cmds[1] = "ntp poll unicast";
                    DevComm.getInstance().telnetMultiPost(this.getSystem(), cmds, resp, new String[0], prompts, new int[0]);
                    break block8;
                } else {
                    WBEMDebug.trace1((String)"ModifyTimeSettings.handleRequest NTP server IP not set.");
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
            }
            WBEMDebug.trace3((String)"ModifyTimeSettings.handleRequest Time set manually.");
            CIMDateTime dateTime = (CIMDateTime)setRequest.getPropertyValue("LocalDateTime");
            if (dateTime != null) {
                WBEMDebug.trace3((String)("ModifyTimeSettings.handleRequest CIMDateTime instance passed: " + dateTime));
                Date date = dateTime.getCalendar().getTime();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm.ss");
                String timeDateString = sdf.format(date);
                WBEMDebug.trace3((String)("ModifyTimeSettings.handleRequest Time/date we got: " + timeDateString));
                cmds[0] = "ntp poll off";
                cmds[1] = "date " + timeDateString;
                DevComm.getInstance().telnetMultiPost(this.getSystem(), cmds, resp, new String[0], prompts, new int[0]);
            }
        }
        if ((timeZoneName = (String)setRequest.getPropertyValue("TimeZoneName")) != null) {
            Vector<String> postv = new Vector<String>();
            postv.add("sysTimezone=" + timeZoneName);
            DevComm.getInstance().post(this.getSystem(), postv, "sysSetTimezone");
        }
        return true;
    }

    public void shutdown() {
    }
}

