/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.ArrayException;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayInventory;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayObject;
import com.sun.netstorage.array.mgmt.se6120.internal.CIMInstanceCache;
import com.sun.netstorage.array.mgmt.se6120.internal.CIMUtils;
import com.sun.netstorage.array.mgmt.se6120.internal.CacheAddr;
import com.sun.netstorage.array.mgmt.se6120.internal.Constants;
import com.sun.netstorage.array.mgmt.se6120.internal.DevComm;
import com.sun.netstorage.array.mgmt.se6120.internal.InstanceFormer;
import com.sun.netstorage.array.mgmt.se6120.internal.ObjectPath;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdgeIOException;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdge_6120ArrayProvider;
import com.sun.netstorage.array.mgmt.se6120.internal.Uploader;
import com.sun.netstorage.array.mgmt.util.StorEdge_AssociationProvider;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;

public class RequestBroker
extends StorEdge_AssociationProvider
implements Constants {
    private static CIMInstanceCache devCache = new CIMInstanceCache();
    private static Map synCache = Collections.synchronizedMap(new HashMap());
    private static final String FILENAME = "dataFile";
    private static final String LMD_FILENAME = "lmdataFile";
    private static final String TREEDATA_FILENAME = "navTreeFile";
    private static String fileName = "cim.htm";
    private static String lunMaskDataFileName = "lunmaskdata.htm";
    private static String treeDataFileName = "treedata.htm";
    private static final String OS_FILENAME = "osInfoFile";
    private String osFileName = "osinfo.htm";
    private static RequestBroker singleton = new RequestBroker();
    private static boolean initialized = false;
    public static final String TREE_DATA_FILE = "/opt/se6x20/t4files/treedata.htm";
    public static final String LM_DATA_FILE = "/opt/se6x20/t4files/lunmaskdata.htm";
    public static final String T4_DATA_FILE = "/opt/se6x20/t4files/cim.htm";
    private static final String CLASSNAME = "RequestBroker";

    private RequestBroker() {
        try {
            FileInputStream propStream = new FileInputStream(StorEdge_6120ArrayProvider.getPropertyFilePath());
            Properties props = new Properties();
            props.load(propStream);
            treeDataFileName = props.getProperty(TREEDATA_FILENAME, treeDataFileName);
            lunMaskDataFileName = props.getProperty(LMD_FILENAME, "lunmaskdata.htm");
            fileName = props.getProperty(FILENAME, fileName);
            this.osFileName = props.getProperty(OS_FILENAME, this.osFileName);
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)"RequestBroker Unable to load properties!", (Throwable)e);
        }
    }

    public String getClassName() {
        return "StorEdge_6x20ArrayProvider";
    }

    public void invalidateCache(ArrayObject device) {
        if (null != device) {
            WBEMDebug.trace2((String)("Invalidating cache for: " + device));
            device.cacheRefreshed();
            RequestBroker.getDeviceInstances(device);
        }
    }

    public static RequestBroker getInstance() {
        return singleton;
    }

    void addArray(ArrayObject ao) {
        CIMInstance cluster = RequestBroker.getClusterInstance(ao);
        if (null == cluster) {
            cluster = RequestBroker.createCluster(ao, 8, null);
            devCache.addArray(ao, cluster);
            ao.startRefreshThread();
        }
    }

    void removeArray(ArrayObject ao) {
        devCache.removeArray(ao);
        ao.endRefreshThread();
    }

    public static boolean hasVirtualControllers(ArrayObject ao) {
        boolean result = false;
        CIMInstance[] cntrls = devCache.enumerate(ao, "StorEdge_6120ControllerSystem");
        if (null != cntrls) {
            int i = 0;
            while (i < cntrls.length) {
                Vector v = (Vector)CIMUtils.getPropertyValue(cntrls[i], "OtherStatusDescriptions");
                if (null != v) {
                    Iterator it = v.iterator();
                    while (it.hasNext()) {
                        String tmpStr = (String)it.next();
                        if (tmpStr.indexOf("notInstalled") <= -1) continue;
                        result = true;
                        break;
                    }
                    if (result) break;
                }
                ++i;
            }
        }
        return result;
    }

    protected static CIMInstanceCache getCIMInstanceCache(ArrayObject ao) throws Exception {
        CIMInstanceCache newCache;
        block6: {
            ArrayList deviceInstances = new ArrayList();
            newCache = new CIMInstanceCache();
            InputStream inStream = null;
            try {
                WBEMDebug.trace2((String)("ABOUT TO READ DEV :" + fileName));
                inStream = DevComm.getInstance().get(ao, fileName);
                deviceInstances.addAll(InstanceFormer.parseXml(inStream));
                WBEMDebug.trace2((String)("DONE READING DEV inst count: " + deviceInstances.size()));
                CIMInstance[] cims = null;
                try {
                    cims = deviceInstances.toArray(new CIMInstance[0]);
                    newCache.addArrayWithInstances(ao, cims);
                }
                catch (ClassCastException e) {
                    WBEMDebug.trace1((String)"Can not get CIMInstances.", (Throwable)e);
                }
            }
            catch (Exception ex) {
                if (inStream == null) break block6;
                try {
                    inStream.close();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                throw ex;
            }
        }
        return newCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static List getDeviceInstances(ArrayObject ao) {
        ArrayList<CIMInstance> deviceInstances;
        block39: {
            deviceInstances = new ArrayList<CIMInstance>();
            boolean retry = false;
            try {
                CIMInstance cluster = RequestBroker.getClusterInstance(ao);
                if (null == cluster) {
                    cluster = RequestBroker.createCluster(ao, 12, null);
                    deviceInstances.add(cluster);
                    devCache.addArray(ao, cluster);
                    break block39;
                }
                do {
                    InputStream inStream = null;
                    WBEMDebug.trace2((String)("ABOUT TO READ DEV :" + fileName));
                    inStream = DevComm.getInstance().get(ao, fileName);
                    deviceInstances.addAll(InstanceFormer.parseXml(inStream));
                    WBEMDebug.trace2((String)("DONE READING DEV inst count: " + deviceInstances.size()));
                    CIMInstance[] cims = null;
                    try {
                        cims = deviceInstances.toArray(new CIMInstance[0]);
                        if (ArrayInventory.getInstance().getArrayObject(ao.getHost()) != null) {
                            devCache.addArrayWithInstances(ao, cims);
                        }
                    }
                    catch (ClassCastException e) {
                        WBEMDebug.trace1((String)"Can not get CIMInstances.", (Throwable)e);
                    }
                    retry = false;
                    Object var12_19 = null;
                    if (inStream == null) continue;
                    try {
                        inStream.close();
                    }
                    catch (IOException ignore) {}
                    continue;
                    {
                        Vector v;
                        catch (StorEdgeIOException ex) {
                            WBEMDebug.trace3((String)("IOException communicating to T4: " + ex.getMessage()));
                            int code = ex.getType();
                            if (code == 0) {
                                deviceInstances.clear();
                                v = (Vector)CIMUtils.getPropertyValue(cluster, "OperationalStatus");
                                boolean lostComm = false;
                                boolean modify = true;
                                if (null != v) {
                                    UnsignedInt16 status = (UnsignedInt16)v.elementAt(0);
                                    if (null != status && (status.intValue() == 2 || status.intValue() == 13)) {
                                        lostComm = true;
                                    } else if (null != status && (status.intValue() == 11 || status.intValue() == 15 || status.intValue() == 1)) {
                                        WBEMDebug.trace2((String)("new status = " + status.intValue()));
                                        modify = false;
                                    }
                                }
                                if (modify) {
                                    if (lostComm) {
                                        deviceInstances.add(RequestBroker.modifyCluster(cluster, 13, null));
                                    } else {
                                        deviceInstances.add(RequestBroker.modifyCluster(cluster, 12, null));
                                    }
                                }
                            } else if (code == 2) {
                                deviceInstances.add(RequestBroker.modifyCluster(cluster, 11, null));
                            } else if (code == 1) {
                                if (!ao.permitUpload()) {
                                    deviceInstances.add(RequestBroker.modifyCluster(cluster, 16, null));
                                    var12_19 = null;
                                    if (inStream == null) break;
                                    try {
                                        inStream.close();
                                    }
                                    catch (IOException ignore) {}
                                    break;
                                }
                                try {
                                    FileInputStream lunmaskdatafile = new FileInputStream(LM_DATA_FILE);
                                    FileInputStream treedatafile = new FileInputStream(TREE_DATA_FILE);
                                    FileInputStream file = new FileInputStream(T4_DATA_FILE);
                                    if (file != null) {
                                        Uploader.upload(ao, lunmaskdatafile, lunMaskDataFileName);
                                        Uploader.upload(ao, treedatafile, treeDataFileName);
                                        Uploader.upload(ao, file, fileName);
                                    } else {
                                        WBEMDebug.trace1((String)"Unable to find local data file while trying to upload.");
                                    }
                                    if (retry) {
                                        deviceInstances.add(RequestBroker.modifyCluster(cluster, 16, null));
                                        retry = false;
                                    } else {
                                        retry = true;
                                    }
                                }
                                catch (IOException ioe) {
                                    WBEMDebug.trace1((String)"Failure uploading latest data file: ", (Throwable)ioe);
                                    deviceInstances.add(RequestBroker.modifyCluster(cluster, 16, null));
                                }
                            }
                            var12_19 = null;
                            if (inStream == null) continue;
                            try {
                                inStream.close();
                            }
                            catch (IOException ignore) {}
                            continue;
                        }
                        catch (Exception e) {
                            UnsignedInt16 status;
                            v = (Vector)CIMUtils.getPropertyValue(cluster, "OperationalStatus");
                            if (null != v && (null == (status = (UnsignedInt16)v.elementAt(0)) || null != status && status.intValue() != 15)) {
                                WBEMDebug.trace1((String)"Could not fetching T4 Data", (Throwable)e);
                                deviceInstances.add(RequestBroker.modifyCluster(cluster, 12, null));
                            }
                            var12_19 = null;
                            if (inStream == null) continue;
                            try {
                                inStream.close();
                            }
                            catch (IOException ignore) {}
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var12_19 = null;
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException ignore) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                } while (retry);
            }
            catch (Exception ex) {
                WBEMDebug.trace1((String)"", (Throwable)ex);
            }
        }
        return deviceInstances;
    }

    private static CIMInstance createCluster(ArrayObject ao, int status, String otherStatDesc) {
        CIMObjectPath cop = new CIMObjectPath("StorEdge_6120Cluster", "\\root\\se6x20");
        CIMInstance cluster = null;
        try {
            CIMClass clusterClass = StorEdge_6120ArrayProvider.getCIMOMHandle().getClass(cop, false, true, true, null);
            cluster = clusterClass.newInstance();
            cluster.setProperty("Name", new CIMValue((Object)ao.getHost()));
            cluster = RequestBroker.modifyCluster(cluster, status, otherStatDesc);
        }
        catch (Exception ex) {
            WBEMDebug.trace1((String)"", (Throwable)ex);
        }
        return cluster;
    }

    private static CIMInstance modifyCluster(CIMInstance cluster, int status, String otherStatDesc) {
        Vector<Object> data = new Vector<Object>();
        data.add(new UnsignedInt16(status));
        CIMValue val = new CIMValue(data, new CIMDataType(16));
        cluster.setProperty("OperationalStatus", val);
        if (null != otherStatDesc) {
            data = new Vector();
            data.add(otherStatDesc);
            cluster.setProperty("OtherStatusDescriptions", new CIMValue(data, new CIMDataType(22)));
        }
        return cluster;
    }

    void setClusterOperationalStatus(ArrayObject ao, int status, String otherStatDesc) throws ArrayException {
        if (status != 15 && status != 11 && status != 1) {
            throw new ArrayException("Invalid OperationalStatus");
        }
        CIMInstance cluster = RequestBroker.createCluster(ao, status, otherStatDesc);
        devCache.addArray(ao, cluster);
    }

    private static CIMInstance getClusterInstance(ArrayObject ao) {
        CIMInstance[] tlos = devCache.enumerate(ao, "StorEdge_6120Cluster");
        if (tlos == null || tlos.length == 0) {
            return null;
        }
        return tlos[0];
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        return this.enumerateInstanceNames(null, op, cc);
    }

    CIMObjectPath[] enumerateInstanceNames(String device, CIMObjectPath op, CIMClass cc) throws CIMException {
        return this.convertInstToObjectPath(this.enumerateInstances(device, op, false, true, false, null, cc));
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifier, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        return this.enumerateInstances((ArrayObject)null, op, localOnly, includeQualifier, includeClassOrigin, propertyList, cc);
    }

    CIMInstance[] enumerateInstances(String device, CIMObjectPath op, boolean localOnly, boolean includeQualifier, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        return this.enumerateInstances(ArrayInventory.getInstance().getArrayObject(device), op, localOnly, includeQualifier, includeClassOrigin, propertyList, cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CIMInstance[] enumerateInstances(ArrayObject device, CIMObjectPath op, boolean localOnly, boolean includeQualifier, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        String METHOD = "enumerateInstances";
        ArrayList<Object> ret = null;
        if (op != null && "StorEdge_6120OperatingSystem".equals(op.getObjectName())) {
            ret = new ArrayList();
            if (device == null) {
                ArrayList allArrays = ArrayInventory.getInstance().getArrayInventory();
                Iterator iter = allArrays.iterator();
                while (iter.hasNext()) {
                    ArrayObject array = (ArrayObject)iter.next();
                    ret.addAll(this.refreshOperatingSystemInstance(array));
                    WBEMDebug.trace3((String)("RequestBroker.enumerateInstances: Refreshed OperatingSystem instance for the array: " + array.getHost()));
                }
            } else {
                ret = this.refreshOperatingSystemInstance(device);
                WBEMDebug.trace3((String)("RequestBroker.enumerateInstances: Refreshed OperatingSystem instance for the array: " + device.getHost()));
            }
        } else {
            CIMInstance[] cims = devCache.enumerate(device, op);
            ret = null != cims ? new ArrayList<CIMInstance>(Arrays.asList(cims)) : new ArrayList();
            Map map = synCache;
            synchronized (map) {
                Iterator synIT = synCache.values().iterator();
                while (synIT.hasNext()) {
                    CIMInstance inst = (CIMInstance)synIT.next();
                    if (!inst.getClassName().equals(op.getObjectName())) continue;
                    ret.add(inst);
                }
            }
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret.toArray(new CIMInstance[0]);
    }

    public String getHostName(CIMObjectPath op) {
        CacheAddr addr = devCache.getCacheAddr(op);
        if (addr == null || addr.getArray() == null) {
            return null;
        }
        return addr.getArray().getHost();
    }

    protected void addInstance(CIMInstance inst) {
        CacheAddr addr = devCache.getCacheAddr(inst.getObjectPath());
        if (addr == null || addr.getArray() == null) {
            return;
        }
        devCache.add(addr.getArray(), inst);
    }

    void addSyntheticCacheInstance(CIMInstance inst) {
        CIMObjectPath op = inst.getObjectPath();
        synCache.put(new ObjectPath(op), inst);
    }

    Object deleteSyntheticCacheInstance(CIMObjectPath op) {
        return synCache.remove(new ObjectPath(op));
    }

    CIMInstance getCacheInstance(CIMObjectPath op) {
        return this.findInstance(op);
    }

    boolean isSyntheticCacheInstance(CIMObjectPath op) {
        return synCache.containsKey(new ObjectPath(op));
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifier, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        CIMInstance inst = this.findInstance(op);
        if (null != inst) {
            inst = this.filterProperties(inst, propertyList, localOnly, includeQualifier, includeClassOrigin);
        }
        return inst;
    }

    CIMInstance filterProperties(CIMInstance inst, String[] propertyList, boolean localOnly, boolean includeQualifier, boolean includeClassOrigin) {
        if (localOnly) {
            inst = inst.localElements();
        }
        return inst.filterProperties(propertyList, includeQualifier, includeClassOrigin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CIMInstance getInstanceFromSynCache(CIMObjectPath op) {
        CIMInstance ci = null;
        Map map = synCache;
        synchronized (map) {
            Iterator synIT = synCache.values().iterator();
            while (synIT.hasNext()) {
                CIMInstance inst = (CIMInstance)synIT.next();
                if (!ObjectPath.objectPathsAreEqual(op, inst.getObjectPath())) continue;
                ci = inst;
                break;
            }
        }
        return ci;
    }

    CIMInstance findInstance(CIMObjectPath op) {
        String METHOD = "findInstance";
        CIMInstance ci = null;
        if (op != null && "StorEdge_6120OperatingSystem".equals(op.getObjectName())) {
            Vector keys = op.getKeys();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                CIMProperty key = (CIMProperty)iter.next();
                if (!"CSName".equals(key.getName()) || key.getValue() == null) continue;
                String device = (String)key.getValue().getValue();
                ArrayList osInstances = this.refreshOperatingSystemInstance(ArrayInventory.getInstance().getArrayObject(device));
                WBEMDebug.trace3((String)("RequestBroker.findInstance: Refreshed OperatingSystem instance for the array: " + device));
                if (!osInstances.isEmpty()) {
                    ci = (CIMInstance)osInstances.get(0);
                }
                break;
            }
        } else {
            ci = (CIMInstance)synCache.get(new ObjectPath(op));
            if (null == ci) {
                ci = devCache.find(op);
            }
        }
        return ci;
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        if (this.isSyntheticCacheInstance(op)) {
            this.deleteSyntheticCacheInstance(op);
            return;
        }
        devCache.remove(op);
    }

    public CIMInstance[] references(CIMObjectPath assocName, CIMObjectPath objectName, String role, boolean includeQualifier, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        ArrayList<CIMInstance> ret = new ArrayList<CIMInstance>();
        CIMInstance[] inst = this.enumerateInstances(assocName, false, true, false, null, null);
        if (null != inst && inst.length > 0) {
            int i = 0;
            while (i < inst.length) {
                if (null != inst[i]) {
                    Vector props = inst[i].getProperties();
                    Enumeration enum1 = props.elements();
                    while (enum1.hasMoreElements()) {
                        CIMObjectPath pop;
                        CIMProperty p = (CIMProperty)enum1.nextElement();
                        if (!p.isReference() || !ObjectPath.objectPathsAreEqual(pop = (CIMObjectPath)p.getValue().getValue(), objectName)) continue;
                        ret.add(inst[i].filterProperties(propertyList, includeQualifier, includeClassOrigin));
                    }
                }
                ++i;
            }
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret.toArray(new CIMInstance[0]);
    }

    private CIMObjectPath[] convertInstToObjectPath(CIMInstance[] inst) {
        ArrayList<CIMObjectPath> ret = new ArrayList<CIMObjectPath>();
        if (null != inst) {
            int i = 0;
            while (i < inst.length) {
                ret.add(inst[i].getObjectPath());
                ++i;
            }
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret.toArray(new CIMObjectPath[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private ArrayList refreshOperatingSystemInstance(ArrayObject array) {
        block20: {
            METHOD = "refreshOperatingSystemInstance";
            osList = null;
            inStream = null;
            try {
                inStream = DevComm.getInstance().get(array, this.osFileName);
                osList = (ArrayList)InstanceFormer.parseXml(inStream);
                var8_5 = null;
                ** if (inStream == null) goto lbl-1000
            }
            catch (Throwable var7_17) {
                var8_8 = null;
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                throw var7_17;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    inStream.close();
                }
                catch (IOException ignore) {}
            }
lbl-1000:
            // 2 sources

            {
                break block20;
                catch (StorEdgeIOException ioex) {
                    WBEMDebug.trace1((String)("RequestBroker.refreshOperatingSystemInstance: StorEdgeIOException" + ioex.getMessage()), (Throwable)ioex);
                    if (ioex.getType() == 1 && array.permitUpload()) {
                        try {
                            file = new FileInputStream("/opt/se6x20/t4files/osinfo.htm");
                            if (file != null) {
                                Uploader.upload(array, file, this.osFileName);
                                inStream = DevComm.getInstance().get(array, this.osFileName);
                                osList = (ArrayList)InstanceFormer.parseXml(inStream);
                            } else {
                                WBEMDebug.trace1((String)"Unable to find osinfo.htm file to upload.");
                            }
                        }
                        catch (Exception ex) {
                            WBEMDebug.trace1((String)("RequestBroker.refreshOperatingSystemInstance: ERROR: Uploading " + this.osFileName), (Throwable)ex);
                        }
                    }
                    var8_6 = null;
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException ignore) {}
                    }
                    break block20;
                }
                catch (Exception ex) {
                    WBEMDebug.trace1((String)("RequestBroker.refreshOperatingSystemInstance: ERROR: Error retrieving " + this.osFileName));
                    var8_7 = null;
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            }
        }
        if (osList == null) {
            WBEMDebug.trace1((String)"RequestBroker.refreshOperatingSystemInstance: ERROR: Discovery returned no OperatingSystem object.");
            osList = new ArrayList();
        }
        return osList;
    }
}

