/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.InteractiveSessionConsole;
import com.sun.netstorage.array.mgmt.se6120.internal.InteractiveSessionException;
import com.sun.netstorage.array.mgmt.se6120.internal.InteractiveSessionPrtl;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class TelnetSession
extends InteractiveSessionPrtl {
    private static String CLASSNAME = "TelnetSession";
    private static final String COMMAND = "/usr/bin/telnet";
    private static final String PATTERN_LOGIN = "ogin:";
    private static final String PATTERN_LOGIN_INFO = "Sun Microsystems";
    private static final String PATTERN_PASSWORD = "Password";
    private static final int INPUTBUFFERSIZE = 32000;
    private Process process = null;
    private InteractiveSessionConsole interactiveSessionProcess = null;
    private Runtime runtime = null;
    String[] rmCmd = new String[3];

    public void connect(String host, String username, String password) throws InteractiveSessionException {
        String METHOD = "connect";
        this.rmCmd[0] = COMMAND;
        this.rmCmd[1] = "-r";
        this.rmCmd[2] = host;
        WBEMDebug.trace3((String)(CLASSNAME + "." + "connect" + ": " + "Command: \"" + this.rmCmd[0] + "\", " + "Command options: \"" + this.rmCmd[1] + "\", " + "Host: \"" + this.rmCmd[2] + "\", " + "Username: \"" + username + "\""));
        try {
            this.runtime = Runtime.getRuntime();
            this.process = this.runtime.exec(this.rmCmd);
            this.setStdInputReader(new BufferedReader(new InputStreamReader(this.process.getInputStream()), 32000));
            this.setStdErrorReader(new BufferedReader(new InputStreamReader(this.process.getErrorStream()), 32000));
            this.setOutPutStreamWriter(new OutputStreamWriter(this.process.getOutputStream()));
            this.setArrayOutputStream(new ByteArrayOutputStream());
            this.setSessionArrayOutputStream(new ByteArrayOutputStream());
            this.interactiveSessionProcess = new InteractiveSessionConsole(this);
            this.interactiveSessionProcess.start();
            if (!this.waitfor(PATTERN_LOGIN, 15000)) {
                throw new InteractiveSessionException("Cannot establish connection to \"" + host + "\". Verify that \"" + host + "\" is accessible within your network environment.");
            }
            if (!this.expectedResponse(username + "\r", PATTERN_PASSWORD, 15000)) {
                throw new InteractiveSessionException("Cannot establish connection to \"" + host + "\"" + " Was not prompted for password.");
            }
            this.send(password + "\r", 5000);
        }
        catch (Exception e) {
            this.cleanup();
            throw new InteractiveSessionException(e.getMessage());
        }
    }

    public void disconnect() throws InteractiveSessionException {
        this.disconnect(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(boolean sendExit) throws InteractiveSessionException {
        try {
            this.waitfor(5000);
            if (sendExit) {
                this.send("exit\r", 1000);
            }
            Object var3_2 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.cleanup();
            throw throwable;
        }
    }

    private void cleanup() {
        this.setTerminateStatus();
        if (this.interactiveSessionProcess != null) {
            try {
                this.interactiveSessionProcess.join(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.interactiveSessionProcess.isAlive()) {
            this.interactiveSessionProcess.interrupt();
        }
        System.gc();
        this.setStdInputReader(null);
        this.setStdErrorReader(null);
        this.setOutPutStreamWriter(null);
        if (this.process != null) {
            this.process.destroy();
        }
        if (this.runtime != null) {
            this.runtime.gc();
        }
    }
}

