/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.client;

import com.sun.net.ssl.HostnameVerifier;
import com.sun.net.ssl.HttpsURLConnection;
import com.sun.net.ssl.internal.ssl.Provider;
import com.sun.netstorage.array.mgmt.cfg.cli.client.CLIProxy;
import com.sun.netstorage.array.mgmt.cfg.cli.client.Encoder;
import com.sun.netstorage.array.mgmt.cfg.cli.client.ProxyServer;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Security;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.Call;

public class ProxyServerThread
extends Thread {
    public static final String DEFAULT_VERSION = "2.1.0";
    public static final int DEFAULT_RETRIES = 10;
    public static final String SUCCESS_CODE = "0";
    public static final String ERROR_CODE = "100";
    public static final String LOGIN_NAME = "777";
    public static final String LOGIN_CODE = "888";
    public static final String MODIFY_PASSWORD_CODE = "999";
    private static final String SOAP_SECURE_PROTOCOL = "https";
    private static final String SOAP_OPEN_PROTOCOL = "http";
    private static final String SOAP_SECURE_PORT_MR = "9443";
    private static final String SOAP_OPEN_PORT_MR = "9080";
    private static final String SOAP_URI_MR = "se6000ui/servlet/rpcrouter";
    private static final String SOAP_SECURE_PORT_E = "6789";
    private static final String SOAP_OPEN_PORT_E = "9080";
    private static final String SOAP_URI_E = "se6920ui/servlet/rpcrouter";
    private String soapProtocol = "https";
    private String soapPort = "6789";
    private Call callObject = null;
    private byte[] token;
    private int serverPort;
    private Date lastConnection = new Date();
    private boolean stop = false;
    private boolean shutDown = false;
    private boolean isSecure = true;
    private CLIProxy cli = null;
    private String soapServer = "localhost";
    private boolean userLoggedIn = false;
    private static ResourceBundle resource = ResourceBundle.getBundle("com.sun.netstorage.array.mgmt.cfg.cli.ini.CLIResource", Locale.getDefault());
    private static int SERVER_TYPE_UNKNOWN = -1;
    private static int SERVER_TYPE_MR = 1;
    private static int SERVER_TYPE_ENT = 2;
    private int _serverType = SERVER_TYPE_UNKNOWN;

    public ProxyServerThread(byte[] token, int port) {
        Trace.constructor(this);
        this.token = token;
        this.serverPort = port;
        Trace.verbose((Object)this, "constructor", "token is " + new String(token));
        Trace.verbose((Object)this, "constructor", "port is " + port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String METHOD_NAME = "run";
        String request = "";
        Trace.methodBegin(this, "run");
        try {
            this.setupKeystore();
            ServerSocket server = new ServerSocket(this.getServerPort());
            ProxyServer.setConnected(true);
            this.callObject = new Call();
            while (!this.shutDown) {
                Object var10_13;
                Socket client = null;
                DataInputStream in = null;
                DataOutputStream out = null;
                CommandResult cr = new CommandResult();
                try {
                    block12: {
                        try {
                            Trace.verbose((Object)this, "run", "Waiting for connection");
                            client = server.accept();
                            out = new DataOutputStream(client.getOutputStream());
                            if (this.isLocal(client)) {
                                ProxyServer.setLastConnection(new Date());
                                Trace.verbose((Object)this, "run", "Client connected.");
                                in = new DataInputStream(client.getInputStream());
                                try {
                                    cr = this.processRequest(in, out);
                                }
                                catch (Exception cle) {
                                    cr.setErrorId(ERROR_CODE);
                                    cr.setResult(resource.getString("error.general.systemError"));
                                }
                                if (this.shutDown) {
                                    Trace.verbose((Object)this, "run", "SHUTTING DOWN");
                                }
                                this.fixNewLine(cr);
                                Trace.verbose((Object)this, "run", " return info is:\n  " + cr.getResult());
                                this.writeOutput(cr.getErrorId(), out, this.token);
                                this.writeOutput(cr.getResult(), out, this.token);
                                break block12;
                            }
                            this.remoteConnect(client, out, cr);
                        }
                        catch (IOException ioe) {
                            this.processIOEx(ioe);
                            var10_13 = null;
                            this.closeSockets(client, in, out);
                        }
                    }
                    var10_13 = null;
                    this.closeSockets(client, in, out);
                }
                catch (Throwable throwable) {
                    var10_13 = null;
                    this.closeSockets(client, in, out);
                    throw throwable;
                }
                Trace.verbose((Object)this, "run", " Shutdown value is " + this.shutDown);
            }
            ProxyServer.setStop(true);
        }
        catch (BindException mre) {
            Trace.verbose((Object)this, "run", " Couldn't bind to selected port " + this.getServerPort());
            ProxyServer.setStop(true);
        }
        catch (IOException ioe) {
            Trace.verbose((Object)this, "Problem starting server", (Throwable)ioe);
        }
        Trace.verbose((Object)this, "run", "Method end.");
    }

    private void setupKeystore() {
        String keyStore = System.getProperty("KEYSTORE");
        if (null != keyStore) {
            Trace.verbose((Object)this, "setupKeystore", "Using Keystore (" + keyStore + ")");
            System.setProperty("javax.net.ssl.trustStore", keyStore);
            System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
            Security.addProvider((java.security.Provider)new Provider());
        } else {
            Trace.verbose((Object)this, "setupKeystore", "Keystore not specified");
        }
    }

    public void closeSockets(Socket client, DataInputStream in, DataOutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        try {
            if (client != null) {
                client.close();
            }
        }
        catch (IOException ioe) {}
    }

    public void processIOEx(IOException ioe) {
        if (ioe instanceof InterruptedIOException) {
            Trace.verbose((Object)this, "processIOEx", "server timed out on the port" + this.getServerPort());
            this.shutDown = true;
        } else {
            Trace.verbose((Object)this, "processIOEx", "Problem with accepting connection from client.");
        }
    }

    public void remoteConnect(Socket client, DataOutputStream out, CommandResult cr) throws IOException {
        Trace.verbose((Object)this, "remoteConnect", "Attempted Connection From Non Local Host" + client.getInetAddress().getAddress());
        cr.setErrorId(ERROR_CODE);
        cr.setResult(resource.getString("error.remote.proxy.connection") + client.getInetAddress().getAddress());
        this.writeOutput(cr.getErrorId(), out, this.token);
        this.writeOutput(cr.getResult(), out, this.token);
    }

    private CommandResult processRequest(DataInputStream in, DataOutputStream out) throws Exception, IOException {
        CommandResult cr;
        block6: {
            cr = new CommandResult();
            String request = this.readInput(in, this.token);
            if (request == null) break block6;
            try {
                if (request.indexOf("login") >= 0) {
                    cr = this.login(request, in, out);
                    break block6;
                }
                if (this.userLoggedIn && "logout".equals(request.trim())) {
                    cr = this.logout(request, in, out);
                    break block6;
                }
                if (this.userLoggedIn) {
                    cr = this.processCommand(request, in, out);
                    break block6;
                }
                cr.setResult(resource.getString("login.notLoggedIn"));
                cr.setErrorId(ERROR_CODE);
            }
            catch (SOAPException se) {
                cr.setErrorId(ERROR_CODE);
                cr.setResult(resource.getString("login.unableToConnect") + this.soapServer);
            }
            catch (Exception e) {
                cr.setResult(resource.getString("error.systemError"));
                cr.setErrorId(ERROR_CODE);
            }
        }
        return cr;
    }

    private CommandResult login(String request, DataInputStream in, DataOutputStream out) throws SOAPException, Exception {
        CommandResult result = null;
        StringTokenizer tokenizer = new StringTokenizer(request, "\n");
        boolean dashHOptionFound = false;
        boolean dashHOptionArgumentFound = false;
        while (tokenizer.hasMoreTokens()) {
            String arg = tokenizer.nextToken();
            if (!arg.equals("-h") && !arg.equals("--hostname")) continue;
            dashHOptionFound = true;
            if (!tokenizer.hasMoreTokens()) continue;
            this.soapServer = tokenizer.nextToken();
            dashHOptionArgumentFound = true;
            break;
        }
        if (!dashHOptionFound || !dashHOptionArgumentFound) {
            result = new CommandResult();
            result.setErrorId(ERROR_CODE);
            result.setResult(resource.getString("login.usage"));
            return result;
        }
        request = request + "--sscsversion\n" + this.getSoapProperty("sscs.version", DEFAULT_VERSION);
        this.chooseOpenOrSecurePort(request);
        this.resetServerType();
        ConnectionThread enterpriseThread = new ConnectionThread(this.getEnterpriseSoapUrl(), SERVER_TYPE_ENT);
        ConnectionThread midrangeThread = new ConnectionThread(this.getMidrangeSoapUrl(), SERVER_TYPE_MR);
        enterpriseThread.start();
        midrangeThread.start();
        int type = this.getServerType();
        enterpriseThread.stop();
        midrangeThread.stop();
        if (type == SERVER_TYPE_ENT) {
            this.reInitSession(this.getEnterpriseSoapUrl());
        } else {
            this.reInitSession(this.getMidrangeSoapUrl());
        }
        result = this.processCommand(request, in, out);
        this.userLoggedIn = SUCCESS_CODE.equals(result.getErrorId());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommandResult processGetUrl(String url, String request, DataInputStream in, DataOutputStream out) throws Exception {
        StringBuffer contents;
        block18: {
            int bytesRead;
            byte[] buf;
            boolean done;
            block16: {
                CommandResult result = new CommandResult();
                contents = null;
                InputStream is = null;
                try {
                    Object var13_14;
                    try {
                        URL theUrl = new URL(url);
                        is = theUrl.openStream();
                        contents = new StringBuffer();
                        done = false;
                        while (!done) {
                            buf = new byte[1024];
                            bytesRead = is.read(buf);
                            if (bytesRead == -1) {
                                done = true;
                                break;
                            }
                            contents.append(new String(buf));
                        }
                    }
                    catch (Exception e) {
                        var13_14 = null;
                        if (is != null) {
                            is.close();
                        }
                        break block16;
                    }
                    var13_14 = null;
                    if (is == null) break block16;
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
            }
            if (contents == null) {
                FileInputStream fis = null;
                try {
                    try {
                        fis = new FileInputStream(url);
                        contents = new StringBuffer();
                        done = false;
                        while (!done) {
                            buf = new byte[1024];
                            bytesRead = fis.read(buf);
                            if (bytesRead == -1) {
                                done = true;
                                break;
                            }
                            contents.append(new String(buf));
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        Object var15_18 = null;
                        if (fis != null) {
                            fis.close();
                        }
                        break block18;
                    }
                    Object var15_17 = null;
                    if (fis == null) break block18;
                }
                catch (Throwable throwable) {
                    Object var15_19 = null;
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
            }
        }
        if (contents == null) return this.processCommand(null, in, out);
        return this.processCommand(contents.toString().trim(), in, out);
    }

    private void chooseOpenOrSecurePort(String request) {
        this.isSecure = true;
        if (request.indexOf("-t") >= 0 || request.indexOf("--http") >= 0) {
            this.isSecure = false;
        }
    }

    private void reInitSession(String url) throws SOAPException {
        if (this.cli != null) {
            try {
                this.cli.processCommand("logout");
                this.callObject = new Call();
            }
            catch (Exception e) {
                Trace.verbose((Object)this, "reInitSession", (Throwable)e);
            }
        }
        this.cli = new CLIProxy(url, this.callObject);
    }

    private CommandResult logout(String request, DataInputStream in, DataOutputStream out) throws Exception {
        this.shutDown = true;
        return this.processCommand(request, in, out);
    }

    private String readInput(DataInputStream in, byte[] token) throws IOException {
        String METHOD_NAME = "readInput";
        Trace.methodBegin(this, "readInput");
        int howMany = in.readUnsignedByte();
        Trace.verbose((Object)this, "readInput", "There is " + howMany + " to read.");
        byte[] readArray = null;
        if (howMany >= 0) {
            readArray = new byte[howMany];
            int i = 0;
            while (i < howMany) {
                Trace.verbose((Object)this, "readInput", "Reading " + i);
                readArray[i] = in.readByte();
                ++i;
            }
        } else {
            throw new IOException("Cannot read " + howMany + " characters.");
        }
        String result = Encoder.decode(readArray, token);
        return result;
    }

    private void writeOutput(String str, DataOutputStream out, byte[] token) throws IOException {
        String METHOD_NAME = "writeOutput";
        Trace.methodBegin(this, "writeOutput");
        Trace.verbose((Object)this, "writeOutput", "Writing output " + str);
        byte[] encodedArray = Encoder.encode(str, token);
        int len = encodedArray.length;
        String strLength = String.valueOf(len);
        char[] strLenChars = strLength.toCharArray();
        int lenOfLen = strLenChars.length;
        out.writeByte(lenOfLen);
        int i = 0;
        while (i < lenOfLen) {
            out.writeByte(strLenChars[i]);
            ++i;
        }
        out.flush();
        int i2 = 0;
        while (i2 < len) {
            out.writeByte(encodedArray[i2]);
            ++i2;
        }
        out.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommandResult processCommand(String request, DataInputStream in, DataOutputStream out) throws SOAPException {
        String METHOD_NAME = "processCommand";
        Trace.methodBegin(this, "processCommand");
        CommandResult cr = new CommandResult();
        cr.setRequest(request);
        try {
            cr = this.cli.processCommand(request);
            if (cr.getErrorId().equals("25") && request.indexOf("login") == 0) {
                request = request.substring(0, request.indexOf("--sscsversion"));
                cr = this.cli.processCommand(request);
            }
            if (cr.getErrorId().equals("666")) {
                Trace.verbose((Object)this, "processCommand", "get url contents request: " + cr.getResult());
                return this.processGetUrl(cr.getResult(), request, in, out);
            }
            while (true) {
                if (!cr.getErrorId().equals(LOGIN_CODE) && !cr.getErrorId().equals(LOGIN_NAME)) {
                    return cr;
                }
                this.writeOutput(cr.getErrorId(), out, this.token);
                this.writeOutput(cr.getResult(), out, this.token);
                Trace.verbose((Object)this, "processCommand", ">>>>>>>>>>>>>>>>>>read input");
                request = this.readInput(in, this.token);
                cr = this.cli.processCommand(request);
                if (cr.getResult() == null || cr.getResult().indexOf("parsing error: org.xml.sax.SAXParseException") < 0) continue;
                cr.setErrorId(ERROR_CODE);
                cr.setResult(resource.getString("error.invalid.input"));
            }
        }
        catch (SOAPException e) {
            Trace.verbose((Object)this, "processCommand", "SoapException: " + (Object)((Object)e));
            throw e;
        }
        catch (Exception e) {
            Trace.verbose((Object)this, "processCommand", (Throwable)e);
            String msg = e.getMessage();
            String res = resource.getString("system.error");
            if (msg != null && msg.indexOf("SSLHandshakeException") >= 0) {
                res = resource.getString("SSLHandshakeException");
                if (msg.indexOf("trusted cert") >= 0) {
                    res = res + resource.getString("error.trusted.certificate");
                }
            }
            cr.setResult(res);
            cr.setErrorId(ERROR_CODE);
            return cr;
        }
    }

    private boolean isLocal(Socket client) {
        String METHOD_NAME = "isLocal";
        Trace.methodBegin(this, "isLocal");
        InetAddress clientAddress = client.getInetAddress();
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            Trace.verbose((Object)this, "isLocal", "Exception while trying to get localhost address");
            return false;
        }
        Trace.verbose((Object)this, "isLocal", "Client IP(" + clientAddress.getHostAddress() + ") Hostname(" + clientAddress.getHostName() + ")");
        Trace.verbose((Object)this, "isLocal", "Client: " + clientAddress.getHostAddress());
        if (localhost.getHostAddress().equals(clientAddress.getHostAddress()) || "127.0.0.1".equals(clientAddress.getHostAddress())) {
            Trace.verbose((Object)this, "isLocal", "accepting connection");
            return true;
        }
        Trace.verbose((Object)this, "isLocal", "dropping connection");
        Trace.verbose((Object)this, "isLocal", "Method end.");
        return false;
    }

    public byte[] getToken() {
        return this.token;
    }

    public void setToken(byte[] token) {
        this.token = token;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    private String getEnterpriseSoapUrl() {
        return this.getSoapUrl(SOAP_URI_E, SOAP_SECURE_PORT_E, "9080");
    }

    private String getMidrangeSoapUrl() {
        return this.getSoapUrl(SOAP_URI_MR, SOAP_SECURE_PORT_MR, "9080");
    }

    private String getSoapUrl(String uri, String securePort, String openPort) {
        String soapURI = uri;
        soapURI = this.getSoapProperty("soap.uri", soapURI);
        if (this.isSecure) {
            this.soapProtocol = this.getSoapProperty("soap.secure.protocol", SOAP_SECURE_PROTOCOL);
            this.soapPort = this.getSoapProperty("soap.secure.port", securePort);
        } else {
            this.soapProtocol = this.getSoapProperty("soap.open.protocol", SOAP_OPEN_PROTOCOL);
            this.soapPort = this.getSoapProperty("soap.open.port", openPort);
        }
        String url = this.soapProtocol + "://" + this.soapServer + ":" + this.soapPort + "/" + soapURI;
        Trace.verbose((Object)this, "getSoapUrl", url);
        return url;
    }

    private String getSoapProperty(String property, String defaultValue) {
        String value = System.getProperty(property) == null ? defaultValue : System.getProperty(property);
        return value;
    }

    private void fixNewLine(CommandResult cr) {
        String result;
        if (cr.getResult() != null && !"".equals(result = cr.getResult().trim()) && !result.endsWith("\n")) {
            cr.setResult(result + "\n");
        }
    }

    private void resetServerType() {
        this._serverType = SERVER_TYPE_UNKNOWN;
    }

    private synchronized void setServerType(int type) {
        if (this._serverType != SERVER_TYPE_UNKNOWN) {
            return;
        }
        this._serverType = type;
        Trace.verbose((Object)this, "setServerType", "set server type: " + type);
        this.notifyAll();
    }

    private synchronized int getServerType() {
        if (this._serverType == SERVER_TYPE_UNKNOWN) {
            try {
                this.wait(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Trace.verbose((Object)this, "getServerType", "get server type: " + this._serverType);
        return this._serverType;
    }

    class DoNotVerifyHost
    implements HostnameVerifier {
        DoNotVerifyHost() {
        }

        public boolean verify(String urlHostName, String certHostName) {
            return true;
        }
    }

    private class ConnectionThread
    extends Thread {
        private String _url = null;
        private int _type = -1;

        public ConnectionThread(String url, int type) {
            this._url = url;
            this._type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block12: {
                InputStream is = null;
                URL theUrl = new URL(this._url);
                if (ProxyServerThread.this.isSecure) {
                    System.getProperties().setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                    DoNotVerifyHost dnv = new DoNotVerifyHost();
                    HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)dnv);
                }
                is = theUrl.openStream();
                Object var5_5 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                    break block12;
                }
                catch (Exception e2) {}
                break block12;
                {
                    catch (Exception e) {
                        Trace.verbose((Object)this, this._url, e.toString());
                        Object var5_6 = null;
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            ProxyServerThread.this.setServerType(this._type);
        }
    }
}

