/*
 * Decompiled with CFR 0.152.
 */
package com.sun.providers.tests.t4;

import com.sun.providers.tests.t4.CIMTesterBase;
import java.net.InetAddress;
import java.util.Enumeration;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;

public class CIMModifyStoragePool
extends CIMTesterBase {
    public String extraArgs() {
        return "<array name> <pool name> <hot spare [add/remove/neither]> <desired profile name>";
    }

    public static void main(String[] args) {
        try {
            CIMModifyStoragePool test = new CIMModifyStoragePool(args);
        }
        catch (CIMException e) {
            System.err.println("FAILED: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public CIMModifyStoragePool(String[] args) throws CIMException {
        super(args);
        CIMInstance setting;
        if (args.length != this.baseArgs() + 3 && args.length != this.baseArgs() + 4) {
            this.usage();
            System.exit(1);
        }
        String ipAddr = null;
        try {
            ipAddr = InetAddress.getByName(args[4]).getHostAddress();
            System.out.println("DEBUG: hostname " + args[4] + " = " + ipAddr);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        CIMObjectPath cop = new CIMObjectPath("StorEdge_6120StorageConfigurationService");
        System.out.println("DEBUG: Enumerating " + cop);
        Enumeration services = this.client.enumerateInstances(cop, false, false, true);
        CIMInstance conf = null;
        CIMObjectPath init = null;
        while (services.hasMoreElements()) {
            conf = (CIMInstance)services.nextElement();
            if (!conf.getProperty("SystemName").getValue().getValue().toString().equalsIgnoreCase(ipAddr)) continue;
            System.out.println("Found instance of storageConf: " + cop);
            init = conf.getObjectPath();
            break;
        }
        String poolName = args[5];
        cop = new CIMObjectPath("StorEdge_6120StoragePool");
        System.out.println("DEBUG: Enumerating " + cop);
        Enumeration pools = this.client.enumerateInstances(cop, false, false, true);
        CIMInstance pool = null;
        CIMObjectPath poolOp = null;
        while (pools.hasMoreElements()) {
            pool = (CIMInstance)pools.nextElement();
            if (!pool.getProperty("ElementName").getValue().getValue().toString().equalsIgnoreCase(poolName)) continue;
            System.out.println("Found instance of StoragePool.");
            poolOp = pool.getObjectPath();
            break;
        }
        Enumeration caps = this.client.associators(poolOp, "StorEdge_6120PoolElementCapabilities", "StorEdge_6120PoolStorageCapabilities", null, null, true, false, null);
        CIMInstance ourCaps = (CIMInstance)caps.nextElement();
        CIMProperty spinMin = ourCaps.getProperty("SpindleRedundancyMin");
        CIMProperty spinMax = ourCaps.getProperty("SpindleRedundancyMax");
        int sMin = -1;
        int sMax = -1;
        if (spinMin.getValue() == null || spinMin.getValue().getValue() == null) {
            spinMax = spinMin = ourCaps.getProperty("SpindleRedundancyDefault");
        }
        sMin = Integer.parseInt(spinMin.getValue().getValue().toString());
        sMax = Integer.parseInt(spinMax.getValue().getValue().toString());
        CIMObjectPath oursetting = null;
        Object storSet = null;
        String newProfile = null;
        if (args.length == 8) {
            newProfile = args[7];
        }
        System.out.println(" new profile = " + newProfile);
        String name = args[5];
        cop = new CIMObjectPath("StorEdge_6120StorageSetting");
        System.out.println("DEBUG: Getting CIM Class " + cop);
        CIMClass proto = this.client.getClass(cop, false, true, false, null);
        if (proto == null) {
            System.err.println("FAILED: Unable to get class");
            System.exit(1);
        }
        if ((setting = proto.newInstance()) == null) {
            System.err.println("FAILED: No instance from class");
            System.exit(1);
        }
        int Max = -1;
        int Min = -1;
        if (args[6].equalsIgnoreCase("add")) {
            Max = sMax + 1;
            Min = sMin + 1;
        } else if (args[6].equalsIgnoreCase("remove")) {
            Max = sMax - 1;
            Min = sMin - 1;
        } else if (args[6].equalsIgnoreCase("neither")) {
            Max = sMax;
            Min = sMin;
        }
        setting.setProperty("NoSinglePointOfFailure", ourCaps.getProperty("NoSinglePointOfFailure").getValue());
        setting.setProperty("DataRedundancyMax", ourCaps.getProperty("DataRedundancyMax").getValue());
        setting.setProperty("DataRedundancyMin", ourCaps.getProperty("DataRedundancyMin").getValue());
        setting.setProperty("Description", new CIMValue((Object)newProfile));
        setting.setProperty("SpindleRedundancyMax", new CIMValue((Object)Integer.toString(Max)));
        setting.setProperty("SpindleRedundancyMin", new CIMValue((Object)Integer.toString(Min)));
        System.out.println("New setting for request:");
        System.out.println("Spindle Redundancy Min: " + Min);
        System.out.println("Spindle Redundancy Max: " + Max);
        try {
            oursetting = this.client.createInstance(new CIMObjectPath("StorEdge_6120StorageSetting"), setting);
        }
        catch (CIMException ce) {
            System.out.println("Failed to create the StorageSetting instance: " + setting.toString());
            System.exit(1);
        }
        if (oursetting == null) {
            System.err.println("Could not create our instance of StorageSetting!");
            System.exit(1);
        }
        CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null)), new CIMArgument("Size", new CIMValue(null)), new CIMArgument("Pool")};
        CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("InstanceName", new CIMValue((Object)poolName)), new CIMArgument("Goal", new CIMValue((Object)oursetting)), new CIMArgument("Size", new CIMValue(null)), new CIMArgument("InPools", new CIMValue(null)), new CIMArgument("InExtents", new CIMValue(null)), new CIMArgument("Pool", new CIMValue((Object)poolOp))};
        CIMValue results = null;
        try {
            results = this.client.invokeMethod(init, "CreateOrModifyStoragePool", inArgs, outArgs);
        }
        catch (Exception e) {
            System.out.println("DEBUG: Exception caught: \n");
            e.printStackTrace();
            return;
        }
        System.out.println("Completed: Results are: " + results);
    }
}

