/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.dm.util.logic;

import com.sun.netstorage.mgmt.dm.util.logic.Log;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LogUtil {
    public static final int EMERGENCY = 0;
    public static final int ALERT = 1;
    public static final int CRITICAL = 2;
    public static final int ERROR = 3;
    public static final int WARNING = 4;
    public static final int NOTICE = 5;
    public static final int INFO = 6;
    public static final int DEBUG = 7;
    private static LogUtil log;
    private Log logger;
    private int filterLevel = -1;

    public static synchronized LogUtil getInstance() {
        if (log == null) {
            log = new LogUtil();
        }
        return log;
    }

    public synchronized void setLogger(Log newLog) {
        this.logger = newLog;
    }

    public static void print(Object who, int severity, String message) {
        LogUtil log = LogUtil.getInstance();
        if (log.logger != null && severity <= log.filterLevel) {
            log.logger.print(who, severity, message);
        }
    }

    public static void println(Object who, int severity, String message) {
        LogUtil.print(who, severity, message + "\n");
    }

    public static void printStackTrace(Object who, int severity, Throwable trace) {
        LogUtil log = LogUtil.getInstance();
        if (log.logger != null && severity <= log.filterLevel) {
            StringWriter theTrace = new StringWriter();
            trace.printStackTrace(new PrintWriter(theTrace));
            log.logger.print(who, severity, theTrace.toString());
        }
    }

    public static String sevString(int severity) {
        String msg = "unknown(" + severity + ")";
        switch (severity) {
            case 1: {
                msg = "ALERT: ";
                break;
            }
            case 2: {
                msg = "CRITICAL: ";
                break;
            }
            case 3: {
                msg = "ERROR: ";
                break;
            }
            case 4: {
                msg = "WARNING: ";
                break;
            }
            case 5: {
                msg = "NOTICE: ";
                break;
            }
            case 6: {
                msg = "INFO: ";
                break;
            }
        }
        return msg;
    }

    public static String createMessage(int severity, String message) {
        String msg = "";
        msg = msg + LogUtil.sevString(severity);
        msg = msg + message;
        return msg;
    }

    private LogUtil() {
    }

    public void setFilterLevel(int severity) {
        this.filterLevel = severity;
    }
}

