<?xml version="1.0" encoding="UTF-8"?>
<!-- 
Copyright 2003 Sun Microsystems, Inc.  All rights reserved.
Use is subject to license terms.
"@(#)report.xsl    1.28    03/09/25    SMI" 
-->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xalan="http://xml.apache.org/xslt">
                
<xsl:output method="html" 
            encoding="UTF-8"
            indent="yes" 
            xalan:indent-amount="0"
            xalan:content-handler="org.apache.xalan.serialize.SerializerToHTML"/>
              	
<xsl:template match="/">

<div class="content-layout" >
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td>
      <img border="0" height="8" width="1" src="images/general/dot.gif"/>
    </td>
  </tr>
</table>

<table border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td colspan="3" class="page-separator-line">
      <img border="0" src="images/general/dot.gif" width="1" height="1"/>
    </td>
  </tr>
  <tr> 
    <td>
       <table border="0" cellpadding="0" cellspacing="0" width="100%">
         <tr>
           <td>
             <img height="8" width="10" border="0" src="images/general/dot.gif"/>
	   </td>
	   <td align="left">
	     <b><xsl:value-of select="array-config/health/display-label"/>:</b> 
           </td>
	   <td width="80%" align="left">
             <xsl:value-of select="array-config/health/display-value"/>
	   </td>
         </tr>
      </table>
    </td>
  </tr>
  <tr>
    <td colspan="3" class="page-separator-line">
       <img border="0" src="images/general/dot.gif" width="1" height="1"/>
    </td>
  </tr>
</table>

<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td>
      <img border="0" height="20" width="1" src="images/general/dot.gif"/>
    </td>
  </tr>
</table>
</div>


<div class="content-layout" >
<xsl:for-each select="array-config/array">
   <!-- Array -->
   <table border="0" cellspacing="0" cellpadding="0">
     <tr>
       <td >
         <table border="0" cellspacing="0" cellpadding="0">
	   <tr align="left">
	     <td>
	        <div class="major-category-text">
	           <xsl:value-of select="display-title"/>: <xsl:value-of select="name/display-value"/>
		</div>
             </td>
             <td  valign="bottom" width="90%">
		<table border="0" cellpadding="0" cellspacing="0" width="98%">	
	           <tr>
		      <td class="property-separator">
			<img border="0" src="images/general/dot.gif" width="1" height="2"/>
		      </td>
		   </tr>
		</table>
	     </td>
	   </tr>
	 </table>
       </td>
     </tr>
   </table>

<!-- Array Properties -->
   <table>
      <tr>
         <td ><xsl:value-of select="health/display-label"/>:</td> 
	 <td ><xsl:value-of select="health/display-value"/></td>
      </tr>
      <tr>
         <td ><xsl:value-of select="description/display-label"/>:</td> 
	 <td ><xsl:value-of select="description/display-value"/></td>
      </tr>
      <tr>	
         <td ><xsl:value-of select="firmware-version/display-label"/>:</td> 
	 <td ><xsl:value-of select="firmware-version/display-value"/></td>
      </tr>
      <tr>	
         <td ><xsl:value-of select="segment-size/display-label"/>:</td> 
	 <td ><xsl:value-of select="segment-size/display-value"/></td>
      </tr>
      <tr>
	 <td ><xsl:value-of select="readahead/display-label"/>:</td> 
	 <td ><xsl:value-of select="readahead/display-value"/></td>
      </tr>
      <tr>
         <td ><xsl:value-of select="disk-recon-rate/display-label"/>:</td> 
	 <td ><xsl:value-of select="disk-recon-rate/display-value"/></td>
      </tr>
      <tr>
   	 <td ><xsl:value-of select="failover-mode/display-label"/>:</td> 
	 <td ><xsl:value-of select="failover-mode/display-value"/></td>
      </tr>
      <tr>
	 <td ><xsl:value-of select="cache-mode/display-label"/>:</td> 
	 <td ><xsl:value-of select="cache-mode/display-value"/></td>
      </tr>
      <tr>
         <td ><xsl:value-of select="fc-topology/display-label"/>:</td> 
	 <td ><xsl:value-of select="fc-topology/display-value"/></td>
      </tr>
      <tr>
 	 <td ><xsl:value-of select="fc-port-speed/display-label"/>:</td> 
	 <td ><xsl:value-of select="fc-port-speed/display-value"/></td>
      </tr>
      <tr>
       <td ><xsl:value-of select="hotspare-pool-size/display-label"/>:</td> 
       <td ><xsl:value-of select="hotspare-pool-size/display-value"/></td>
    </tr>
   </table>
  
<xsl:for-each select="tray">
<!-- Section Separator -->
   <table width="98%" border="0"  cellpadding="0" cellspacing="0" >
      <tr>
     	<td>
           <img border="0" height="1" width="5" src="/images/general/dot.gif"/>
	</td>
	<td class="page-separator-line" width="100%">
	   <img border="0" src="images/general/dot.gif" width="1" height="1"/>
	</td>
      </tr>
    </table>
<!-- End Section Separator -->
	
<!-- tray -->
<table border="0">
   <tr>
	<td  colspan="3">
	   <div class="major-category-text">
	       <xsl:value-of select="display-title"/>: 
	       <xsl:value-of select="id/display-value"/>
	   </div>
	</td>
   </tr>
   <tr>
	<td>
           <img border="0" height="1" width="20" src="/images/general/dot.gif"/>
	</td>
	<td>
           <xsl:value-of select="tray-type/display-label"/>:
	</td>
	<td>
	   <xsl:value-of select="tray-type/display-value"/>
	</td>
   </tr>
   <tr>
	<td>
           <img border="0" height="1" width="20" src="/images/general/dot.gif"/>
	</td>
	<td>
           <xsl:value-of select="tray-role/display-label"/>:
	</td>
	<td>
	   <xsl:value-of select="tray-role/display-value"/>
	</td>
   </tr>
   <tr>
	<td>
           <img border="0" height="1" width="20" src="/images/general/dot.gif"/>
	</td>
	<td>
           <xsl:value-of select="tray-state/display-label"/>:
	</td>
	<td>
  	   <xsl:value-of select="tray-state/display-value"/>
	</td>
   </tr>
   <tr>
	<td>
	   <img border="0" height="1" width="20" src="/images/general/dot.gif"/>
	</td>
	<td>
           <xsl:value-of select="tray-status/display-label"/>:
	</td>
	<td>
	   <xsl:value-of select="tray-status/display-value"/>
	</td>
   </tr>
   <tr>
	<td >
	   <img border="0" height="1" width="20" src="/images/general/dot.gif"/>
	</td>
	<td > 
	   <xsl:value-of select="number-of-drives/display-label"/>:
	</td>
	<td>  
           <xsl:value-of select="number-of-drives/display-value"/>
        </td>
   </tr>
   <tr>
	<td>
	    <img border="0" height="1" width="20" src="/images/general/dot.gif"/>
	</td>
	<td>
	    <xsl:value-of select="all-drives-healthy/display-label"/>
	</td>
	<td>  
           <xsl:value-of select="all-drives-healthy/display-value"/>
        </td>
   </tr>
</table>

<!-- Section Separator -->
<table width="98%" border="0"  cellpadding="0" cellspacing="0" >
   <tr>
	<td>
	   <img border="0" height="1" width="20" src="/images/general/dot.gif"/>
	</td>
	<td class="page-separator-line" width="100%">
	   <img border="0" src="images/general/dot.gif" width="1" height="1"/>
	</td>
   </tr>
</table>
<!-- End Section Separator -->
	
<!-- Pool -->
<xsl:for-each select="pool">
<table border="0">
   <tr>
	<td colspan="3" class="table-title-text">
	  <img border="0" height="1" width="20" src="/images/general/dot.gif"/>
          <xsl:value-of select="display-title"/>: <xsl:value-of select="name/display-value"/> 
	</td>
   </tr>
   <tr>
	<td>
	   <img border="0" width="40" height="1" src="/images/general/dot.gif"/>
	</td>
	<td>
	   <xsl:value-of select="raid/display-label"/>       
	</td>
	<td>
           <xsl:value-of select="raid/display-value"/> 
        </td>
   </tr>
   <tr>
	<td>
	    <img border="0" height="1" width="40" src="/images/general/dot.gif"/>
	</td>
	<td>
           <xsl:value-of select="profile/display-label"/> 
	</td>
	<td>
           <xsl:value-of select="profile/display-value"/>
        </td>
   </tr>
   <tr>
	<td>
	   <img border="0" height="1" width="40" src="/images/general/dot.gif"/>
	</td>
	<td> 
		<xsl:value-of select="total-capacity/display-label"/>
	</td>
	<td>
           <xsl:value-of select="total-capacity/display-value"/>
        </td>
   </tr>
   <tr>
	<td>
		<img border="0" height="1" width="40" src="/images/general/dot.gif"/>
	</td>
	<td>
               <xsl:value-of select="available-capacity/display-label"/>
	</td>
	<td><xsl:value-of select="available-capacity/display-value"/></td>
   </tr>
   <tr>
	<td>
            <img border="0" height="1" width="40" src="/images/general/dot.gif"/>
        </td>
	<td>
            <xsl:value-of select="status/display-label"/>:
	</td>
	<td>
            <xsl:value-of select="status/display-value"/>
        </td>
   </tr>
   <tr>
        <td>
            <img border="0" height="1" width="40" src="/images/general/dot.gif"/>
        </td>
        <td>
            <xsl:value-of select="state/display-label"/>:
        </td>
        <td>
            <xsl:value-of select="state/display-value"/>
        </td>
   </tr>    
</table>

<!-- Section Separator -->
<table width="98%" border="0"  cellpadding="0" cellspacing="0" >
   <tr>
	<td>
		<img border="0" height="1" width="5" src="/images/general/dot.gif"/>
	</td>
	<td class="page-separator-line" width="100%">
		<img border="0" src="images/general/dot.gif" width="1" height="1"/>
	</td>
   </tr>
</table>
<!-- End Section Separator -->
	
<!-- Volumes -->
<xsl:for-each select="volume">
<table border="0">
   <tr>
	<td colspan="3" class="table-title-text">
		<img border="0" height="1" width="40" src="/images/general/dot.gif"/>
                <xsl:value-of select="display-title"/>: <xsl:value-of select="name/display-value"/> 
	</td>
   </tr>
   <tr>
	<td>
		<img border="0" width="60" height="1" src="/images/general/dot.gif"/>
	</td>
	<td  >
		<xsl:value-of select="size/display-label"/>:        
	</td>
	<td> 
		<xsl:value-of select="size/display-value"/>
  	</td>
  </tr>
  <tr>
	<td>
		<img border="0" height="1" width="60" src="/images/general/dot.gif"/>
	</td>
	<td>
		<xsl:value-of select="default-permissions/display-label"/>:
	</td>
	<td>
            <xsl:value-of select="default-permissions/display-value"/>
        </td>
   </tr>
   <tr>
	<td>
		<img border="0" height="1" width="60" src="/images/general/dot.gif"/>
	</td>
	<td > 
		<xsl:value-of select="lun/display-label"/>:
	</td>
	<td>
	    <xsl:value-of select="lun/display-value"/>
	</td>
  </tr>
  <tr>
	<td>
		<img border="0" height="1" width="60" src="/images/general/dot.gif"/>
	</td>
	<td  valign="top" colspan="2" class="table-title-text">
	    <xsl:value-of select="member-of-volume-groups/display-label"/>				
	</td>
        <xsl:for-each select="volume-group-name">
        <tr>
	   <td colspan="3">
	      <img border="0" height="1" width="80" src="/images/general/dot.gif"/>
		<xsl:value-of select="display-value"/>
	   </td>
        </tr>
        </xsl:for-each>
  </tr> 
</table>  
</xsl:for-each> <!-- volume -->
</xsl:for-each> <!-- pool -->
<!-- Disks -->
<xsl:for-each select="disk">
<table border="0">
   <tr>
	<td colspan="3" class="table-title-text">
	   <img border="0" height="1" width="20" src="/images/general/dot.gif"/>
           <xsl:value-of select="display-title"/>: <xsl:value-of select="name/display-value"/> 
	</td>
   </tr>
   <tr>
	<td>
	   <img border="0" width="40" height="1" src="/images/general/dot.gif"/>
	</td>
	<td>
	   <xsl:value-of select="capacity/display-label"/>       
	</td>
	<td> 
           <xsl:value-of select="capacity/display-value"/> 
        </td>
   </tr>
   <tr>
	<td>
	    <img border="0" height="1" width="40" src="/images/general/dot.gif"/>
	</td>
	<td>
           <xsl:value-of select="status/display-label"/> 
	</td>
	<td>
           <xsl:value-of select="status/display-value"/>
        </td>
   </tr>
   <tr>
	<td>
	    <img border="0" height="1" width="40" src="/images/general/dot.gif"/>
	</td>
	<td> 
	    <xsl:value-of select="state/display-label"/>
	</td>
	<td> 
            <xsl:value-of select="state/display-value"/>
        </td>
   </tr>
   <tr>
	<td>
	    <img border="0" height="1" width="40" src="/images/general/dot.gif"/>
	</td>
	<td>
            <xsl:value-of select="role/display-label"/>
	</td>
	<td>
            <xsl:value-of select="role/display-value"/>
        </td>
   </tr>
</table>
</xsl:for-each> <!-- disk -->

<!-- End Disks -->

</xsl:for-each> <!-- tray -->

<!-- Section Separator -->
<table width="98%" border="0"  cellpadding="0" cellspacing="0" >
   <tr>
	<td>
		<img border="0" height="1" width="5" src="/images/general/dot.gif"/>
	</td>
	<td class="page-separator-line" width="100%">
		<img border="0" src="images/general/dot.gif" width="1" height="1"/>
	</td>
   </tr>
</table>
<!-- End Section Separator -->
	
<!-- Volume groups -->
<xsl:for-each select="volume-group">
<table border="0">
  <tr>
	<td colspan="3">
		<img border="0" height="1" width="10" src="/images/general/dot.gif"/>
	</td>
  </tr>
  <tr>
	<td class="table-title-text" colspan="2">
		<img border="0" height="1" width="10" src="/images/general/dot.gif"/>
                <xsl:value-of select="display-title"/>: 
        </td>
        <td>
           	<xsl:value-of select="name/display-value"/> 
	</td>
  </tr>
  <tr>
	<td class="table-title-text" colspan="2">
		<img border="0" height="1" width="20" src="/images/general/dot.gif"/>
                <xsl:value-of select="volumes/display-title"/> 
        </td>
  </tr>
  <xsl:for-each select="volumes/volume">
  <tr>
 	<td colspan="1">
		<img border="0" height="1" width="30" src="/images/general/dot.gif"/>
              	<xsl:value-of select="display-title"/> 
	</td>
	<td colspan="2">
		<img border="0" height="1" width="40" src="/images/general/dot.gif"/>
              	<xsl:value-of select="name/display-value"/> 
	</td>
  </tr>
  </xsl:for-each>
  <tr>
	<td class="table-title-text" colspan="2">
		<img border="0" height="1" width="20" src="/images/general/dot.gif"/>
                <xsl:value-of select="initiator-groups/display-title"/> 
        </td>
  </tr>
  <xsl:for-each select="initiator-groups/initiator-group">
  <tr>
	<td colspan="3">
		<img border="0" width="30" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="display-title"/> 
	</td>
  </tr>
  <tr>
	<td>
		<img border="0" width="40" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="name/display-label"/>
	</td>
	<td colspan="2">
		<xsl:value-of select="name/display-value"/> 
	</td>
  </tr>
  <tr>
	<td>
		<img border="0" width="40" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="permission/display-label"/>
	</td>
	<td colspan="2">
		<xsl:value-of select="permission/display-value"/>
	</td>
  </tr>
  <tr>
	<td colspan="3">
		<img border="0" width="40" height="1" src="/images/general/dot.gif"/>
	</td>
  </tr>
  </xsl:for-each>
</table>
</xsl:for-each> <!-- volume groups -->

<!-- Section Separator -->
<table width="98%" border="0"  cellpadding="0" cellspacing="0" >
  <tr>
	<td>
		<img border="0" height="1" width="5" src="/images/general/dot.gif"/>
	</td>
	<td class="page-separator-line" width="100%">
		<img border="0" src="images/general/dot.gif" width="1" height="1"/>
	</td>
  </tr>
</table>
<!-- End Section Separator -->
	
<!-- Initiatir groups -->
<xsl:for-each select="initiator-group">
<table border="0">
   <tr>
	<td colspan="3">
		<img border="0" height="1" width="10" src="/images/general/dot.gif"/>
	</td>
  </tr>
  <tr>
	<td class="table-title-text" colspan="3">
		<img border="0" height="1" width="10" src="/images/general/dot.gif"/>
                <xsl:value-of select="display-title"/>: 
               	<xsl:value-of select="name/display-value"/> 
	</td>
  </tr>
  <xsl:for-each select="initiator">
  <tr>
	<td class="table-title-text" colspan="3">
 	    <img border="0" height="1" width="20" src="/images/general/dot.gif"/>
       	    <xsl:value-of select="display-title"/>: 
 	</td>
  </tr>
  <tr>
	<td>
	   <img border="0" height="1" width="30" src="/images/general/dot.gif"/>
           <xsl:value-of select="wwn/display-label"/> 
	</td>
	<td colspan="2">
              	<xsl:value-of select="wwn/display-value"/> 
	</td>
  </tr>
  <tr>
	<td>
		<img border="0" height="1" width="30" src="/images/general/dot.gif"/>
              	<xsl:value-of select="description/display-label"/> 
	</td>
	<td colspan="2">
              	<xsl:value-of select="description/display-value"/> 
	</td>
  </tr>
  </xsl:for-each>
  <xsl:for-each select="volume-group">
  <tr>
	<td class="table-title-text" colspan="3">
	   <img border="0" height="1" width="20" src="/images/general/dot.gif"/>
           <xsl:value-of select="display-title"/>: 
 	</td>
  </tr>
  <tr>
	<td>
		<img border="0" width="30" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="name/display-label"/>
	</td>
	<td colspan="2">
		<xsl:value-of select="name/display-value"/> 
	</td>
  </tr>
  <tr>
	<td>
		<img border="0" width="30" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="permission/display-label"/>
	</td>
	<td colspan="2">
		<xsl:value-of select="permission/display-value"/>
	</td>
  </tr>
  <tr>
	<td colspan="3">
		<img border="0" width="30" height="1" src="/images/general/dot.gif"/>
	</td>
  </tr>
  </xsl:for-each>
</table>
</xsl:for-each> <!-- initiator group -->

<!-- Section Separator -->
<table width="98%" border="0"  cellpadding="0" cellspacing="0" >
  <tr>
	<td>
		<img border="0" height="1" width="5" src="/images/general/dot.gif"/>
	</td>
	<td class="page-separator-line" width="100%">
		<img border="0" src="images/general/dot.gif" width="1" height="1"/>
	</td>
  </tr>
</table>
<!-- End Section Separator -->
	

<!-- Initiators -->
<xsl:for-each select="initiator">
<table border="0">
   <tr>
	<td colspan="3">
		<img border="0" height="1" width="10" src="/images/general/dot.gif"/>
	</td>
   </tr>
   <tr>
	<td class="table-title-text" colspan="3">
		<img border="0" height="1" width="10" src="/images/general/dot.gif"/>
           <xsl:value-of select="display-title"/>: 
	</td>
  </tr>
  <tr>
	<td>
		<img border="0" height="1" width="30" src="/images/general/dot.gif"/>
          	<xsl:value-of select="wwn/display-label"/> 
	</td>
	<td colspan="2">
          	<xsl:value-of select="wwn/display-value"/> 
	</td>
  </tr>
  <tr>
	<td>
		<img border="0" height="1" width="30" src="/images/general/dot.gif"/>
            	<xsl:value-of select="description/display-label"/> 
	</td>
	<td colspan="2">
          	<xsl:value-of select="description/display-value"/> 
	</td>
  </tr>
</table>
</xsl:for-each> <!-- initiator -->


</xsl:for-each> <!-- array -->


<!-- Section Separator -->
<table width="98%" border="0"  cellpadding="0" cellspacing="0" >
  <tr>
	<td>
		<img border="0" height="1" width="5" src="/images/general/dot.gif"/>
	</td>
	<td class="page-separator-line" width="100%">
		<img border="0" src="images/general/dot.gif" width="1" height="1"/>
	</td>
  </tr>
</table>
<!-- End Section Separator -->	
<!-- Profiles-->
<table border="0" cellspacing="0" cellpadding="0">
  <tr align="left">
     <td nowrap="nowrap">
        <div class="major-category-text">
           <xsl:value-of select="array-config/profiles/display-title"/>
        </div>
     </td>
  </tr>
</table>

<xsl:for-each select="array-config/profiles/profile-component">
<table border="0">
   <tr>
	<td colspan="3" class="table-title-text">
	   <img border="0" height="1" width="20" src="/images/general/dot.gif"/>
           <xsl:value-of select="display-title"/>: <xsl:value-of select="name/display-value"/> 
	</td>
   </tr>
   <tr>
	<td>
	   <img border="0" width="40" height="1" src="/images/general/dot.gif"/>
	</td>
	<td>
	   <xsl:value-of select="description/display-label"/>       
	</td>
	<td> 
           <xsl:value-of select="description/display-value"/> 
        </td>
   </tr>
   <tr>
	<td>
	   <img border="0" width="40" height="1" src="/images/general/dot.gif"/>
	</td>
	<td>
	   <xsl:value-of select="raid-level/display-label"/>       
	</td>
	<td> 
           <xsl:value-of select="raid-level/display-value"/> 
        </td>
   </tr>
   <tr>
	<td>
	   <img border="0" width="40" height="1" src="/images/general/dot.gif"/>
	</td>
	<td>
	   <xsl:value-of select="segment-size/display-label"/>       
	</td>
	<td> 
           <xsl:value-of select="segment-size/display-value"/> 
        </td>
   </tr>
   <tr>
	<td>
	   <img border="0" width="40" height="1" src="/images/general/dot.gif"/>
	</td>
	<td>
	   <xsl:value-of select="readahead/display-label"/>       
	</td>
	<td> 
           <xsl:value-of select="readahead/display-value"/> 
        </td>
   </tr>
   <tr>
	<td>
	   <img border="0" width="40" height="1" src="/images/general/dot.gif"/>
	</td>
	<td>
	   <xsl:value-of select="number-drives/display-label"/>       
	</td>
	<td> 
           <xsl:value-of select="number-drives/display-value"/> 
        </td>
   </tr>
   <tr>
	<td>
	   <img border="0" width="40" height="1" src="/images/general/dot.gif"/>
	</td>
	<td>
	   <xsl:value-of select="array-type/display-label"/>       
	</td>
	<td> 
           <xsl:value-of select="array-type/display-value"/> 
        </td>
   </tr>
   <tr>
	<td>
	   <img border="0" width="40" height="1" src="/images/general/dot.gif"/>
	</td>
	<td>
	   <xsl:value-of select="dedicated-hotspare/display-label"/>       
	</td>
	<td> 
           <xsl:value-of select="dedicated-hotspare/display-value"/> 
        </td>
   </tr>
</table>
</xsl:for-each>


<!-- Section Separator -->

<table width="98%" border="0"  cellpadding="0" cellspacing="0" >
   <tr>
	<td>
	   <img border="0" height="1" width="5" src="/images/general/dot.gif"/>
	</td>
	<td class="page-separator-line" width="100%">
	   <img border="0" src="images/general/dot.gif" width="1" height="1"/>
	</td>
   </tr>
</table>
<!-- End Section Separator -->

<!-- Admin -->
<table border="0">
  <tr>
	<td colspan="3">
           <img border="0" width="10" height="1" src="/images/general/dot.gif"/>
	</td>
  </tr>
  <tr>
	<td class="table-title-text" colspan="3">
	   <img border="0" width="10" height="1" src="/images/general/dot.gif"/>
	      <div class="major-category-text">
	          <xsl:value-of select="array-config/admin/display-title"/>
              </div>
	</td>
  </tr>
  <!-- SYSTEM -->
  <tr>
	<td class="table-title-text" colspan="3">
		<img border="0" width="20" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/system/display-title"/>
	</td>
  </tr>
  <tr>
	<td>
		<img border="0" width="30" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/system/id/display-label"/>
	</td>
	<td colspan="2">
		<xsl:value-of select="array-config/admin/system/id/display-value"/>
	</td>
  </tr>
  <tr>
	<td>
		<img border="0" width="30" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/system/description/display-label"/>
	</td>
	<td colspan="3">
		<xsl:value-of select="array-config/admin/system/description/display-value"/>
	</td>
  </tr>
  <tr>
	<td>
		<img border="0" width="30" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/system/vendor/display-label"/>
	</td>
	<td colspan="3">
		<xsl:value-of select="array-config/admin/system/vendor/display-value"/>
	</td>
  </tr>
  <tr>
	<td>
		<img border="0" width="30" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/system/model/display-label"/>
	</td>
	<td colspan="3">
		<xsl:value-of select="array-config/admin/system/model/display-value"/>
	</td>
  </tr>
  <!-- NETWORK -->
  <tr>
	<td colspan="3">
		<img border="0" width="20" height="1" src="/images/general/dot.gif"/>
	</td>
  </tr>
  <tr>
	<td class="table-title-text" colspan="3">
		<img border="0" width="20" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/network/display-title"/>
	</td>
  </tr>
  <tr>
	<td>
		<img border="0" width="30" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/network/ip-assignment/display-label"/>
	</td>
	<td colspan="2">
		<xsl:value-of select="array-config/admin/network/ip-assignment/display-value"/>
	</td>
  </tr>		
  <tr>
	<td>
		<img border="0" width="30" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/network/ip/display-label"/>
	</td>
	<td colspan="2">
		<xsl:value-of select="array-config/admin/network/ip/display-value"/>
	</td>
  </tr>		
  <tr>
	<td>
		<img border="0" width="30" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/network/netmask/display-label"/>
	</td>
	<td colspan="2">
		<xsl:value-of select="array-config/admin/network/netmask/display-value"/>
	</td>
  </tr>		
  <tr>
	<td>
		<img border="0" width="30" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/network/gateway/display-label"/>
	</td>
	<td colspan="2">
		<xsl:value-of select="array-config/admin/network/gateway/display-value"/>
	</td>
  </tr>		
  <tr>
	<td>
		<img border="0" width="30" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/network/nameserver/display-label"/>
	</td>
	<td colspan="2">
		<xsl:value-of select="array-config/admin/network/nameserver/display-value"/>
	</td>
  </tr>		
  <tr>
	<td>
		<img border="0" width="30" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/network/domainname/display-label"/>
	</td>
	<td colspan="2">
		<xsl:value-of select="array-config/admin/network/domainname/display-value"/>
	</td>
  </tr>		
  <!-- Contact -->
  <tr>
	<td colspan="3">
		<img border="0" width="20" height="1" src="/images/general/dot.gif"/>
	</td>
  </tr>
  <tr>
	<td class="table-title-text" colspan="3">
		<img border="0" width="20" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/contact/display-title"/>
	</td>
  </tr>
  <tr>
	<td>
		<img border="0" width="30" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/contact/email/display-label"/>
	</td>
	<td colspan="2">
		<xsl:value-of select="array-config/admin/contact/email/display-value"/>
	</td>
  </tr>		
  <!-- Time -->
  <tr>
	<td colspan="3">
		<img border="0" width="20" height="1" src="/images/general/dot.gif"/>
	</td>
  </tr>
  <tr>
	<td class="table-title-text" colspan="3">
		<img border="0" width="20" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/time/display-title"/>
	</td>
  </tr>
  <tr>
	<td>
		<img border="0" width="30" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/time/current-system-time/display-label"/>
	</td>
	<td colspan="2">
		<xsl:value-of select="array-config/admin/time/current-system-time/display-value"/>
	</td>
  </tr>		
  <tr>
	<td>
		<img border="0" width="30" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/time/time-zone/display-label"/>
	</td>
	<td colspan="2">
		<xsl:value-of select="array-config/admin/time/time-zone/display-value"/>
	</td>
  </tr>		
  <tr>
	<td class="table-title-text" colspan="3">
		<img border="0" width="40" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/time/settings/display-title"/>
	</td>
  </tr>		
  <tr>
	<td class="table-title-text" colspan="3">
		<img border="0" width="50" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/time/settings/ntp/display-title"/>
	</td>
  </tr>		
  <tr>
	<td>
		<img border="0" width="60" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/time/settings/ntp/ntp-ip/display-label"/>
	</td>
	<td colspan="2">
		<xsl:value-of select="array-config/admin/time/settings/ntp/ntp-ip/display-value"/>
	</td>
  </tr>	
  <!-- Port Filtering -->
  <tr>
	<td colspan="3">
		<img border="0" width="20" height="1" src="/images/general/dot.gif"/>
	</td>
  </tr>
  <tr>
	<td class="table-title-text" colspan="3">
		<img border="0" width="20" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="array-config/admin/port-filtering/display-title"/>
	</td>
  </tr>	
  <xsl:for-each select="array-config/admin/port-filtering/app">
  <tr>
	<td class="table-title-text">	
  	    <img border="0" width="30" height="1" src="/images/general/dot.gif"/>
	    <xsl:value-of select="name/display-label"/>
	</td>
	<td colspan="2">
		<xsl:value-of select="name/display-value"/>
	</td>
  </tr>
  <tr>
	<td>	
		<img border="0" width="40" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="port/display-label"/>
	</td>
	<td colspan="2">
		<xsl:value-of select="port/display-value"/>
	</td>
  </tr>
  <tr>
	<td>	
		<img border="0" width="40" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="port-enabled/display-label"/>
	</td>
	<td colspan="2">
		<xsl:value-of select="port-enabled/display-value"/>
	</td>
  </tr>
  <tr>
	<td>	
		<img border="0" width="40" height="1" src="/images/general/dot.gif"/>
		<xsl:value-of select="direction/display-label"/>
	</td>
	<td colspan="2">
		<xsl:value-of select="direction/display-value"/>
	</td>
  </tr>
  <tr>
	<td colspan="3">	
		<img border="0" width="40" height="1" src="/images/general/dot.gif"/>
	</td>
  </tr>
  </xsl:for-each>
</table>
</div>
</xsl:template>
</xsl:stylesheet>
