<%--
/*
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * 
 *  Use is subject to license terms.
 * 
 *  "@(#)admin_expansion_wiz_jobs.jsp     1.5     03/09/25     SMI"
 */
--%>
<%@ include file="/layout/toptags.jsp"%>
<!-- locale stuff -->
<html:html locale="true">
<!-- end locale -->

<!-- Place Java Script Here -->

<!-- HTML -->
<head>
<%@include file="/layout/page_head_section.jsp"%>
</head>
<%@ include file="/layout/wizard_body_tag.jsp" %>
<%@ include file="/layout/user_messages.jsp"%>


<%
    T4Interface t4 = 
      (T4Interface) 
        session.getAttribute(Constants.HttpSessionFields.CURRENT_T4);

    // this page is used by both the add and remove expansion
    //  wizards
    // this code will determine which action to use
    // set it to remove by default
    String formAction = "/RemoveExpansionWizard.do";
    // if the boot_r feature is supported, use the
    //   remove wizard with no rarp page
    if(t4 != null &&
       t4.isFeatureSupported(Constants.SupportedFeature.FEATURE_BOOT_R)) {
       formAction = "/RemoveExpansionWizardNoRarp.do";
    }

    String isAdd = 
      (String)session.getAttribute(Constants.HttpSessionFields.IS_ADD_EXPANSION);
    if("true".equals(isAdd)) {
      formAction = "/AddExpansionWizard.do";
    }
%>
<html:form action="<%=formAction%>">


<%@ include file="/wizard/wizard_framework_fields.jsp"%>
<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr class="wizard-content-title-row">

    <td>
      <div class="wizard-content-title-text">
        <bean:message key="expansion.actives.header"/>
      </div>
    </td>
  </tr>
  <tr>
    <td class="wizard-content-divider"><img alt width="1" height="1" src="/images/general/dot.gif" border="0"></td>
  </tr>

</table>
<!-- spacer between two sections -->
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><img alt border="0" height="20" width="1" src="images/general/dot.gif"></td>
  </tr>
</table>

<!-- only show the instructions if there are active jobs -->
<logic:present name="Expansion" property="activeJobs">
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">   
  <tr>
   <td>
      <bean:message key="expansion.actives.instructions"/>
   </td>
  </tr>
</table>
</logic:present>

<!-- spacer between two sections -->
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
    <td><img alt border="0" height="20" width="1" src="images/general/dot.gif"></td>
  </tr>
  <tr>
    <td>
      <div class="major-category-text">
        <bean:message key="expansion.active.jobs"/>
      </div>
    </td>
  </tr>
  
  <tr>
    <td><img alt width="1" height="8" border="0" src="images/general/dot.gif"></td>
  </tr>
</table>
<table class="back-table" border="0" cellspacing="0" cellpadding="1" >
    <tr>
    <td>
      <table class="front-table" border="0" cellspacing="0" cellpadding="0" >

        <tr class="header-row">
          <td>
            <div class="table-header-text">
              <bean:message key="expansion.active.jobs.table.id"/>
            </div>
          </td>
          <td>
            <div class="table-header-text">
              <bean:message key="expansion.active.jobs.table.desc"/>
            </div>
          </td>
          <td>
            <div class="table-header-text">
              <bean:message key="expansion.active.jobs.table.percentcomplete"/>
            </div>
          </td>
          <td>
            <div class="table-header-text">
              <bean:message key="expansion.active.jobs.table.status"/>
            </div>
          </td>
        </tr>
        <!-- jobs data rows -->
        <logic:present name="Expansion" property="activeJobs">
          <logic:iterate id="job" name="Expansion" property="activeJobs" type="JobInterface">
          <tr>
            <td>
              <div class="table-normal-text">
               <bean:write name="job" property="id"/>
              </div>
            </td>
            <td>
              <div class="table-normal-text">
                <component:partialTextDisplay textLength="35" 
                text='<%=job.getDescription()%>' />
              </div>
            </td>
            <td>
              <div class="table-normal-text">
               <bean:write name="job" property="percentComplete"/>
              </div>
            </td>
            <td>
              <div class="table-normal-text">
                <component:partialTextDisplay textLength="35" text='<%=job.getStatusKey()%>' />
              </div>
            </td>
          </tr>
          </logic:iterate>
        </logic:present>
        <logic:notPresent name="Expansion" property="activeJobs">
          <tr>
            <td colspan="4">
              <div class="table-normal-text">
                <bean:message key="expansion.no.active.jobs.data"/>
              </div>
            </td>
          </tr> 
        </logic:notPresent>
       <!-- end jobs data rows-->
      </table>
    </td>
  </tr>
</table><!-- end back-table -->

<!-- spacer between two sections -->
<table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" width="100%">

  <tr>
    <td><img alt border="0" height="20" width="1" src="images/general/dot.gif"></td>
  </tr>
</table>

</div>

</html:form>
</body>

</html:html>
